# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.get_alerts200_response_all_of_checks_inner import GetAlerts200ResponseAllOfChecksInner
from morpheus.models.get_alerts200_response_all_of_checks_inner_account import GetAlerts200ResponseAllOfChecksInnerAccount
from typing import Optional, Set
from typing_extensions import Self

class GetCheckApps200ResponseOpenIncidentsInner(BaseModel):
    """
    GetCheckApps200ResponseOpenIncidentsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    account: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = None
    app: Optional[StrictStr] = None
    auto_close: Optional[StrictBool] = Field(default=None, alias="autoClose")
    channel_id: Optional[StrictStr] = Field(default=None, alias="channelId")
    check_groups: Optional[List[GetAlerts200ResponseAllOfCheckGroupsInnerInstance]] = Field(default=None, alias="checkGroups")
    checks: Optional[List[GetAlerts200ResponseAllOfChecksInner]] = None
    comment: Optional[StrictStr] = None
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    duration: Optional[StrictStr] = None
    end_date: Optional[datetime] = Field(default=None, alias="endDate")
    in_uptime: Optional[StrictBool] = Field(default=None, alias="inUptime")
    muted: Optional[StrictBool] = None
    last_check_time: Optional[datetime] = Field(default=None, alias="lastCheckTime")
    last_error: Optional[StrictStr] = Field(default=None, alias="lastError")
    last_message: Optional[StrictStr] = Field(default=None, alias="lastMessage")
    name: Optional[StrictStr] = None
    resolution: Optional[StrictStr] = None
    severity: Optional[StrictStr] = None
    severity_id: Optional[StrictInt] = Field(default=None, alias="severityId")
    start_date: Optional[datetime] = Field(default=None, alias="startDate")
    status: Optional[StrictStr] = None
    visibility: Optional[StrictStr] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "account", "app", "autoClose", "channelId", "checkGroups", "checks", "comment", "displayName", "duration", "endDate", "inUptime", "muted", "lastCheckTime", "lastError", "lastMessage", "name", "resolution", "severity", "severityId", "startDate", "status", "visibility"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetCheckApps200ResponseOpenIncidentsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in check_groups (list)
        _items = []
        if self.check_groups:
            for _item_check_groups in self.check_groups:
                if _item_check_groups:
                    _items.append(_item_check_groups.to_dict())
            _dict['checkGroups'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in checks (list)
        _items = []
        if self.checks:
            for _item_checks in self.checks:
                if _item_checks:
                    _items.append(_item_checks.to_dict())
            _dict['checks'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if app (nullable) is None
        # and model_fields_set contains the field
        if self.app is None and "app" in self.model_fields_set:
            _dict['app'] = None

        # set to None if comment (nullable) is None
        # and model_fields_set contains the field
        if self.comment is None and "comment" in self.model_fields_set:
            _dict['comment'] = None

        # set to None if duration (nullable) is None
        # and model_fields_set contains the field
        if self.duration is None and "duration" in self.model_fields_set:
            _dict['duration'] = None

        # set to None if end_date (nullable) is None
        # and model_fields_set contains the field
        if self.end_date is None and "end_date" in self.model_fields_set:
            _dict['endDate'] = None

        # set to None if last_message (nullable) is None
        # and model_fields_set contains the field
        if self.last_message is None and "last_message" in self.model_fields_set:
            _dict['lastMessage'] = None

        # set to None if resolution (nullable) is None
        # and model_fields_set contains the field
        if self.resolution is None and "resolution" in self.model_fields_set:
            _dict['resolution'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetCheckApps200ResponseOpenIncidentsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "account": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "app": obj.get("app"),
            "autoClose": obj.get("autoClose"),
            "channelId": obj.get("channelId"),
            "checkGroups": [GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(_item) for _item in obj["checkGroups"]] if obj.get("checkGroups") is not None else None,
            "checks": [GetAlerts200ResponseAllOfChecksInner.from_dict(_item) for _item in obj["checks"]] if obj.get("checks") is not None else None,
            "comment": obj.get("comment"),
            "displayName": obj.get("displayName"),
            "duration": obj.get("duration"),
            "endDate": obj.get("endDate"),
            "inUptime": obj.get("inUptime"),
            "muted": obj.get("muted"),
            "lastCheckTime": obj.get("lastCheckTime"),
            "lastError": obj.get("lastError"),
            "lastMessage": obj.get("lastMessage"),
            "name": obj.get("name"),
            "resolution": obj.get("resolution"),
            "severity": obj.get("severity"),
            "severityId": obj.get("severityId"),
            "startDate": obj.get("startDate"),
            "status": obj.get("status"),
            "visibility": obj.get("visibility")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


