# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_cloud_resource_pool200_response_resource_pool_all_of_config import AddCloudResourcePool200ResponseResourcePoolAllOfConfig
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_cloud_datastores200_response_all_of_datastores_inner_resource_permission import ListCloudDatastores200ResponseAllOfDatastoresInnerResourcePermission
from typing import Optional, Set
from typing_extensions import Self

class GetCloudResourcePools200ResponseAllOfResourcePool(BaseModel):
    """
    GetCloudResourcePools200ResponseAllOfResourcePool
    """ # noqa: E501
    id: Optional[StrictInt] = None
    description: Optional[StrictStr] = None
    zone: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    parent: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    type: Optional[StrictStr] = None
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    region_code: Optional[StrictStr] = Field(default=None, alias="regionCode")
    iac_id: Optional[StrictStr] = Field(default=None, alias="iacId")
    visibility: Optional[StrictStr] = None
    read_only: Optional[StrictBool] = Field(default=None, alias="readOnly")
    default_pool: Optional[StrictBool] = Field(default=None, alias="defaultPool")
    active: Optional[StrictBool] = None
    status: Optional[StrictStr] = None
    inventory: Optional[StrictBool] = None
    config: Optional[AddCloudResourcePool200ResponseResourcePoolAllOfConfig] = None
    name: Optional[StrictStr] = None
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    tenants: Optional[List[GetAlerts200ResponseAllOfCheckGroupsInnerInstance]] = None
    resource_permission: Optional[ListCloudDatastores200ResponseAllOfDatastoresInnerResourcePermission] = Field(default=None, alias="resourcePermission")
    depth: Optional[StrictInt] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "description", "zone", "parent", "type", "externalId", "regionCode", "iacId", "visibility", "readOnly", "defaultPool", "active", "status", "inventory", "config", "name", "displayName", "tenants", "resourcePermission", "depth"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetCloudResourcePools200ResponseAllOfResourcePool from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of zone
        if self.zone:
            _dict['zone'] = self.zone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of parent
        if self.parent:
            _dict['parent'] = self.parent.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tenants (list)
        _items = []
        if self.tenants:
            for _item_tenants in self.tenants:
                if _item_tenants:
                    _items.append(_item_tenants.to_dict())
            _dict['tenants'] = _items
        # override the default output from pydantic by calling `to_dict()` of resource_permission
        if self.resource_permission:
            _dict['resourcePermission'] = self.resource_permission.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if region_code (nullable) is None
        # and model_fields_set contains the field
        if self.region_code is None and "region_code" in self.model_fields_set:
            _dict['regionCode'] = None

        # set to None if iac_id (nullable) is None
        # and model_fields_set contains the field
        if self.iac_id is None and "iac_id" in self.model_fields_set:
            _dict['iacId'] = None

        # set to None if display_name (nullable) is None
        # and model_fields_set contains the field
        if self.display_name is None and "display_name" in self.model_fields_set:
            _dict['displayName'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetCloudResourcePools200ResponseAllOfResourcePool from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "description": obj.get("description"),
            "zone": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["zone"]) if obj.get("zone") is not None else None,
            "parent": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["parent"]) if obj.get("parent") is not None else None,
            "type": obj.get("type"),
            "externalId": obj.get("externalId"),
            "regionCode": obj.get("regionCode"),
            "iacId": obj.get("iacId"),
            "visibility": obj.get("visibility"),
            "readOnly": obj.get("readOnly"),
            "defaultPool": obj.get("defaultPool"),
            "active": obj.get("active"),
            "status": obj.get("status"),
            "inventory": obj.get("inventory"),
            "config": AddCloudResourcePool200ResponseResourcePoolAllOfConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "name": obj.get("name"),
            "displayName": obj.get("displayName"),
            "tenants": [GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(_item) for _item in obj["tenants"]] if obj.get("tenants") is not None else None,
            "resourcePermission": ListCloudDatastores200ResponseAllOfDatastoresInnerResourcePermission.from_dict(obj["resourcePermission"]) if obj.get("resourcePermission") is not None else None,
            "depth": obj.get("depth")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


