# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from morpheus.models.get_container200_response_container_container_type import GetContainer200ResponseContainerContainerType
from morpheus.models.get_container200_response_container_container_type_set import GetContainer200ResponseContainerContainerTypeSet
from morpheus.models.get_container200_response_container_instance import GetContainer200ResponseContainerInstance
from morpheus.models.get_container200_response_container_plan import GetContainer200ResponseContainerPlan
from morpheus.models.get_container200_response_container_ports_inner import GetContainer200ResponseContainerPortsInner
from morpheus.models.get_container200_response_container_stats import GetContainer200ResponseContainerStats
from typing import Optional, Set
from typing_extensions import Self

class GetContainer200ResponseContainer(BaseModel):
    """
    GetContainer200ResponseContainer
    """ # noqa: E501
    id: Optional[StrictInt] = None
    uuid: Optional[StrictStr] = None
    account_id: Optional[StrictInt] = Field(default=None, alias="accountId")
    instance: Optional[GetContainer200ResponseContainerInstance] = None
    container_type: Optional[GetContainer200ResponseContainerContainerType] = Field(default=None, alias="containerType")
    container_type_set: Optional[GetContainer200ResponseContainerContainerTypeSet] = Field(default=None, alias="containerTypeSet")
    server: Optional[GetContainer200ResponseContainerInstance] = None
    cloud: Optional[GetContainer200ResponseContainerInstance] = None
    name: Optional[StrictStr] = None
    ip: Optional[StrictStr] = None
    internal_ip: Optional[StrictStr] = Field(default=None, alias="internalIp")
    internal_hostname: Optional[StrictStr] = Field(default=None, alias="internalHostname")
    external_hostname: Optional[StrictStr] = Field(default=None, alias="externalHostname")
    external_domain: Optional[StrictStr] = Field(default=None, alias="externalDomain")
    external_fqdn: Optional[StrictStr] = Field(default=None, alias="externalFqdn")
    ports: Optional[List[GetContainer200ResponseContainerPortsInner]] = None
    plan: Optional[GetContainer200ResponseContainerPlan] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    stats_enabled: Optional[StrictBool] = Field(default=None, alias="statsEnabled")
    status: Optional[StrictStr] = None
    user_status: Optional[StrictStr] = Field(default=None, alias="userStatus")
    environment_prefix: Optional[StrictStr] = Field(default=None, alias="environmentPrefix")
    stats: Optional[GetContainer200ResponseContainerStats] = None
    runtime_info: Optional[Dict[str, Any]] = Field(default=None, alias="runtimeInfo")
    container_version: Optional[StrictStr] = Field(default=None, alias="containerVersion")
    repository_image: Optional[StrictStr] = Field(default=None, alias="repositoryImage")
    plan_category: Optional[StrictStr] = Field(default=None, alias="planCategory")
    hostname: Optional[StrictStr] = None
    domain_name: Optional[StrictStr] = Field(default=None, alias="domainName")
    volume_created: Optional[StrictBool] = Field(default=None, alias="volumeCreated")
    container_created: Optional[StrictBool] = Field(default=None, alias="containerCreated")
    max_storage: Optional[StrictInt] = Field(default=None, alias="maxStorage")
    max_memory: Optional[StrictInt] = Field(default=None, alias="maxMemory")
    max_cores: Optional[StrictInt] = Field(default=None, alias="maxCores")
    max_cpu: Optional[StrictInt] = Field(default=None, alias="maxCpu")
    available_actions: Optional[List[Dict[str, Any]]] = Field(default=None, alias="availableActions")
    config_group: Optional[StrictStr] = Field(default=None, alias="configGroup")
    config_id: Optional[StrictStr] = Field(default=None, alias="configId")
    config_role: Optional[StrictStr] = Field(default=None, alias="configRole")
    hourly_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="hourlyCost")
    hourly_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="hourlyPrice")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "uuid", "accountId", "instance", "containerType", "containerTypeSet", "server", "cloud", "name", "ip", "internalIp", "internalHostname", "externalHostname", "externalDomain", "externalFqdn", "ports", "plan", "dateCreated", "lastUpdated", "statsEnabled", "status", "userStatus", "environmentPrefix", "stats", "runtimeInfo", "containerVersion", "repositoryImage", "planCategory", "hostname", "domainName", "volumeCreated", "containerCreated", "maxStorage", "maxMemory", "maxCores", "maxCpu", "availableActions", "configGroup", "configId", "configRole", "hourlyCost", "hourlyPrice"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetContainer200ResponseContainer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of instance
        if self.instance:
            _dict['instance'] = self.instance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of container_type
        if self.container_type:
            _dict['containerType'] = self.container_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of container_type_set
        if self.container_type_set:
            _dict['containerTypeSet'] = self.container_type_set.to_dict()
        # override the default output from pydantic by calling `to_dict()` of server
        if self.server:
            _dict['server'] = self.server.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cloud
        if self.cloud:
            _dict['cloud'] = self.cloud.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in ports (list)
        _items = []
        if self.ports:
            for _item_ports in self.ports:
                if _item_ports:
                    _items.append(_item_ports.to_dict())
            _dict['ports'] = _items
        # override the default output from pydantic by calling `to_dict()` of plan
        if self.plan:
            _dict['plan'] = self.plan.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stats
        if self.stats:
            _dict['stats'] = self.stats.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if ports (nullable) is None
        # and model_fields_set contains the field
        if self.ports is None and "ports" in self.model_fields_set:
            _dict['ports'] = None

        # set to None if environment_prefix (nullable) is None
        # and model_fields_set contains the field
        if self.environment_prefix is None and "environment_prefix" in self.model_fields_set:
            _dict['environmentPrefix'] = None

        # set to None if container_version (nullable) is None
        # and model_fields_set contains the field
        if self.container_version is None and "container_version" in self.model_fields_set:
            _dict['containerVersion'] = None

        # set to None if repository_image (nullable) is None
        # and model_fields_set contains the field
        if self.repository_image is None and "repository_image" in self.model_fields_set:
            _dict['repositoryImage'] = None

        # set to None if plan_category (nullable) is None
        # and model_fields_set contains the field
        if self.plan_category is None and "plan_category" in self.model_fields_set:
            _dict['planCategory'] = None

        # set to None if domain_name (nullable) is None
        # and model_fields_set contains the field
        if self.domain_name is None and "domain_name" in self.model_fields_set:
            _dict['domainName'] = None

        # set to None if max_cpu (nullable) is None
        # and model_fields_set contains the field
        if self.max_cpu is None and "max_cpu" in self.model_fields_set:
            _dict['maxCpu'] = None

        # set to None if available_actions (nullable) is None
        # and model_fields_set contains the field
        if self.available_actions is None and "available_actions" in self.model_fields_set:
            _dict['availableActions'] = None

        # set to None if config_group (nullable) is None
        # and model_fields_set contains the field
        if self.config_group is None and "config_group" in self.model_fields_set:
            _dict['configGroup'] = None

        # set to None if config_id (nullable) is None
        # and model_fields_set contains the field
        if self.config_id is None and "config_id" in self.model_fields_set:
            _dict['configId'] = None

        # set to None if config_role (nullable) is None
        # and model_fields_set contains the field
        if self.config_role is None and "config_role" in self.model_fields_set:
            _dict['configRole'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetContainer200ResponseContainer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "uuid": obj.get("uuid"),
            "accountId": obj.get("accountId"),
            "instance": GetContainer200ResponseContainerInstance.from_dict(obj["instance"]) if obj.get("instance") is not None else None,
            "containerType": GetContainer200ResponseContainerContainerType.from_dict(obj["containerType"]) if obj.get("containerType") is not None else None,
            "containerTypeSet": GetContainer200ResponseContainerContainerTypeSet.from_dict(obj["containerTypeSet"]) if obj.get("containerTypeSet") is not None else None,
            "server": GetContainer200ResponseContainerInstance.from_dict(obj["server"]) if obj.get("server") is not None else None,
            "cloud": GetContainer200ResponseContainerInstance.from_dict(obj["cloud"]) if obj.get("cloud") is not None else None,
            "name": obj.get("name"),
            "ip": obj.get("ip"),
            "internalIp": obj.get("internalIp"),
            "internalHostname": obj.get("internalHostname"),
            "externalHostname": obj.get("externalHostname"),
            "externalDomain": obj.get("externalDomain"),
            "externalFqdn": obj.get("externalFqdn"),
            "ports": [GetContainer200ResponseContainerPortsInner.from_dict(_item) for _item in obj["ports"]] if obj.get("ports") is not None else None,
            "plan": GetContainer200ResponseContainerPlan.from_dict(obj["plan"]) if obj.get("plan") is not None else None,
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "statsEnabled": obj.get("statsEnabled"),
            "status": obj.get("status"),
            "userStatus": obj.get("userStatus"),
            "environmentPrefix": obj.get("environmentPrefix"),
            "stats": GetContainer200ResponseContainerStats.from_dict(obj["stats"]) if obj.get("stats") is not None else None,
            "runtimeInfo": obj.get("runtimeInfo"),
            "containerVersion": obj.get("containerVersion"),
            "repositoryImage": obj.get("repositoryImage"),
            "planCategory": obj.get("planCategory"),
            "hostname": obj.get("hostname"),
            "domainName": obj.get("domainName"),
            "volumeCreated": obj.get("volumeCreated"),
            "containerCreated": obj.get("containerCreated"),
            "maxStorage": obj.get("maxStorage"),
            "maxMemory": obj.get("maxMemory"),
            "maxCores": obj.get("maxCores"),
            "maxCpu": obj.get("maxCpu"),
            "availableActions": obj.get("availableActions"),
            "configGroup": obj.get("configGroup"),
            "configId": obj.get("configId"),
            "configRole": obj.get("configRole"),
            "hourlyCost": obj.get("hourlyCost"),
            "hourlyPrice": obj.get("hourlyPrice")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


