# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_instance_type_provisioning200_response_all_of_instance_type_instance_type_layouts_inner_container_types_inner_account import GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerAccount
from morpheus.models.get_network_edge_cluster200_response_network_edge_cluster_config import GetNetworkEdgeCluster200ResponseNetworkEdgeClusterConfig
from morpheus.models.snapshots_instance200_response_snapshots_inner_snapshot_files_inner_volume import SnapshotsInstance200ResponseSnapshotsInnerSnapshotFilesInnerVolume
from typing import Optional, Set
from typing_extensions import Self

class GetNetworkEdgeCluster200ResponseNetworkEdgeCluster(BaseModel):
    """
    GetNetworkEdgeCluster200ResponseNetworkEdgeCluster
    """ # noqa: E501
    id: Optional[StrictInt] = None
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    visibility: Optional[StrictStr] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    provider_id: Optional[StrictStr] = Field(default=None, alias="providerId")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    active: Optional[StrictBool] = None
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    name: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    config: Optional[GetNetworkEdgeCluster200ResponseNetworkEdgeClusterConfig] = None
    owner: Optional[SnapshotsInstance200ResponseSnapshotsInnerSnapshotFilesInnerVolume] = None
    network_server: Optional[SnapshotsInstance200ResponseSnapshotsInnerSnapshotFilesInnerVolume] = Field(default=None, alias="networkServer")
    zone: Optional[SnapshotsInstance200ResponseSnapshotsInnerSnapshotFilesInnerVolume] = None
    tenants: Optional[List[GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerAccount]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "internalId", "visibility", "dateCreated", "providerId", "lastUpdated", "active", "displayName", "name", "enabled", "externalId", "config", "owner", "networkServer", "zone", "tenants"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetNetworkEdgeCluster200ResponseNetworkEdgeCluster from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network_server
        if self.network_server:
            _dict['networkServer'] = self.network_server.to_dict()
        # override the default output from pydantic by calling `to_dict()` of zone
        if self.zone:
            _dict['zone'] = self.zone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tenants (list)
        _items = []
        if self.tenants:
            for _item_tenants in self.tenants:
                if _item_tenants:
                    _items.append(_item_tenants.to_dict())
            _dict['tenants'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetNetworkEdgeCluster200ResponseNetworkEdgeCluster from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "internalId": obj.get("internalId"),
            "visibility": obj.get("visibility"),
            "dateCreated": obj.get("dateCreated"),
            "providerId": obj.get("providerId"),
            "lastUpdated": obj.get("lastUpdated"),
            "active": obj.get("active"),
            "displayName": obj.get("displayName"),
            "name": obj.get("name"),
            "enabled": obj.get("enabled"),
            "externalId": obj.get("externalId"),
            "config": GetNetworkEdgeCluster200ResponseNetworkEdgeClusterConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "owner": SnapshotsInstance200ResponseSnapshotsInnerSnapshotFilesInnerVolume.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "networkServer": SnapshotsInstance200ResponseSnapshotsInnerSnapshotFilesInnerVolume.from_dict(obj["networkServer"]) if obj.get("networkServer") is not None else None,
            "zone": SnapshotsInstance200ResponseSnapshotsInnerSnapshotFilesInnerVolume.from_dict(obj["zone"]) if obj.get("zone") is not None else None,
            "tenants": [GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerAccount.from_dict(_item) for _item in obj["tenants"]] if obj.get("tenants") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


