# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_network_routers_bgp_neighbors200_response_network_router_bgp_neighbors_inner_config import GetNetworkRoutersBgpNeighbors200ResponseNetworkRouterBgpNeighborsInnerConfig
from typing import Optional, Set
from typing_extensions import Self

class GetNetworkRoutersBgpNeighbors200ResponseNetworkRouterBgpNeighborsInner(BaseModel):
    """
    GetNetworkRoutersBgpNeighbors200ResponseNetworkRouterBgpNeighborsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    ip_address: Optional[StrictStr] = Field(default=None, alias="ipAddress")
    forwarding_address: Optional[StrictStr] = Field(default=None, alias="forwardingAddress")
    protocol_address: Optional[StrictStr] = Field(default=None, alias="protocolAddress")
    remote_as: Optional[StrictStr] = Field(default=None, alias="remoteAs")
    weight: Optional[StrictInt] = None
    keep_alive: Optional[StrictInt] = Field(default=None, alias="keepAlive")
    hold_down: Optional[StrictInt] = Field(default=None, alias="holdDown")
    password: Optional[StrictStr] = None
    route_filtering_type: Optional[StrictStr] = Field(default=None, alias="routeFilteringType")
    route_filtering_in: Optional[StrictStr] = Field(default=None, alias="routeFilteringIn")
    route_filtering_out: Optional[StrictStr] = Field(default=None, alias="routeFilteringOut")
    bfd_enabled: Optional[StrictBool] = Field(default=None, alias="bfdEnabled")
    bfd_interval: Optional[StrictInt] = Field(default=None, alias="bfdInterval")
    bfd_multiple: Optional[StrictInt] = Field(default=None, alias="bfdMultiple")
    allow_as_in: Optional[StrictBool] = Field(default=None, alias="allowAsIn")
    hop_limit: Optional[StrictInt] = Field(default=None, alias="hopLimit")
    restart_mode: Optional[StrictStr] = Field(default=None, alias="restartMode")
    provider_id: Optional[StrictStr] = Field(default=None, alias="providerId")
    sync_source: Optional[StrictStr] = Field(default=None, alias="syncSource")
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    ref_type: Optional[StrictStr] = Field(default=None, alias="refType")
    ref_id: Optional[StrictStr] = Field(default=None, alias="refId")
    config: Optional[GetNetworkRoutersBgpNeighbors200ResponseNetworkRouterBgpNeighborsInnerConfig] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "ipAddress", "forwardingAddress", "protocolAddress", "remoteAs", "weight", "keepAlive", "holdDown", "password", "routeFilteringType", "routeFilteringIn", "routeFilteringOut", "bfdEnabled", "bfdInterval", "bfdMultiple", "allowAsIn", "hopLimit", "restartMode", "providerId", "syncSource", "internalId", "externalId", "refType", "refId", "config", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetNetworkRoutersBgpNeighbors200ResponseNetworkRouterBgpNeighborsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if forwarding_address (nullable) is None
        # and model_fields_set contains the field
        if self.forwarding_address is None and "forwarding_address" in self.model_fields_set:
            _dict['forwardingAddress'] = None

        # set to None if protocol_address (nullable) is None
        # and model_fields_set contains the field
        if self.protocol_address is None and "protocol_address" in self.model_fields_set:
            _dict['protocolAddress'] = None

        # set to None if password (nullable) is None
        # and model_fields_set contains the field
        if self.password is None and "password" in self.model_fields_set:
            _dict['password'] = None

        # set to None if internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_id is None and "internal_id" in self.model_fields_set:
            _dict['internalId'] = None

        # set to None if ref_type (nullable) is None
        # and model_fields_set contains the field
        if self.ref_type is None and "ref_type" in self.model_fields_set:
            _dict['refType'] = None

        # set to None if ref_id (nullable) is None
        # and model_fields_set contains the field
        if self.ref_id is None and "ref_id" in self.model_fields_set:
            _dict['refId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetNetworkRoutersBgpNeighbors200ResponseNetworkRouterBgpNeighborsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "ipAddress": obj.get("ipAddress"),
            "forwardingAddress": obj.get("forwardingAddress"),
            "protocolAddress": obj.get("protocolAddress"),
            "remoteAs": obj.get("remoteAs"),
            "weight": obj.get("weight"),
            "keepAlive": obj.get("keepAlive"),
            "holdDown": obj.get("holdDown"),
            "password": obj.get("password"),
            "routeFilteringType": obj.get("routeFilteringType"),
            "routeFilteringIn": obj.get("routeFilteringIn"),
            "routeFilteringOut": obj.get("routeFilteringOut"),
            "bfdEnabled": obj.get("bfdEnabled"),
            "bfdInterval": obj.get("bfdInterval"),
            "bfdMultiple": obj.get("bfdMultiple"),
            "allowAsIn": obj.get("allowAsIn"),
            "hopLimit": obj.get("hopLimit"),
            "restartMode": obj.get("restartMode"),
            "providerId": obj.get("providerId"),
            "syncSource": obj.get("syncSource"),
            "internalId": obj.get("internalId"),
            "externalId": obj.get("externalId"),
            "refType": obj.get("refType"),
            "refId": obj.get("refId"),
            "config": GetNetworkRoutersBgpNeighbors200ResponseNetworkRouterBgpNeighborsInnerConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


