# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_roles200_response_all_of_app_template_permissions_inner import AddRoles200ResponseAllOfAppTemplatePermissionsInner
from morpheus.models.add_roles200_response_all_of_feature_permissions_inner import AddRoles200ResponseAllOfFeaturePermissionsInner
from morpheus.models.add_roles200_response_all_of_instance_type_permissions_inner import AddRoles200ResponseAllOfInstanceTypePermissionsInner
from morpheus.models.add_roles200_response_all_of_sites_inner import AddRoles200ResponseAllOfSitesInner
from morpheus.models.list_roles200_response_all_of_roles_inner import ListRoles200ResponseAllOfRolesInner
from typing import Optional, Set
from typing_extensions import Self

class GetRole200Response(BaseModel):
    """
    GetRole200Response
    """ # noqa: E501
    role: Optional[ListRoles200ResponseAllOfRolesInner] = None
    feature_permissions: Optional[List[AddRoles200ResponseAllOfFeaturePermissionsInner]] = Field(default=None, alias="featurePermissions")
    global_site_access: Optional[StrictStr] = Field(default=None, alias="globalSiteAccess")
    sites: Optional[List[AddRoles200ResponseAllOfSitesInner]] = None
    global_zone_access: Optional[StrictStr] = Field(default=None, alias="globalZoneAccess")
    zones: Optional[List[AddRoles200ResponseAllOfSitesInner]] = None
    global_instance_type_access: Optional[StrictStr] = Field(default=None, alias="globalInstanceTypeAccess")
    instance_type_permissions: Optional[List[AddRoles200ResponseAllOfInstanceTypePermissionsInner]] = Field(default=None, alias="instanceTypePermissions")
    global_app_template_access: Optional[StrictStr] = Field(default=None, alias="globalAppTemplateAccess")
    app_template_permissions: Optional[List[AddRoles200ResponseAllOfAppTemplatePermissionsInner]] = Field(default=None, alias="appTemplatePermissions")
    global_catalog_item_type_access: Optional[StrictStr] = Field(default=None, alias="globalCatalogItemTypeAccess")
    catalog_item_type_permissions: Optional[List[AddRoles200ResponseAllOfSitesInner]] = Field(default=None, alias="catalogItemTypePermissions")
    global_persona_access: Optional[StrictStr] = Field(default=None, alias="globalPersonaAccess")
    persona_permissions: Optional[List[AddRoles200ResponseAllOfInstanceTypePermissionsInner]] = Field(default=None, alias="personaPermissions")
    global_vdi_pool_access: Optional[StrictStr] = Field(default=None, alias="globalVdiPoolAccess")
    vdi_pool_permissions: Optional[List[AddRoles200ResponseAllOfSitesInner]] = Field(default=None, alias="vdiPoolPermissions")
    global_report_type_access: Optional[StrictStr] = Field(default=None, alias="globalReportTypeAccess")
    report_type_permissions: Optional[List[AddRoles200ResponseAllOfInstanceTypePermissionsInner]] = Field(default=None, alias="reportTypePermissions")
    global_task_access: Optional[StrictStr] = Field(default=None, alias="globalTaskAccess")
    task_permissions: Optional[List[AddRoles200ResponseAllOfAppTemplatePermissionsInner]] = Field(default=None, alias="taskPermissions")
    global_task_set_access: Optional[StrictStr] = Field(default=None, alias="globalTaskSetAccess")
    task_set_permissions: Optional[List[AddRoles200ResponseAllOfAppTemplatePermissionsInner]] = Field(default=None, alias="taskSetPermissions")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["role", "featurePermissions", "globalSiteAccess", "sites", "globalZoneAccess", "zones", "globalInstanceTypeAccess", "instanceTypePermissions", "globalAppTemplateAccess", "appTemplatePermissions", "globalCatalogItemTypeAccess", "catalogItemTypePermissions", "globalPersonaAccess", "personaPermissions", "globalVdiPoolAccess", "vdiPoolPermissions", "globalReportTypeAccess", "reportTypePermissions", "globalTaskAccess", "taskPermissions", "globalTaskSetAccess", "taskSetPermissions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetRole200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of role
        if self.role:
            _dict['role'] = self.role.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in feature_permissions (list)
        _items = []
        if self.feature_permissions:
            for _item_feature_permissions in self.feature_permissions:
                if _item_feature_permissions:
                    _items.append(_item_feature_permissions.to_dict())
            _dict['featurePermissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in sites (list)
        _items = []
        if self.sites:
            for _item_sites in self.sites:
                if _item_sites:
                    _items.append(_item_sites.to_dict())
            _dict['sites'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in zones (list)
        _items = []
        if self.zones:
            for _item_zones in self.zones:
                if _item_zones:
                    _items.append(_item_zones.to_dict())
            _dict['zones'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in instance_type_permissions (list)
        _items = []
        if self.instance_type_permissions:
            for _item_instance_type_permissions in self.instance_type_permissions:
                if _item_instance_type_permissions:
                    _items.append(_item_instance_type_permissions.to_dict())
            _dict['instanceTypePermissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in app_template_permissions (list)
        _items = []
        if self.app_template_permissions:
            for _item_app_template_permissions in self.app_template_permissions:
                if _item_app_template_permissions:
                    _items.append(_item_app_template_permissions.to_dict())
            _dict['appTemplatePermissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in catalog_item_type_permissions (list)
        _items = []
        if self.catalog_item_type_permissions:
            for _item_catalog_item_type_permissions in self.catalog_item_type_permissions:
                if _item_catalog_item_type_permissions:
                    _items.append(_item_catalog_item_type_permissions.to_dict())
            _dict['catalogItemTypePermissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in persona_permissions (list)
        _items = []
        if self.persona_permissions:
            for _item_persona_permissions in self.persona_permissions:
                if _item_persona_permissions:
                    _items.append(_item_persona_permissions.to_dict())
            _dict['personaPermissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in vdi_pool_permissions (list)
        _items = []
        if self.vdi_pool_permissions:
            for _item_vdi_pool_permissions in self.vdi_pool_permissions:
                if _item_vdi_pool_permissions:
                    _items.append(_item_vdi_pool_permissions.to_dict())
            _dict['vdiPoolPermissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in report_type_permissions (list)
        _items = []
        if self.report_type_permissions:
            for _item_report_type_permissions in self.report_type_permissions:
                if _item_report_type_permissions:
                    _items.append(_item_report_type_permissions.to_dict())
            _dict['reportTypePermissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in task_permissions (list)
        _items = []
        if self.task_permissions:
            for _item_task_permissions in self.task_permissions:
                if _item_task_permissions:
                    _items.append(_item_task_permissions.to_dict())
            _dict['taskPermissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in task_set_permissions (list)
        _items = []
        if self.task_set_permissions:
            for _item_task_set_permissions in self.task_set_permissions:
                if _item_task_set_permissions:
                    _items.append(_item_task_set_permissions.to_dict())
            _dict['taskSetPermissions'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetRole200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "role": ListRoles200ResponseAllOfRolesInner.from_dict(obj["role"]) if obj.get("role") is not None else None,
            "featurePermissions": [AddRoles200ResponseAllOfFeaturePermissionsInner.from_dict(_item) for _item in obj["featurePermissions"]] if obj.get("featurePermissions") is not None else None,
            "globalSiteAccess": obj.get("globalSiteAccess"),
            "sites": [AddRoles200ResponseAllOfSitesInner.from_dict(_item) for _item in obj["sites"]] if obj.get("sites") is not None else None,
            "globalZoneAccess": obj.get("globalZoneAccess"),
            "zones": [AddRoles200ResponseAllOfSitesInner.from_dict(_item) for _item in obj["zones"]] if obj.get("zones") is not None else None,
            "globalInstanceTypeAccess": obj.get("globalInstanceTypeAccess"),
            "instanceTypePermissions": [AddRoles200ResponseAllOfInstanceTypePermissionsInner.from_dict(_item) for _item in obj["instanceTypePermissions"]] if obj.get("instanceTypePermissions") is not None else None,
            "globalAppTemplateAccess": obj.get("globalAppTemplateAccess"),
            "appTemplatePermissions": [AddRoles200ResponseAllOfAppTemplatePermissionsInner.from_dict(_item) for _item in obj["appTemplatePermissions"]] if obj.get("appTemplatePermissions") is not None else None,
            "globalCatalogItemTypeAccess": obj.get("globalCatalogItemTypeAccess"),
            "catalogItemTypePermissions": [AddRoles200ResponseAllOfSitesInner.from_dict(_item) for _item in obj["catalogItemTypePermissions"]] if obj.get("catalogItemTypePermissions") is not None else None,
            "globalPersonaAccess": obj.get("globalPersonaAccess"),
            "personaPermissions": [AddRoles200ResponseAllOfInstanceTypePermissionsInner.from_dict(_item) for _item in obj["personaPermissions"]] if obj.get("personaPermissions") is not None else None,
            "globalVdiPoolAccess": obj.get("globalVdiPoolAccess"),
            "vdiPoolPermissions": [AddRoles200ResponseAllOfSitesInner.from_dict(_item) for _item in obj["vdiPoolPermissions"]] if obj.get("vdiPoolPermissions") is not None else None,
            "globalReportTypeAccess": obj.get("globalReportTypeAccess"),
            "reportTypePermissions": [AddRoles200ResponseAllOfInstanceTypePermissionsInner.from_dict(_item) for _item in obj["reportTypePermissions"]] if obj.get("reportTypePermissions") is not None else None,
            "globalTaskAccess": obj.get("globalTaskAccess"),
            "taskPermissions": [AddRoles200ResponseAllOfAppTemplatePermissionsInner.from_dict(_item) for _item in obj["taskPermissions"]] if obj.get("taskPermissions") is not None else None,
            "globalTaskSetAccess": obj.get("globalTaskSetAccess"),
            "taskSetPermissions": [AddRoles200ResponseAllOfAppTemplatePermissionsInner.from_dict(_item) for _item in obj["taskSetPermissions"]] if obj.get("taskSetPermissions") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


