# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_catalog_item_type_request_catalog_item_type_one_of_config_evars_inner import AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner
from morpheus.models.add_cluster_request_cluster_server_ssh_key_pair import AddClusterRequestClusterServerSshKeyPair
from morpheus.models.list_instances200_response_all_of_instances_inner_tags_inner import ListInstances200ResponseAllOfInstancesInnerTagsInner
from typing import Optional, Set
from typing_extensions import Self

class HostUpdate(BaseModel):
    """
    HostUpdate
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Unique name scoped to your account for the server.")
    description: Optional[StrictStr] = Field(default=None, description="Optional description field.")
    enabled: Optional[StrictBool] = Field(default=True, description="Flag to determine if a host can be selected for provisioning")
    manage_internal_firewall: Optional[StrictBool] = Field(default=True, description="Flag to enable/disable managment of internal firewall", alias="manageInternalFirewall")
    enable_logs: Optional[StrictBool] = Field(default=True, description="Flag to enable/disable logs", alias="enableLogs")
    ssh_username: Optional[StrictStr] = Field(default=None, description="SSH Username", alias="sshUsername")
    ssh_password: Optional[StrictStr] = Field(default=None, description="SSH Password", alias="sshPassword")
    ssh_key_pair: Optional[AddClusterRequestClusterServerSshKeyPair] = Field(default=None, alias="sshKeyPair")
    power_schedule_type: Optional[StrictInt] = Field(default=None, description="Power schedule ID.", alias="powerScheduleType")
    labels: Optional[List[StrictStr]] = None
    tags: Optional[List[AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner]] = Field(default=None, description="Metadata tags, Array of objects having a name and value.")
    add_tags: Optional[List[AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner]] = Field(default=None, description="Add or update value of Metadata tags, Array of objects having a name and value.", alias="addTags")
    remove_tags: Optional[List[ListInstances200ResponseAllOfInstancesInnerTagsInner]] = Field(default=None, description="Remove Metadata tags, Array of objects having a name and an optional value. If value is passed, it must match to be removed.", alias="removeTags")
    guest_console_type: Optional[StrictStr] = Field(default=None, description="The Type of guest console this server provides such as disabled, vnc, rdp, ssh", alias="guestConsoleType")
    guest_console_username: Optional[StrictStr] = Field(default=None, description="The optional guest console username if you don't want to use the user defaults", alias="guestConsoleUsername")
    guest_console_password: Optional[StrictStr] = Field(default=None, description="The optional guest console password if not using the accessing users creds", alias="guestConsolePassword")
    guest_console_port: Optional[StrictStr] = Field(default=None, description="The port the guest console is being accessed from", alias="guestConsolePort")
    guest_console_preferred: Optional[StrictBool] = Field(default=True, description="Can turn off guest console preferences on server in favor of hypervisor console", alias="guestConsolePreferred")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "description", "enabled", "manageInternalFirewall", "enableLogs", "sshUsername", "sshPassword", "sshKeyPair", "powerScheduleType", "labels", "tags", "addTags", "removeTags", "guestConsoleType", "guestConsoleUsername", "guestConsolePassword", "guestConsolePort", "guestConsolePreferred"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HostUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of ssh_key_pair
        if self.ssh_key_pair:
            _dict['sshKeyPair'] = self.ssh_key_pair.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in add_tags (list)
        _items = []
        if self.add_tags:
            for _item_add_tags in self.add_tags:
                if _item_add_tags:
                    _items.append(_item_add_tags.to_dict())
            _dict['addTags'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in remove_tags (list)
        _items = []
        if self.remove_tags:
            for _item_remove_tags in self.remove_tags:
                if _item_remove_tags:
                    _items.append(_item_remove_tags.to_dict())
            _dict['removeTags'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if ssh_password (nullable) is None
        # and model_fields_set contains the field
        if self.ssh_password is None and "ssh_password" in self.model_fields_set:
            _dict['sshPassword'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HostUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "manageInternalFirewall": obj.get("manageInternalFirewall") if obj.get("manageInternalFirewall") is not None else True,
            "enableLogs": obj.get("enableLogs") if obj.get("enableLogs") is not None else True,
            "sshUsername": obj.get("sshUsername"),
            "sshPassword": obj.get("sshPassword"),
            "sshKeyPair": AddClusterRequestClusterServerSshKeyPair.from_dict(obj["sshKeyPair"]) if obj.get("sshKeyPair") is not None else None,
            "powerScheduleType": obj.get("powerScheduleType"),
            "labels": obj.get("labels"),
            "tags": [AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "addTags": [AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner.from_dict(_item) for _item in obj["addTags"]] if obj.get("addTags") is not None else None,
            "removeTags": [ListInstances200ResponseAllOfInstancesInnerTagsInner.from_dict(_item) for _item in obj["removeTags"]] if obj.get("removeTags") is not None else None,
            "guestConsoleType": obj.get("guestConsoleType"),
            "guestConsoleUsername": obj.get("guestConsoleUsername"),
            "guestConsolePassword": obj.get("guestConsolePassword"),
            "guestConsolePort": obj.get("guestConsolePort"),
            "guestConsolePreferred": obj.get("guestConsolePreferred") if obj.get("guestConsolePreferred") is not None else True
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


