# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.get_instance_type_provisioning200_response_all_of_instance_type_instance_type_layouts_inner_container_types_inner import GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInner
from morpheus.models.get_instance_type_provisioning200_response_all_of_instance_type_instance_type_layouts_inner_permissions import GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerPermissions
from morpheus.models.get_instance_type_provisioning200_response_all_of_instance_type_instance_type_layouts_inner_provision_type import GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerProvisionType
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from typing import Optional, Set
from typing_extensions import Self

class InstanceTypeLayout(BaseModel):
    """
    InstanceTypeLayout
    """ # noqa: E501
    id: Optional[StrictInt] = None
    instance_type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = Field(default=None, alias="instanceType")
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    code: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    labels: Optional[List[StrictStr]] = Field(default=None, description="Array of label strings, can be used for filtering.")
    instance_version: Optional[StrictStr] = Field(default=None, alias="instanceVersion")
    description: Optional[StrictStr] = None
    creatable: Optional[StrictBool] = None
    memory_requirement: Optional[StrictInt] = Field(default=None, alias="memoryRequirement")
    sort_order: Optional[StrictInt] = Field(default=None, alias="sortOrder")
    supports_convert_to_managed: Optional[StrictBool] = Field(default=None, alias="supportsConvertToManaged")
    provision_type: Optional[GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerProvisionType] = Field(default=None, alias="provisionType")
    task_sets: Optional[List[Dict[str, Any]]] = Field(default=None, alias="taskSets")
    container_types: Optional[List[GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInner]] = Field(default=None, alias="containerTypes")
    mounts: Optional[List[Dict[str, Any]]] = None
    ports: Optional[List[Dict[str, Any]]] = None
    option_types: Optional[List[Dict[str, Any]]] = Field(default=None, alias="optionTypes")
    environment_variables: Optional[List[Dict[str, Any]]] = Field(default=None, alias="environmentVariables")
    price_sets: Optional[List[Dict[str, Any]]] = Field(default=None, alias="priceSets")
    spec_templates: Optional[List[Dict[str, Any]]] = Field(default=None, alias="specTemplates")
    tfvar_secret: Optional[StrictStr] = Field(default=None, alias="tfvarSecret")
    permissions: Optional[GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerPermissions] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "instanceType", "account", "code", "name", "labels", "instanceVersion", "description", "creatable", "memoryRequirement", "sortOrder", "supportsConvertToManaged", "provisionType", "taskSets", "containerTypes", "mounts", "ports", "optionTypes", "environmentVariables", "priceSets", "specTemplates", "tfvarSecret", "permissions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InstanceTypeLayout from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of instance_type
        if self.instance_type:
            _dict['instanceType'] = self.instance_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of provision_type
        if self.provision_type:
            _dict['provisionType'] = self.provision_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in container_types (list)
        _items = []
        if self.container_types:
            for _item_container_types in self.container_types:
                if _item_container_types:
                    _items.append(_item_container_types.to_dict())
            _dict['containerTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of permissions
        if self.permissions:
            _dict['permissions'] = self.permissions.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if memory_requirement (nullable) is None
        # and model_fields_set contains the field
        if self.memory_requirement is None and "memory_requirement" in self.model_fields_set:
            _dict['memoryRequirement'] = None

        # set to None if supports_convert_to_managed (nullable) is None
        # and model_fields_set contains the field
        if self.supports_convert_to_managed is None and "supports_convert_to_managed" in self.model_fields_set:
            _dict['supportsConvertToManaged'] = None

        # set to None if task_sets (nullable) is None
        # and model_fields_set contains the field
        if self.task_sets is None and "task_sets" in self.model_fields_set:
            _dict['taskSets'] = None

        # set to None if mounts (nullable) is None
        # and model_fields_set contains the field
        if self.mounts is None and "mounts" in self.model_fields_set:
            _dict['mounts'] = None

        # set to None if ports (nullable) is None
        # and model_fields_set contains the field
        if self.ports is None and "ports" in self.model_fields_set:
            _dict['ports'] = None

        # set to None if option_types (nullable) is None
        # and model_fields_set contains the field
        if self.option_types is None and "option_types" in self.model_fields_set:
            _dict['optionTypes'] = None

        # set to None if environment_variables (nullable) is None
        # and model_fields_set contains the field
        if self.environment_variables is None and "environment_variables" in self.model_fields_set:
            _dict['environmentVariables'] = None

        # set to None if price_sets (nullable) is None
        # and model_fields_set contains the field
        if self.price_sets is None and "price_sets" in self.model_fields_set:
            _dict['priceSets'] = None

        # set to None if spec_templates (nullable) is None
        # and model_fields_set contains the field
        if self.spec_templates is None and "spec_templates" in self.model_fields_set:
            _dict['specTemplates'] = None

        # set to None if tfvar_secret (nullable) is None
        # and model_fields_set contains the field
        if self.tfvar_secret is None and "tfvar_secret" in self.model_fields_set:
            _dict['tfvarSecret'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InstanceTypeLayout from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "instanceType": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["instanceType"]) if obj.get("instanceType") is not None else None,
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "code": obj.get("code"),
            "name": obj.get("name"),
            "labels": obj.get("labels"),
            "instanceVersion": obj.get("instanceVersion"),
            "description": obj.get("description"),
            "creatable": obj.get("creatable"),
            "memoryRequirement": obj.get("memoryRequirement"),
            "sortOrder": obj.get("sortOrder"),
            "supportsConvertToManaged": obj.get("supportsConvertToManaged"),
            "provisionType": GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerProvisionType.from_dict(obj["provisionType"]) if obj.get("provisionType") is not None else None,
            "taskSets": obj.get("taskSets"),
            "containerTypes": [GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInner.from_dict(_item) for _item in obj["containerTypes"]] if obj.get("containerTypes") is not None else None,
            "mounts": obj.get("mounts"),
            "ports": obj.get("ports"),
            "optionTypes": obj.get("optionTypes"),
            "environmentVariables": obj.get("environmentVariables"),
            "priceSets": obj.get("priceSets"),
            "specTemplates": obj.get("specTemplates"),
            "tfvarSecret": obj.get("tfvarSecret"),
            "permissions": GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerPermissions.from_dict(obj["permissions"]) if obj.get("permissions") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


