# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.get_alerts200_response_all_of_checks_inner_account import GetAlerts200ResponseAllOfChecksInnerAccount
from typing import Optional, Set
from typing_extensions import Self

class Issue(BaseModel):
    """
    Issue
    """ # noqa: E501
    id: Optional[StrictInt] = None
    attachment_type: Optional[StrictStr] = Field(default=None, alias="attachmentType")
    app: Optional[StrictStr] = None
    available: Optional[StrictBool] = None
    check: Optional[StrictStr] = None
    check_group: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = Field(default=None, alias="checkGroup")
    check_status: Optional[StrictStr] = Field(default=None, alias="checkStatus")
    end_date: Optional[datetime] = Field(default=None, alias="endDate")
    health: Optional[StrictInt] = None
    in_uptime: Optional[StrictBool] = Field(default=None, alias="inUptime")
    incident: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = None
    last_check_time: Optional[datetime] = Field(default=None, alias="lastCheckTime")
    last_error: Optional[StrictStr] = Field(default=None, alias="lastError")
    last_message: Optional[StrictStr] = Field(default=None, alias="lastMessage")
    name: Optional[StrictStr] = None
    severity: Optional[StrictStr] = None
    severity_id: Optional[StrictInt] = Field(default=None, alias="severityId")
    start_date: Optional[datetime] = Field(default=None, alias="startDate")
    status: Optional[StrictStr] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "attachmentType", "app", "available", "check", "checkGroup", "checkStatus", "endDate", "health", "inUptime", "incident", "lastCheckTime", "lastError", "lastMessage", "name", "severity", "severityId", "startDate", "status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Issue from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of check_group
        if self.check_group:
            _dict['checkGroup'] = self.check_group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of incident
        if self.incident:
            _dict['incident'] = self.incident.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if app (nullable) is None
        # and model_fields_set contains the field
        if self.app is None and "app" in self.model_fields_set:
            _dict['app'] = None

        # set to None if check (nullable) is None
        # and model_fields_set contains the field
        if self.check is None and "check" in self.model_fields_set:
            _dict['check'] = None

        # set to None if check_status (nullable) is None
        # and model_fields_set contains the field
        if self.check_status is None and "check_status" in self.model_fields_set:
            _dict['checkStatus'] = None

        # set to None if end_date (nullable) is None
        # and model_fields_set contains the field
        if self.end_date is None and "end_date" in self.model_fields_set:
            _dict['endDate'] = None

        # set to None if last_check_time (nullable) is None
        # and model_fields_set contains the field
        if self.last_check_time is None and "last_check_time" in self.model_fields_set:
            _dict['lastCheckTime'] = None

        # set to None if last_error (nullable) is None
        # and model_fields_set contains the field
        if self.last_error is None and "last_error" in self.model_fields_set:
            _dict['lastError'] = None

        # set to None if last_message (nullable) is None
        # and model_fields_set contains the field
        if self.last_message is None and "last_message" in self.model_fields_set:
            _dict['lastMessage'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Issue from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "attachmentType": obj.get("attachmentType"),
            "app": obj.get("app"),
            "available": obj.get("available"),
            "check": obj.get("check"),
            "checkGroup": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["checkGroup"]) if obj.get("checkGroup") is not None else None,
            "checkStatus": obj.get("checkStatus"),
            "endDate": obj.get("endDate"),
            "health": obj.get("health"),
            "inUptime": obj.get("inUptime"),
            "incident": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["incident"]) if obj.get("incident") is not None else None,
            "lastCheckTime": obj.get("lastCheckTime"),
            "lastError": obj.get("lastError"),
            "lastMessage": obj.get("lastMessage"),
            "name": obj.get("name"),
            "severity": obj.get("severity"),
            "severityId": obj.get("severityId"),
            "startDate": obj.get("startDate"),
            "status": obj.get("status")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


