# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_job_executions200_response_all_of_job_executions_inner_job import ListJobExecutions200ResponseAllOfJobExecutionsInnerJob
from typing import Optional, Set
from typing_extensions import Self

class JobExecution(BaseModel):
    """
    JobExecution
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    process: Optional[StrictStr] = None
    job: Optional[ListJobExecutions200ResponseAllOfJobExecutionsInnerJob] = None
    description: Optional[StrictStr] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    start_date: Optional[datetime] = Field(default=None, alias="startDate")
    end_date: Optional[datetime] = Field(default=None, alias="endDate")
    duration: Optional[StrictInt] = None
    result_data: Optional[StrictStr] = Field(default=None, alias="resultData")
    status: Optional[StrictStr] = None
    status_message: Optional[StrictStr] = Field(default=None, alias="statusMessage")
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "process", "job", "description", "dateCreated", "startDate", "endDate", "duration", "resultData", "status", "statusMessage", "createdBy"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JobExecution from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of job
        if self.job:
            _dict['job'] = self.job.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if process (nullable) is None
        # and model_fields_set contains the field
        if self.process is None and "process" in self.model_fields_set:
            _dict['process'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if result_data (nullable) is None
        # and model_fields_set contains the field
        if self.result_data is None and "result_data" in self.model_fields_set:
            _dict['resultData'] = None

        # set to None if status_message (nullable) is None
        # and model_fields_set contains the field
        if self.status_message is None and "status_message" in self.model_fields_set:
            _dict['statusMessage'] = None

        # set to None if created_by (nullable) is None
        # and model_fields_set contains the field
        if self.created_by is None and "created_by" in self.model_fields_set:
            _dict['createdBy'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JobExecution from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "process": obj.get("process"),
            "job": ListJobExecutions200ResponseAllOfJobExecutionsInnerJob.from_dict(obj["job"]) if obj.get("job") is not None else None,
            "description": obj.get("description"),
            "dateCreated": obj.get("dateCreated"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "duration": obj.get("duration"),
            "resultData": obj.get("resultData"),
            "status": obj.get("status"),
            "statusMessage": obj.get("statusMessage"),
            "createdBy": obj.get("createdBy")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


