# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_catalog_item_types200_response_all_of_catalog_item_types_inner_option_types_inner import ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner
from typing import Optional, Set
from typing_extensions import Self

class ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInner(BaseModel):
    """
    ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    code: Optional[StrictStr] = Field(default=None, description="Useful shortcode for provisioning naming schemes and export reference.")
    category: Optional[StrictStr] = Field(default=None, description="Catalog Item Type category")
    description: Optional[StrictStr] = None
    labels: Optional[List[StrictStr]] = None
    type: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    featured: Optional[StrictBool] = None
    allow_quantity: Optional[StrictBool] = Field(default=None, description="Can users order more than one of this item at a time.", alias="allowQuantity")
    icon_path: Optional[StrictStr] = Field(default=None, alias="iconPath")
    image_path: Optional[StrictStr] = Field(default=None, alias="imagePath")
    dark_image_path: Optional[StrictStr] = Field(default=None, alias="darkImagePath")
    visibility: Optional[StrictStr] = None
    layout_code: Optional[StrictStr] = Field(default=None, alias="layoutCode")
    blueprint: Optional[Dict[str, Any]] = None
    app_spec: Optional[StrictStr] = Field(default=None, alias="appSpec")
    config: Optional[Dict[str, Any]] = None
    instance_spec: Optional[StrictStr] = Field(default=None, alias="instanceSpec")
    workflow: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    content: Optional[StrictStr] = None
    form_type: Optional[StrictStr] = Field(default=None, alias="formType")
    form: Optional[Dict[str, Any]] = Field(default=None, description="Form object that contains input options and/or field groups")
    form_config: Optional[Dict[str, Any]] = Field(default=None, description="Form config object", alias="formConfig")
    option_types: Optional[List[ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner]] = Field(default=None, alias="optionTypes")
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    owner: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "code", "category", "description", "labels", "type", "enabled", "featured", "allowQuantity", "iconPath", "imagePath", "darkImagePath", "visibility", "layoutCode", "blueprint", "appSpec", "config", "instanceSpec", "workflow", "content", "formType", "form", "formConfig", "optionTypes", "createdBy", "owner", "dateCreated", "lastUpdated"]

    @field_validator('form_type')
    def form_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['optionTypes', 'form']):
            raise ValueError("must be one of enum values ('optionTypes', 'form')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of workflow
        if self.workflow:
            _dict['workflow'] = self.workflow.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in option_types (list)
        _items = []
        if self.option_types:
            for _item_option_types in self.option_types:
                if _item_option_types:
                    _items.append(_item_option_types.to_dict())
            _dict['optionTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if code (nullable) is None
        # and model_fields_set contains the field
        if self.code is None and "code" in self.model_fields_set:
            _dict['code'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if layout_code (nullable) is None
        # and model_fields_set contains the field
        if self.layout_code is None and "layout_code" in self.model_fields_set:
            _dict['layoutCode'] = None

        # set to None if blueprint (nullable) is None
        # and model_fields_set contains the field
        if self.blueprint is None and "blueprint" in self.model_fields_set:
            _dict['blueprint'] = None

        # set to None if app_spec (nullable) is None
        # and model_fields_set contains the field
        if self.app_spec is None and "app_spec" in self.model_fields_set:
            _dict['appSpec'] = None

        # set to None if config (nullable) is None
        # and model_fields_set contains the field
        if self.config is None and "config" in self.model_fields_set:
            _dict['config'] = None

        # set to None if instance_spec (nullable) is None
        # and model_fields_set contains the field
        if self.instance_spec is None and "instance_spec" in self.model_fields_set:
            _dict['instanceSpec'] = None

        # set to None if content (nullable) is None
        # and model_fields_set contains the field
        if self.content is None and "content" in self.model_fields_set:
            _dict['content'] = None

        # set to None if form (nullable) is None
        # and model_fields_set contains the field
        if self.form is None and "form" in self.model_fields_set:
            _dict['form'] = None

        # set to None if form_config (nullable) is None
        # and model_fields_set contains the field
        if self.form_config is None and "form_config" in self.model_fields_set:
            _dict['formConfig'] = None

        # set to None if option_types (nullable) is None
        # and model_fields_set contains the field
        if self.option_types is None and "option_types" in self.model_fields_set:
            _dict['optionTypes'] = None

        # set to None if created_by (nullable) is None
        # and model_fields_set contains the field
        if self.created_by is None and "created_by" in self.model_fields_set:
            _dict['createdBy'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "code": obj.get("code"),
            "category": obj.get("category"),
            "description": obj.get("description"),
            "labels": obj.get("labels"),
            "type": obj.get("type"),
            "enabled": obj.get("enabled"),
            "featured": obj.get("featured"),
            "allowQuantity": obj.get("allowQuantity"),
            "iconPath": obj.get("iconPath"),
            "imagePath": obj.get("imagePath"),
            "darkImagePath": obj.get("darkImagePath"),
            "visibility": obj.get("visibility"),
            "layoutCode": obj.get("layoutCode"),
            "blueprint": obj.get("blueprint"),
            "appSpec": obj.get("appSpec"),
            "config": obj.get("config"),
            "instanceSpec": obj.get("instanceSpec"),
            "workflow": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["workflow"]) if obj.get("workflow") is not None else None,
            "content": obj.get("content"),
            "formType": obj.get("formType"),
            "form": obj.get("form"),
            "formConfig": obj.get("formConfig"),
            "optionTypes": [ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner.from_dict(_item) for _item in obj["optionTypes"]] if obj.get("optionTypes") is not None else None,
            "createdBy": obj.get("createdBy"),
            "owner": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


