# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_certificates200_response_certificates_inner_type import ListCertificates200ResponseCertificatesInnerType
from typing import Optional, Set
from typing_extensions import Self

class ListCertificates200ResponseCertificatesInner(BaseModel):
    """
    ListCertificates200ResponseCertificatesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    domain_name: Optional[StrictStr] = Field(default=None, alias="domainName")
    account_id: Optional[StrictInt] = Field(default=None, alias="accountId")
    integration_id: Optional[StrictInt] = Field(default=None, alias="integrationId")
    enabled: Optional[StrictBool] = None
    generated: Optional[StrictBool] = None
    wildcard: Optional[StrictBool] = None
    self_signed: Optional[StrictBool] = Field(default=None, alias="selfSigned")
    type: Optional[ListCertificates200ResponseCertificatesInnerType] = None
    category: Optional[StrictStr] = None
    common_name: Optional[StrictStr] = Field(default=None, alias="commonName")
    cert_type: Optional[StrictStr] = Field(default=None, alias="certType")
    key_file_md5: Optional[StrictStr] = Field(default=None, alias="keyFileMD5")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "description", "domainName", "accountId", "integrationId", "enabled", "generated", "wildcard", "selfSigned", "type", "category", "commonName", "certType", "keyFileMD5"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListCertificates200ResponseCertificatesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if domain_name (nullable) is None
        # and model_fields_set contains the field
        if self.domain_name is None and "domain_name" in self.model_fields_set:
            _dict['domainName'] = None

        # set to None if integration_id (nullable) is None
        # and model_fields_set contains the field
        if self.integration_id is None and "integration_id" in self.model_fields_set:
            _dict['integrationId'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if common_name (nullable) is None
        # and model_fields_set contains the field
        if self.common_name is None and "common_name" in self.model_fields_set:
            _dict['commonName'] = None

        # set to None if cert_type (nullable) is None
        # and model_fields_set contains the field
        if self.cert_type is None and "cert_type" in self.model_fields_set:
            _dict['certType'] = None

        # set to None if key_file_md5 (nullable) is None
        # and model_fields_set contains the field
        if self.key_file_md5 is None and "key_file_md5" in self.model_fields_set:
            _dict['keyFileMD5'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListCertificates200ResponseCertificatesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "domainName": obj.get("domainName"),
            "accountId": obj.get("accountId"),
            "integrationId": obj.get("integrationId"),
            "enabled": obj.get("enabled"),
            "generated": obj.get("generated"),
            "wildcard": obj.get("wildcard"),
            "selfSigned": obj.get("selfSigned"),
            "type": ListCertificates200ResponseCertificatesInnerType.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "category": obj.get("category"),
            "commonName": obj.get("commonName"),
            "certType": obj.get("certType"),
            "keyFileMD5": obj.get("keyFileMD5")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


