# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from morpheus.models.list_clouds200_response_all_of_zones_inner_config import ListClouds200ResponseAllOfZonesInnerConfig
from morpheus.models.list_clouds200_response_all_of_zones_inner_credential import ListClouds200ResponseAllOfZonesInnerCredential
from morpheus.models.list_clouds200_response_all_of_zones_inner_groups_inner import ListClouds200ResponseAllOfZonesInnerGroupsInner
from morpheus.models.list_clouds200_response_all_of_zones_inner_stats import ListClouds200ResponseAllOfZonesInnerStats
from typing import Optional, Set
from typing_extensions import Self

class ListClouds200ResponseAllOfZonesInner(BaseModel):
    """
    ListClouds200ResponseAllOfZonesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    uuid: Optional[StrictStr] = None
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    name: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    labels: Optional[List[StrictStr]] = None
    location: Optional[StrictStr] = None
    owner: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    account_id: Optional[StrictInt] = Field(default=None, alias="accountId")
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    visibility: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    status: Optional[StrictStr] = None
    status_message: Optional[StrictStr] = Field(default=None, alias="statusMessage")
    status_date: Optional[datetime] = Field(default=None, alias="statusDate")
    cost_status: Optional[StrictStr] = Field(default=None, alias="costStatus")
    cost_status_message: Optional[StrictStr] = Field(default=None, alias="costStatusMessage")
    cost_status_date: Optional[datetime] = Field(default=None, alias="costStatusDate")
    cost_last_sync_duration: Optional[StrictInt] = Field(default=None, alias="costLastSyncDuration")
    cost_last_sync: Optional[datetime] = Field(default=None, alias="costLastSync")
    zone_type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = Field(default=None, alias="zoneType")
    zone_type_id: Optional[StrictInt] = Field(default=None, alias="zoneTypeId")
    guidance_mode: Optional[StrictStr] = Field(default=None, alias="guidanceMode")
    storage_mode: Optional[StrictStr] = Field(default=None, alias="storageMode")
    agent_mode: Optional[StrictStr] = Field(default=None, alias="agentMode")
    user_data_linux: Optional[StrictStr] = Field(default=None, alias="userDataLinux")
    user_data_windows: Optional[StrictStr] = Field(default=None, alias="userDataWindows")
    console_keymap: Optional[StrictStr] = Field(default=None, alias="consoleKeymap")
    container_mode: Optional[StrictStr] = Field(default=None, alias="containerMode")
    costing_mode: Optional[StrictStr] = Field(default=None, alias="costingMode")
    service_version: Optional[StrictStr] = Field(default=None, alias="serviceVersion")
    security_mode: Optional[StrictStr] = Field(default=None, alias="securityMode")
    inventory_level: Optional[StrictStr] = Field(default=None, alias="inventoryLevel")
    timezone: Optional[StrictStr] = None
    api_proxy: Optional[StrictStr] = Field(default=None, alias="apiProxy")
    provisioning_proxy: Optional[StrictStr] = Field(default=None, alias="provisioningProxy")
    network_domain: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = Field(default=None, alias="networkDomain")
    domain_name: Optional[StrictStr] = Field(default=None, alias="domainName")
    region_code: Optional[StrictStr] = Field(default=None, alias="regionCode")
    auto_recover_power_state: Optional[StrictBool] = Field(default=None, alias="autoRecoverPowerState")
    scale_priority: Optional[StrictInt] = Field(default=None, alias="scalePriority")
    default_datastore_sync_active: Optional[StrictBool] = Field(default=None, alias="defaultDatastoreSyncActive")
    default_network_sync_active: Optional[StrictBool] = Field(default=None, alias="defaultNetworkSyncActive")
    default_folder_sync_active: Optional[StrictBool] = Field(default=None, alias="defaultFolderSyncActive")
    default_security_group_sync_active: Optional[StrictBool] = Field(default=None, alias="defaultSecurityGroupSyncActive")
    default_pool_sync_active: Optional[StrictBool] = Field(default=None, alias="defaultPoolSyncActive")
    default_plan_sync_active: Optional[StrictBool] = Field(default=None, alias="defaultPlanSyncActive")
    config: Optional[ListClouds200ResponseAllOfZonesInnerConfig] = None
    credential: Optional[ListClouds200ResponseAllOfZonesInnerCredential] = None
    image_path: Optional[StrictStr] = Field(default=None, description="Logo image URL", alias="imagePath")
    dark_image_path: Optional[StrictStr] = Field(default=None, description="Dark logo image URL", alias="darkImagePath")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    last_sync: Optional[datetime] = Field(default=None, alias="lastSync")
    last_sync_duration: Optional[StrictInt] = Field(default=None, alias="lastSyncDuration")
    next_run_date: Optional[datetime] = Field(default=None, alias="nextRunDate")
    groups: Optional[List[ListClouds200ResponseAllOfZonesInnerGroupsInner]] = None
    security_server: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = Field(default=None, alias="securityServer")
    network_server: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = Field(default=None, alias="networkServer")
    stats: Optional[ListClouds200ResponseAllOfZonesInnerStats] = None
    server_count: Optional[StrictInt] = Field(default=None, alias="serverCount")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "uuid", "externalId", "name", "code", "labels", "location", "owner", "accountId", "account", "visibility", "enabled", "status", "statusMessage", "statusDate", "costStatus", "costStatusMessage", "costStatusDate", "costLastSyncDuration", "costLastSync", "zoneType", "zoneTypeId", "guidanceMode", "storageMode", "agentMode", "userDataLinux", "userDataWindows", "consoleKeymap", "containerMode", "costingMode", "serviceVersion", "securityMode", "inventoryLevel", "timezone", "apiProxy", "provisioningProxy", "networkDomain", "domainName", "regionCode", "autoRecoverPowerState", "scalePriority", "defaultDatastoreSyncActive", "defaultNetworkSyncActive", "defaultFolderSyncActive", "defaultSecurityGroupSyncActive", "defaultPoolSyncActive", "defaultPlanSyncActive", "config", "credential", "imagePath", "darkImagePath", "dateCreated", "lastUpdated", "lastSync", "lastSyncDuration", "nextRunDate", "groups", "securityServer", "networkServer", "stats", "serverCount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListClouds200ResponseAllOfZonesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of zone_type
        if self.zone_type:
            _dict['zoneType'] = self.zone_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network_domain
        if self.network_domain:
            _dict['networkDomain'] = self.network_domain.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of credential
        if self.credential:
            _dict['credential'] = self.credential.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in groups (list)
        _items = []
        if self.groups:
            for _item_groups in self.groups:
                if _item_groups:
                    _items.append(_item_groups.to_dict())
            _dict['groups'] = _items
        # override the default output from pydantic by calling `to_dict()` of security_server
        if self.security_server:
            _dict['securityServer'] = self.security_server.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network_server
        if self.network_server:
            _dict['networkServer'] = self.network_server.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stats
        if self.stats:
            _dict['stats'] = self.stats.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if location (nullable) is None
        # and model_fields_set contains the field
        if self.location is None and "location" in self.model_fields_set:
            _dict['location'] = None

        # set to None if status_message (nullable) is None
        # and model_fields_set contains the field
        if self.status_message is None and "status_message" in self.model_fields_set:
            _dict['statusMessage'] = None

        # set to None if status_date (nullable) is None
        # and model_fields_set contains the field
        if self.status_date is None and "status_date" in self.model_fields_set:
            _dict['statusDate'] = None

        # set to None if cost_status (nullable) is None
        # and model_fields_set contains the field
        if self.cost_status is None and "cost_status" in self.model_fields_set:
            _dict['costStatus'] = None

        # set to None if cost_status_message (nullable) is None
        # and model_fields_set contains the field
        if self.cost_status_message is None and "cost_status_message" in self.model_fields_set:
            _dict['costStatusMessage'] = None

        # set to None if cost_status_date (nullable) is None
        # and model_fields_set contains the field
        if self.cost_status_date is None and "cost_status_date" in self.model_fields_set:
            _dict['costStatusDate'] = None

        # set to None if cost_last_sync_duration (nullable) is None
        # and model_fields_set contains the field
        if self.cost_last_sync_duration is None and "cost_last_sync_duration" in self.model_fields_set:
            _dict['costLastSyncDuration'] = None

        # set to None if cost_last_sync (nullable) is None
        # and model_fields_set contains the field
        if self.cost_last_sync is None and "cost_last_sync" in self.model_fields_set:
            _dict['costLastSync'] = None

        # set to None if guidance_mode (nullable) is None
        # and model_fields_set contains the field
        if self.guidance_mode is None and "guidance_mode" in self.model_fields_set:
            _dict['guidanceMode'] = None

        # set to None if user_data_linux (nullable) is None
        # and model_fields_set contains the field
        if self.user_data_linux is None and "user_data_linux" in self.model_fields_set:
            _dict['userDataLinux'] = None

        # set to None if user_data_windows (nullable) is None
        # and model_fields_set contains the field
        if self.user_data_windows is None and "user_data_windows" in self.model_fields_set:
            _dict['userDataWindows'] = None

        # set to None if console_keymap (nullable) is None
        # and model_fields_set contains the field
        if self.console_keymap is None and "console_keymap" in self.model_fields_set:
            _dict['consoleKeymap'] = None

        # set to None if costing_mode (nullable) is None
        # and model_fields_set contains the field
        if self.costing_mode is None and "costing_mode" in self.model_fields_set:
            _dict['costingMode'] = None

        # set to None if service_version (nullable) is None
        # and model_fields_set contains the field
        if self.service_version is None and "service_version" in self.model_fields_set:
            _dict['serviceVersion'] = None

        # set to None if timezone (nullable) is None
        # and model_fields_set contains the field
        if self.timezone is None and "timezone" in self.model_fields_set:
            _dict['timezone'] = None

        # set to None if api_proxy (nullable) is None
        # and model_fields_set contains the field
        if self.api_proxy is None and "api_proxy" in self.model_fields_set:
            _dict['apiProxy'] = None

        # set to None if provisioning_proxy (nullable) is None
        # and model_fields_set contains the field
        if self.provisioning_proxy is None and "provisioning_proxy" in self.model_fields_set:
            _dict['provisioningProxy'] = None

        # set to None if region_code (nullable) is None
        # and model_fields_set contains the field
        if self.region_code is None and "region_code" in self.model_fields_set:
            _dict['regionCode'] = None

        # set to None if image_path (nullable) is None
        # and model_fields_set contains the field
        if self.image_path is None and "image_path" in self.model_fields_set:
            _dict['imagePath'] = None

        # set to None if dark_image_path (nullable) is None
        # and model_fields_set contains the field
        if self.dark_image_path is None and "dark_image_path" in self.model_fields_set:
            _dict['darkImagePath'] = None

        # set to None if last_sync (nullable) is None
        # and model_fields_set contains the field
        if self.last_sync is None and "last_sync" in self.model_fields_set:
            _dict['lastSync'] = None

        # set to None if last_sync_duration (nullable) is None
        # and model_fields_set contains the field
        if self.last_sync_duration is None and "last_sync_duration" in self.model_fields_set:
            _dict['lastSyncDuration'] = None

        # set to None if next_run_date (nullable) is None
        # and model_fields_set contains the field
        if self.next_run_date is None and "next_run_date" in self.model_fields_set:
            _dict['nextRunDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListClouds200ResponseAllOfZonesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "uuid": obj.get("uuid"),
            "externalId": obj.get("externalId"),
            "name": obj.get("name"),
            "code": obj.get("code"),
            "labels": obj.get("labels"),
            "location": obj.get("location"),
            "owner": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "accountId": obj.get("accountId"),
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "visibility": obj.get("visibility"),
            "enabled": obj.get("enabled"),
            "status": obj.get("status"),
            "statusMessage": obj.get("statusMessage"),
            "statusDate": obj.get("statusDate"),
            "costStatus": obj.get("costStatus"),
            "costStatusMessage": obj.get("costStatusMessage"),
            "costStatusDate": obj.get("costStatusDate"),
            "costLastSyncDuration": obj.get("costLastSyncDuration"),
            "costLastSync": obj.get("costLastSync"),
            "zoneType": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["zoneType"]) if obj.get("zoneType") is not None else None,
            "zoneTypeId": obj.get("zoneTypeId"),
            "guidanceMode": obj.get("guidanceMode"),
            "storageMode": obj.get("storageMode"),
            "agentMode": obj.get("agentMode"),
            "userDataLinux": obj.get("userDataLinux"),
            "userDataWindows": obj.get("userDataWindows"),
            "consoleKeymap": obj.get("consoleKeymap"),
            "containerMode": obj.get("containerMode"),
            "costingMode": obj.get("costingMode"),
            "serviceVersion": obj.get("serviceVersion"),
            "securityMode": obj.get("securityMode"),
            "inventoryLevel": obj.get("inventoryLevel"),
            "timezone": obj.get("timezone"),
            "apiProxy": obj.get("apiProxy"),
            "provisioningProxy": obj.get("provisioningProxy"),
            "networkDomain": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["networkDomain"]) if obj.get("networkDomain") is not None else None,
            "domainName": obj.get("domainName"),
            "regionCode": obj.get("regionCode"),
            "autoRecoverPowerState": obj.get("autoRecoverPowerState"),
            "scalePriority": obj.get("scalePriority"),
            "defaultDatastoreSyncActive": obj.get("defaultDatastoreSyncActive"),
            "defaultNetworkSyncActive": obj.get("defaultNetworkSyncActive"),
            "defaultFolderSyncActive": obj.get("defaultFolderSyncActive"),
            "defaultSecurityGroupSyncActive": obj.get("defaultSecurityGroupSyncActive"),
            "defaultPoolSyncActive": obj.get("defaultPoolSyncActive"),
            "defaultPlanSyncActive": obj.get("defaultPlanSyncActive"),
            "config": ListClouds200ResponseAllOfZonesInnerConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "credential": ListClouds200ResponseAllOfZonesInnerCredential.from_dict(obj["credential"]) if obj.get("credential") is not None else None,
            "imagePath": obj.get("imagePath"),
            "darkImagePath": obj.get("darkImagePath"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "lastSync": obj.get("lastSync"),
            "lastSyncDuration": obj.get("lastSyncDuration"),
            "nextRunDate": obj.get("nextRunDate"),
            "groups": [ListClouds200ResponseAllOfZonesInnerGroupsInner.from_dict(_item) for _item in obj["groups"]] if obj.get("groups") is not None else None,
            "securityServer": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["securityServer"]) if obj.get("securityServer") is not None else None,
            "networkServer": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["networkServer"]) if obj.get("networkServer") is not None else None,
            "stats": ListClouds200ResponseAllOfZonesInnerStats.from_dict(obj["stats"]) if obj.get("stats") is not None else None,
            "serverCount": obj.get("serverCount")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


