# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_clouds200_response_all_of_zones_inner_config_any_of_network_server import ListClouds200ResponseAllOfZonesInnerConfigAnyOfNetworkServer
from typing import Optional, Set
from typing_extensions import Self

class ListClouds200ResponseAllOfZonesInnerConfigAnyOf2(BaseModel):
    """
    ListClouds200ResponseAllOfZonesInnerConfigAnyOf2
    """ # noqa: E501
    subscriber_id: Optional[StrictStr] = Field(default=None, alias="subscriberId")
    tenant_id: Optional[StrictStr] = Field(default=None, alias="tenantId")
    client_id: Optional[StrictStr] = Field(default=None, alias="clientId")
    client_secret: Optional[StrictStr] = Field(default=None, alias="clientSecret")
    resource_group: Optional[StrictStr] = Field(default=None, alias="resourceGroup")
    import_existing: Optional[StrictStr] = Field(default=None, alias="importExisting")
    inventory_level: Optional[StrictStr] = Field(default=None, alias="inventoryLevel")
    appliance_url: Optional[StrictStr] = Field(default=None, alias="applianceUrl")
    datacenter_name: Optional[StrictStr] = Field(default=None, alias="datacenterName")
    network_server_id: Optional[StrictStr] = Field(default=None, alias="networkServer.id")
    network_server: Optional[ListClouds200ResponseAllOfZonesInnerConfigAnyOfNetworkServer] = Field(default=None, alias="networkServer")
    security_mode: Optional[StrictStr] = Field(default=None, alias="securityMode")
    certificate_provider: Optional[StrictStr] = Field(default=None, alias="certificateProvider")
    backup_mode: Optional[StrictStr] = Field(default=None, alias="backupMode")
    replication_mode: Optional[StrictStr] = Field(default=None, alias="replicationMode")
    dns_integration_id: Optional[StrictStr] = Field(default=None, alias="dnsIntegrationId")
    config_management_id: Optional[StrictStr] = Field(default=None, alias="configManagementId")
    config_cmdb_id: Optional[StrictStr] = Field(default=None, alias="configCmdbId")
    security_server: Optional[StrictStr] = Field(default=None, alias="securityServer")
    account_type: Optional[StrictStr] = Field(default=None, alias="accountType")
    service_registry_id: Optional[StrictStr] = Field(default=None, alias="serviceRegistryId")
    cloud_type: Optional[StrictStr] = Field(default=None, alias="cloudType")
    rpc_mode: Optional[StrictStr] = Field(default=None, alias="rpcMode")
    disk_encryption: Optional[StrictStr] = Field(default=None, alias="diskEncryption")
    encryption_set: Optional[StrictStr] = Field(default=None, alias="encryptionSet")
    csp_tenant_id: Optional[StrictStr] = Field(default=None, alias="cspTenantId")
    csp_client_id: Optional[StrictStr] = Field(default=None, alias="cspClientId")
    csp_client_secret: Optional[StrictStr] = Field(default=None, alias="cspClientSecret")
    csp_customer: Optional[StrictStr] = Field(default=None, alias="cspCustomer")
    config_cmdb_discovery: Optional[StrictBool] = Field(default=None, alias="configCmdbDiscovery")
    azure_costing_mode: Optional[StrictStr] = Field(default=None, alias="azureCostingMode")
    client_secret_hash: Optional[StrictStr] = Field(default=None, alias="clientSecretHash")
    csp_client_secret_hash: Optional[StrictStr] = Field(default=None, alias="cspClientSecretHash")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["subscriberId", "tenantId", "clientId", "clientSecret", "resourceGroup", "importExisting", "inventoryLevel", "applianceUrl", "datacenterName", "networkServer.id", "networkServer", "securityMode", "certificateProvider", "backupMode", "replicationMode", "dnsIntegrationId", "configManagementId", "configCmdbId", "securityServer", "accountType", "serviceRegistryId", "cloudType", "rpcMode", "diskEncryption", "encryptionSet", "cspTenantId", "cspClientId", "cspClientSecret", "cspCustomer", "configCmdbDiscovery", "azureCostingMode", "clientSecretHash", "cspClientSecretHash"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListClouds200ResponseAllOfZonesInnerConfigAnyOf2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of network_server
        if self.network_server:
            _dict['networkServer'] = self.network_server.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if security_server (nullable) is None
        # and model_fields_set contains the field
        if self.security_server is None and "security_server" in self.model_fields_set:
            _dict['securityServer'] = None

        # set to None if csp_client_secret (nullable) is None
        # and model_fields_set contains the field
        if self.csp_client_secret is None and "csp_client_secret" in self.model_fields_set:
            _dict['cspClientSecret'] = None

        # set to None if csp_customer (nullable) is None
        # and model_fields_set contains the field
        if self.csp_customer is None and "csp_customer" in self.model_fields_set:
            _dict['cspCustomer'] = None

        # set to None if csp_client_secret_hash (nullable) is None
        # and model_fields_set contains the field
        if self.csp_client_secret_hash is None and "csp_client_secret_hash" in self.model_fields_set:
            _dict['cspClientSecretHash'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListClouds200ResponseAllOfZonesInnerConfigAnyOf2 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "subscriberId": obj.get("subscriberId"),
            "tenantId": obj.get("tenantId"),
            "clientId": obj.get("clientId"),
            "clientSecret": obj.get("clientSecret"),
            "resourceGroup": obj.get("resourceGroup"),
            "importExisting": obj.get("importExisting"),
            "inventoryLevel": obj.get("inventoryLevel"),
            "applianceUrl": obj.get("applianceUrl"),
            "datacenterName": obj.get("datacenterName"),
            "networkServer.id": obj.get("networkServer.id"),
            "networkServer": ListClouds200ResponseAllOfZonesInnerConfigAnyOfNetworkServer.from_dict(obj["networkServer"]) if obj.get("networkServer") is not None else None,
            "securityMode": obj.get("securityMode"),
            "certificateProvider": obj.get("certificateProvider"),
            "backupMode": obj.get("backupMode"),
            "replicationMode": obj.get("replicationMode"),
            "dnsIntegrationId": obj.get("dnsIntegrationId"),
            "configManagementId": obj.get("configManagementId"),
            "configCmdbId": obj.get("configCmdbId"),
            "securityServer": obj.get("securityServer"),
            "accountType": obj.get("accountType"),
            "serviceRegistryId": obj.get("serviceRegistryId"),
            "cloudType": obj.get("cloudType"),
            "rpcMode": obj.get("rpcMode"),
            "diskEncryption": obj.get("diskEncryption"),
            "encryptionSet": obj.get("encryptionSet"),
            "cspTenantId": obj.get("cspTenantId"),
            "cspClientId": obj.get("cspClientId"),
            "cspClientSecret": obj.get("cspClientSecret"),
            "cspCustomer": obj.get("cspCustomer"),
            "configCmdbDiscovery": obj.get("configCmdbDiscovery"),
            "azureCostingMode": obj.get("azureCostingMode"),
            "clientSecretHash": obj.get("clientSecretHash"),
            "cspClientSecretHash": obj.get("cspClientSecretHash")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


