# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_activity200_response_all_of_activity_inner_activity_inner_user import ListActivity200ResponseAllOfActivityInnerActivityInnerUser
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from typing import Optional, Set
from typing_extensions import Self

class ListClusterJobs200ResponseAllOfJobsInner(BaseModel):
    """
    ListClusterJobs200ResponseAllOfJobsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    labels: Optional[List[StrictStr]] = None
    type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = None
    job_summary: Optional[StrictStr] = Field(default=None, alias="jobSummary")
    schedule_mode: Optional[StrictStr] = Field(default=None, alias="scheduleMode")
    date_time: Optional[datetime] = Field(default=None, alias="dateTime")
    status: Optional[StrictStr] = None
    namespace: Optional[StrictStr] = None
    category: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    last_run: Optional[datetime] = Field(default=None, alias="lastRun")
    last_result: Optional[StrictStr] = Field(default=None, alias="lastResult")
    created_by: Optional[ListActivity200ResponseAllOfActivityInnerActivityInnerUser] = Field(default=None, alias="createdBy")
    target_type: Optional[StrictStr] = Field(default=None, alias="targetType")
    targets: Optional[List[Dict[str, Any]]] = None
    custom_config: Optional[Dict[str, Any]] = Field(default=None, alias="customConfig")
    custom_options: Optional[Dict[str, Any]] = Field(default=None, alias="customOptions")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "labels", "type", "jobSummary", "scheduleMode", "dateTime", "status", "namespace", "category", "description", "enabled", "dateCreated", "lastUpdated", "lastRun", "lastResult", "createdBy", "targetType", "targets", "customConfig", "customOptions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListClusterJobs200ResponseAllOfJobsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if job_summary (nullable) is None
        # and model_fields_set contains the field
        if self.job_summary is None and "job_summary" in self.model_fields_set:
            _dict['jobSummary'] = None

        # set to None if schedule_mode (nullable) is None
        # and model_fields_set contains the field
        if self.schedule_mode is None and "schedule_mode" in self.model_fields_set:
            _dict['scheduleMode'] = None

        # set to None if date_time (nullable) is None
        # and model_fields_set contains the field
        if self.date_time is None and "date_time" in self.model_fields_set:
            _dict['dateTime'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if namespace (nullable) is None
        # and model_fields_set contains the field
        if self.namespace is None and "namespace" in self.model_fields_set:
            _dict['namespace'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if last_run (nullable) is None
        # and model_fields_set contains the field
        if self.last_run is None and "last_run" in self.model_fields_set:
            _dict['lastRun'] = None

        # set to None if last_result (nullable) is None
        # and model_fields_set contains the field
        if self.last_result is None and "last_result" in self.model_fields_set:
            _dict['lastResult'] = None

        # set to None if target_type (nullable) is None
        # and model_fields_set contains the field
        if self.target_type is None and "target_type" in self.model_fields_set:
            _dict['targetType'] = None

        # set to None if custom_config (nullable) is None
        # and model_fields_set contains the field
        if self.custom_config is None and "custom_config" in self.model_fields_set:
            _dict['customConfig'] = None

        # set to None if custom_options (nullable) is None
        # and model_fields_set contains the field
        if self.custom_options is None and "custom_options" in self.model_fields_set:
            _dict['customOptions'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListClusterJobs200ResponseAllOfJobsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "labels": obj.get("labels"),
            "type": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "jobSummary": obj.get("jobSummary"),
            "scheduleMode": obj.get("scheduleMode"),
            "dateTime": obj.get("dateTime"),
            "status": obj.get("status"),
            "namespace": obj.get("namespace"),
            "category": obj.get("category"),
            "description": obj.get("description"),
            "enabled": obj.get("enabled"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "lastRun": obj.get("lastRun"),
            "lastResult": obj.get("lastResult"),
            "createdBy": ListActivity200ResponseAllOfActivityInnerActivityInnerUser.from_dict(obj["createdBy"]) if obj.get("createdBy") is not None else None,
            "targetType": obj.get("targetType"),
            "targets": obj.get("targets"),
            "customConfig": obj.get("customConfig"),
            "customOptions": obj.get("customOptions")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


