# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from typing import Optional, Set
from typing_extensions import Self

class ListFileTemplates200ResponseAllOfContainerTemplatesInner(BaseModel):
    """
    ListFileTemplates200ResponseAllOfContainerTemplatesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    code: Optional[StrictStr] = None
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    name: Optional[StrictStr] = None
    labels: Optional[List[StrictStr]] = None
    file_name: Optional[StrictStr] = Field(default=None, alias="fileName")
    file_path: Optional[StrictStr] = Field(default=None, alias="filePath")
    template_type: Optional[StrictStr] = Field(default=None, alias="templateType")
    template_phase: Optional[StrictStr] = Field(default=None, alias="templatePhase")
    template: Optional[StrictStr] = None
    category: Optional[StrictStr] = None
    setting_category: Optional[StrictStr] = Field(default=None, alias="settingCategory")
    setting_name: Optional[StrictStr] = Field(default=None, alias="settingName")
    auto_run: Optional[StrictBool] = Field(default=None, alias="autoRun")
    run_on_scale: Optional[StrictBool] = Field(default=None, alias="runOnScale")
    run_on_deploy: Optional[StrictBool] = Field(default=None, alias="runOnDeploy")
    file_owner: Optional[StrictStr] = Field(default=None, alias="fileOwner")
    file_group: Optional[StrictStr] = Field(default=None, alias="fileGroup")
    permissions: Optional[StrictStr] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "code", "account", "name", "labels", "fileName", "filePath", "templateType", "templatePhase", "template", "category", "settingCategory", "settingName", "autoRun", "runOnScale", "runOnDeploy", "fileOwner", "fileGroup", "permissions", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListFileTemplates200ResponseAllOfContainerTemplatesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        # set to None if template_type (nullable) is None
        # and model_fields_set contains the field
        if self.template_type is None and "template_type" in self.model_fields_set:
            _dict['templateType'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if setting_category (nullable) is None
        # and model_fields_set contains the field
        if self.setting_category is None and "setting_category" in self.model_fields_set:
            _dict['settingCategory'] = None

        # set to None if setting_name (nullable) is None
        # and model_fields_set contains the field
        if self.setting_name is None and "setting_name" in self.model_fields_set:
            _dict['settingName'] = None

        # set to None if run_on_scale (nullable) is None
        # and model_fields_set contains the field
        if self.run_on_scale is None and "run_on_scale" in self.model_fields_set:
            _dict['runOnScale'] = None

        # set to None if run_on_deploy (nullable) is None
        # and model_fields_set contains the field
        if self.run_on_deploy is None and "run_on_deploy" in self.model_fields_set:
            _dict['runOnDeploy'] = None

        # set to None if file_owner (nullable) is None
        # and model_fields_set contains the field
        if self.file_owner is None and "file_owner" in self.model_fields_set:
            _dict['fileOwner'] = None

        # set to None if file_group (nullable) is None
        # and model_fields_set contains the field
        if self.file_group is None and "file_group" in self.model_fields_set:
            _dict['fileGroup'] = None

        # set to None if permissions (nullable) is None
        # and model_fields_set contains the field
        if self.permissions is None and "permissions" in self.model_fields_set:
            _dict['permissions'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListFileTemplates200ResponseAllOfContainerTemplatesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "code": obj.get("code"),
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "name": obj.get("name"),
            "labels": obj.get("labels"),
            "fileName": obj.get("fileName"),
            "filePath": obj.get("filePath"),
            "templateType": obj.get("templateType"),
            "templatePhase": obj.get("templatePhase"),
            "template": obj.get("template"),
            "category": obj.get("category"),
            "settingCategory": obj.get("settingCategory"),
            "settingName": obj.get("settingName"),
            "autoRun": obj.get("autoRun"),
            "runOnScale": obj.get("runOnScale"),
            "runOnDeploy": obj.get("runOnDeploy"),
            "fileOwner": obj.get("fileOwner"),
            "fileGroup": obj.get("fileGroup"),
            "permissions": obj.get("permissions"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


