# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from morpheus.models.list_guidances200_response_all_of_discoveries_inner_any_of import ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf
from morpheus.models.list_guidances200_response_all_of_discoveries_inner_any_of1 import ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf1
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

LISTGUIDANCES200RESPONSEALLOFDISCOVERIESINNER_ANY_OF_SCHEMAS = ["ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf", "ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf1"]

class ListGuidances200ResponseAllOfDiscoveriesInner(BaseModel):
    """
    ListGuidances200ResponseAllOfDiscoveriesInner
    """

    # data type: ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf
    anyof_schema_1_validator: Optional[ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf] = None
    # data type: ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf1
    anyof_schema_2_validator: Optional[ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf1] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf, ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf1]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf", "ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf1" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = ListGuidances200ResponseAllOfDiscoveriesInner.model_construct()
        error_messages = []
        # validate data type: ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf
        if not isinstance(v, ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf`")
        else:
            return v

        # validate data type: ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf1
        if not isinstance(v, ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf1):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf1`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in ListGuidances200ResponseAllOfDiscoveriesInner with anyOf schemas: ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf, ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf1. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf] = None
        try:
            instance.actual_instance = ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf1] = None
        try:
            instance.actual_instance = ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf1.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ListGuidances200ResponseAllOfDiscoveriesInner with anyOf schemas: ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf, ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf1. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf, ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf1]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


