# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from typing import Optional, Set
from typing_extensions import Self

class ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResourceInterfacesInner(BaseModel):
    """
    ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResourceInterfacesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    ref_type: Optional[StrictStr] = Field(default=None, alias="refType")
    ref_id: Optional[StrictStr] = Field(default=None, alias="refId")
    name: Optional[StrictStr] = None
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    unique_id: Optional[StrictStr] = Field(default=None, alias="uniqueId")
    public_ip_address: Optional[StrictStr] = Field(default=None, alias="publicIpAddress")
    public_ipv6_address: Optional[StrictStr] = Field(default=None, alias="publicIpv6Address")
    ip_address: Optional[StrictStr] = Field(default=None, alias="ipAddress")
    ipv6_address: Optional[StrictStr] = Field(default=None, alias="ipv6Address")
    ip_subnet: Optional[StrictStr] = Field(default=None, alias="ipSubnet")
    ipv6_subnet: Optional[StrictStr] = Field(default=None, alias="ipv6Subnet")
    description: Optional[StrictStr] = None
    dhcp: Optional[StrictBool] = None
    active: Optional[StrictBool] = None
    pool_assigned: Optional[StrictBool] = Field(default=None, alias="poolAssigned")
    primary_interface: Optional[StrictBool] = Field(default=None, alias="primaryInterface")
    network: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    subnet: Optional[StrictStr] = None
    network_group: Optional[StrictStr] = Field(default=None, alias="networkGroup")
    network_position: Optional[StrictStr] = Field(default=None, alias="networkPosition")
    network_pool: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = Field(default=None, alias="networkPool")
    network_domain: Optional[StrictStr] = Field(default=None, alias="networkDomain")
    type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = None
    ip_mode: Optional[StrictStr] = Field(default=None, alias="ipMode")
    mac_address: Optional[StrictStr] = Field(default=None, alias="macAddress")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "refType", "refId", "name", "internalId", "externalId", "uniqueId", "publicIpAddress", "publicIpv6Address", "ipAddress", "ipv6Address", "ipSubnet", "ipv6Subnet", "description", "dhcp", "active", "poolAssigned", "primaryInterface", "network", "subnet", "networkGroup", "networkPosition", "networkPool", "networkDomain", "type", "ipMode", "macAddress"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResourceInterfacesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of network
        if self.network:
            _dict['network'] = self.network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network_pool
        if self.network_pool:
            _dict['networkPool'] = self.network_pool.to_dict()
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if ref_type (nullable) is None
        # and model_fields_set contains the field
        if self.ref_type is None and "ref_type" in self.model_fields_set:
            _dict['refType'] = None

        # set to None if ref_id (nullable) is None
        # and model_fields_set contains the field
        if self.ref_id is None and "ref_id" in self.model_fields_set:
            _dict['refId'] = None

        # set to None if unique_id (nullable) is None
        # and model_fields_set contains the field
        if self.unique_id is None and "unique_id" in self.model_fields_set:
            _dict['uniqueId'] = None

        # set to None if public_ipv6_address (nullable) is None
        # and model_fields_set contains the field
        if self.public_ipv6_address is None and "public_ipv6_address" in self.model_fields_set:
            _dict['publicIpv6Address'] = None

        # set to None if ip_subnet (nullable) is None
        # and model_fields_set contains the field
        if self.ip_subnet is None and "ip_subnet" in self.model_fields_set:
            _dict['ipSubnet'] = None

        # set to None if ipv6_subnet (nullable) is None
        # and model_fields_set contains the field
        if self.ipv6_subnet is None and "ipv6_subnet" in self.model_fields_set:
            _dict['ipv6Subnet'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if subnet (nullable) is None
        # and model_fields_set contains the field
        if self.subnet is None and "subnet" in self.model_fields_set:
            _dict['subnet'] = None

        # set to None if network_group (nullable) is None
        # and model_fields_set contains the field
        if self.network_group is None and "network_group" in self.model_fields_set:
            _dict['networkGroup'] = None

        # set to None if network_position (nullable) is None
        # and model_fields_set contains the field
        if self.network_position is None and "network_position" in self.model_fields_set:
            _dict['networkPosition'] = None

        # set to None if network_domain (nullable) is None
        # and model_fields_set contains the field
        if self.network_domain is None and "network_domain" in self.model_fields_set:
            _dict['networkDomain'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResourceInterfacesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "refType": obj.get("refType"),
            "refId": obj.get("refId"),
            "name": obj.get("name"),
            "internalId": obj.get("internalId"),
            "externalId": obj.get("externalId"),
            "uniqueId": obj.get("uniqueId"),
            "publicIpAddress": obj.get("publicIpAddress"),
            "publicIpv6Address": obj.get("publicIpv6Address"),
            "ipAddress": obj.get("ipAddress"),
            "ipv6Address": obj.get("ipv6Address"),
            "ipSubnet": obj.get("ipSubnet"),
            "ipv6Subnet": obj.get("ipv6Subnet"),
            "description": obj.get("description"),
            "dhcp": obj.get("dhcp"),
            "active": obj.get("active"),
            "poolAssigned": obj.get("poolAssigned"),
            "primaryInterface": obj.get("primaryInterface"),
            "network": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["network"]) if obj.get("network") is not None else None,
            "subnet": obj.get("subnet"),
            "networkGroup": obj.get("networkGroup"),
            "networkPosition": obj.get("networkPosition"),
            "networkPool": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["networkPool"]) if obj.get("networkPool") is not None else None,
            "networkDomain": obj.get("networkDomain"),
            "type": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "ipMode": obj.get("ipMode"),
            "macAddress": obj.get("macAddress")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


