# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_health200_response_all_of_health_elastic_master import ListHealth200ResponseAllOfHealthElasticMaster
from morpheus.models.list_health200_response_all_of_health_elastic_nodes_inner import ListHealth200ResponseAllOfHealthElasticNodesInner
from morpheus.models.list_health200_response_all_of_health_elastic_stats import ListHealth200ResponseAllOfHealthElasticStats
from typing import Optional, Set
from typing_extensions import Self

class ListHealth200ResponseAllOfHealthElastic(BaseModel):
    """
    ListHealth200ResponseAllOfHealthElastic
    """ # noqa: E501
    success: Optional[StrictBool] = None
    status: Optional[StrictStr] = None
    master: Optional[ListHealth200ResponseAllOfHealthElasticMaster] = None
    nodes: Optional[List[ListHealth200ResponseAllOfHealthElasticNodesInner]] = None
    stats: Optional[ListHealth200ResponseAllOfHealthElasticStats] = None
    indices: Optional[List[Dict[str, Any]]] = None
    bad_indices: Optional[List[Dict[str, Any]]] = Field(default=None, alias="badIndices")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["success", "status", "master", "nodes", "stats", "indices", "badIndices"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListHealth200ResponseAllOfHealthElastic from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of master
        if self.master:
            _dict['master'] = self.master.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in nodes (list)
        _items = []
        if self.nodes:
            for _item_nodes in self.nodes:
                if _item_nodes:
                    _items.append(_item_nodes.to_dict())
            _dict['nodes'] = _items
        # override the default output from pydantic by calling `to_dict()` of stats
        if self.stats:
            _dict['stats'] = self.stats.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if indices (nullable) is None
        # and model_fields_set contains the field
        if self.indices is None and "indices" in self.model_fields_set:
            _dict['indices'] = None

        # set to None if bad_indices (nullable) is None
        # and model_fields_set contains the field
        if self.bad_indices is None and "bad_indices" in self.model_fields_set:
            _dict['badIndices'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListHealth200ResponseAllOfHealthElastic from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "success": obj.get("success"),
            "status": obj.get("status"),
            "master": ListHealth200ResponseAllOfHealthElasticMaster.from_dict(obj["master"]) if obj.get("master") is not None else None,
            "nodes": [ListHealth200ResponseAllOfHealthElasticNodesInner.from_dict(_item) for _item in obj["nodes"]] if obj.get("nodes") is not None else None,
            "stats": ListHealth200ResponseAllOfHealthElasticStats.from_dict(obj["stats"]) if obj.get("stats") is not None else None,
            "indices": obj.get("indices"),
            "badIndices": obj.get("badIndices")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


