# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ListHealth200ResponseAllOfHealthThreadsBusyThreadsInner(BaseModel):
    """
    ListHealth200ResponseAllOfHealthThreadsBusyThreadsInner
    """ # noqa: E501
    thread_id: Optional[StrictInt] = Field(default=None, alias="threadId")
    name: Optional[StrictStr] = None
    cpu_time: Optional[StrictInt] = Field(default=None, alias="cpuTime")
    blocked_time: Optional[StrictInt] = Field(default=None, alias="blockedTime")
    lock_name: Optional[StrictStr] = Field(default=None, alias="lockName")
    lock_owner_id: Optional[StrictInt] = Field(default=None, alias="lockOwnerId")
    lock_owner_name: Optional[StrictStr] = Field(default=None, alias="lockOwnerName")
    state: Optional[StrictStr] = None
    waited_count: Optional[StrictInt] = Field(default=None, alias="waitedCount")
    waited_time: Optional[StrictInt] = Field(default=None, alias="waitedTime")
    is_in_native: Optional[StrictBool] = Field(default=None, alias="isInNative")
    is_suspended: Optional[StrictBool] = Field(default=None, alias="isSuspended")
    locked_monitors: Optional[List[Dict[str, Any]]] = Field(default=None, alias="lockedMonitors")
    locked_synchronizers: Optional[List[Dict[str, Any]]] = Field(default=None, alias="lockedSynchronizers")
    lock_info: Optional[StrictStr] = Field(default=None, alias="lockInfo")
    current_lines: Optional[StrictStr] = Field(default=None, alias="currentLines")
    cpu_percent: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="cpuPercent")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["threadId", "name", "cpuTime", "blockedTime", "lockName", "lockOwnerId", "lockOwnerName", "state", "waitedCount", "waitedTime", "isInNative", "isSuspended", "lockedMonitors", "lockedSynchronizers", "lockInfo", "currentLines", "cpuPercent"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListHealth200ResponseAllOfHealthThreadsBusyThreadsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if lock_name (nullable) is None
        # and model_fields_set contains the field
        if self.lock_name is None and "lock_name" in self.model_fields_set:
            _dict['lockName'] = None

        # set to None if lock_owner_name (nullable) is None
        # and model_fields_set contains the field
        if self.lock_owner_name is None and "lock_owner_name" in self.model_fields_set:
            _dict['lockOwnerName'] = None

        # set to None if locked_monitors (nullable) is None
        # and model_fields_set contains the field
        if self.locked_monitors is None and "locked_monitors" in self.model_fields_set:
            _dict['lockedMonitors'] = None

        # set to None if locked_synchronizers (nullable) is None
        # and model_fields_set contains the field
        if self.locked_synchronizers is None and "locked_synchronizers" in self.model_fields_set:
            _dict['lockedSynchronizers'] = None

        # set to None if lock_info (nullable) is None
        # and model_fields_set contains the field
        if self.lock_info is None and "lock_info" in self.model_fields_set:
            _dict['lockInfo'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListHealth200ResponseAllOfHealthThreadsBusyThreadsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "threadId": obj.get("threadId"),
            "name": obj.get("name"),
            "cpuTime": obj.get("cpuTime"),
            "blockedTime": obj.get("blockedTime"),
            "lockName": obj.get("lockName"),
            "lockOwnerId": obj.get("lockOwnerId"),
            "lockOwnerName": obj.get("lockOwnerName"),
            "state": obj.get("state"),
            "waitedCount": obj.get("waitedCount"),
            "waitedTime": obj.get("waitedTime"),
            "isInNative": obj.get("isInNative"),
            "isSuspended": obj.get("isSuspended"),
            "lockedMonitors": obj.get("lockedMonitors"),
            "lockedSynchronizers": obj.get("lockedSynchronizers"),
            "lockInfo": obj.get("lockInfo"),
            "currentLines": obj.get("currentLines"),
            "cpuPercent": obj.get("cpuPercent")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


