# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.get_alerts200_response_all_of_checks_inner_account import GetAlerts200ResponseAllOfChecksInnerAccount
from morpheus.models.list_activity200_response_all_of_activity_inner_activity_inner_user import ListActivity200ResponseAllOfActivityInnerActivityInnerUser
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from morpheus.models.list_cluster_layouts200_response_all_of_layouts_inner_compute_servers_inner_compute_server_type import ListClusterLayouts200ResponseAllOfLayoutsInnerComputeServersInnerComputeServerType
from morpheus.models.list_cluster_volumes200_response_all_of_volumes_inner import ListClusterVolumes200ResponseAllOfVolumesInner
from morpheus.models.list_guidances200_response_all_of_discoveries_inner_any_of_resource_controllers_inner import ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResourceControllersInner
from morpheus.models.list_hosts200_response_all_of_servers_inner_config import ListHosts200ResponseAllOfServersInnerConfig
from morpheus.models.list_hosts200_response_all_of_servers_inner_instance import ListHosts200ResponseAllOfServersInnerInstance
from morpheus.models.list_hosts200_response_all_of_servers_inner_interfaces_inner import ListHosts200ResponseAllOfServersInnerInterfacesInner
from morpheus.models.list_hosts200_response_all_of_servers_inner_plan import ListHosts200ResponseAllOfServersInnerPlan
from morpheus.models.list_hosts200_response_all_of_servers_inner_server_os import ListHosts200ResponseAllOfServersInnerServerOs
from morpheus.models.list_hosts200_response_all_of_servers_inner_stats import ListHosts200ResponseAllOfServersInnerStats
from typing import Optional, Set
from typing_extensions import Self

class ListHosts200ResponseAllOfServersInner(BaseModel):
    """
    ListHosts200ResponseAllOfServersInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    uuid: Optional[StrictStr] = None
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    external_unique_id: Optional[StrictStr] = Field(default=None, alias="externalUniqueId")
    name: Optional[StrictStr] = None
    external_name: Optional[StrictStr] = Field(default=None, alias="externalName")
    hostname: Optional[StrictStr] = None
    parent_server: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = Field(default=None, alias="parentServer")
    account_id: Optional[StrictInt] = Field(default=None, alias="accountId")
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    owner: Optional[ListActivity200ResponseAllOfActivityInnerActivityInnerUser] = None
    zone: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    plan: Optional[ListHosts200ResponseAllOfServersInnerPlan] = None
    compute_server_type: Optional[ListClusterLayouts200ResponseAllOfLayoutsInnerComputeServersInnerComputeServerType] = Field(default=None, alias="computeServerType")
    visibility: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    zone_id: Optional[StrictInt] = Field(default=None, alias="zoneId")
    site_id: Optional[StrictInt] = Field(default=None, alias="siteId")
    resource_pool_id: Optional[StrictInt] = Field(default=None, alias="resourcePoolId")
    folder_id: Optional[StrictInt] = Field(default=None, alias="folderId")
    ssh_host: Optional[StrictStr] = Field(default=None, alias="sshHost")
    ssh_port: Optional[StrictInt] = Field(default=None, alias="sshPort")
    external_ip: Optional[StrictStr] = Field(default=None, alias="externalIp")
    internal_ip: Optional[StrictStr] = Field(default=None, alias="internalIp")
    volume_id: Optional[StrictStr] = Field(default=None, alias="volumeId")
    platform: Optional[StrictStr] = None
    platform_version: Optional[StrictStr] = Field(default=None, alias="platformVersion")
    ssh_username: Optional[StrictStr] = Field(default=None, alias="sshUsername")
    ssh_password: Optional[StrictStr] = Field(default=None, alias="sshPassword")
    ssh_password_hash: Optional[StrictStr] = Field(default=None, alias="sshPasswordHash")
    ssh_key_pair: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = Field(default=None, alias="sshKeyPair")
    os_device: Optional[StrictStr] = Field(default=None, alias="osDevice")
    os_type: Optional[StrictStr] = Field(default=None, alias="osType")
    data_device: Optional[StrictStr] = Field(default=None, alias="dataDevice")
    lvm_enabled: Optional[StrictBool] = Field(default=None, alias="lvmEnabled")
    api_key: Optional[StrictStr] = Field(default=None, alias="apiKey")
    software_raid: Optional[StrictBool] = Field(default=None, alias="softwareRaid")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    stats: Optional[ListHosts200ResponseAllOfServersInnerStats] = None
    status: Optional[StrictStr] = None
    status_message: Optional[StrictStr] = Field(default=None, alias="statusMessage")
    error_message: Optional[StrictStr] = Field(default=None, alias="errorMessage")
    status_date: Optional[datetime] = Field(default=None, alias="statusDate")
    status_percent: Optional[StrictStr] = Field(default=None, alias="statusPercent")
    status_eta: Optional[StrictStr] = Field(default=None, alias="statusEta")
    power_state: Optional[StrictStr] = Field(default=None, alias="powerState")
    agent_installed: Optional[StrictBool] = Field(default=None, alias="agentInstalled")
    last_agent_update: Optional[StrictStr] = Field(default=None, alias="lastAgentUpdate")
    agent_version: Optional[StrictStr] = Field(default=None, alias="agentVersion")
    max_cores: Optional[StrictInt] = Field(default=None, alias="maxCores")
    cores_per_socket: Optional[StrictInt] = Field(default=None, alias="coresPerSocket")
    max_memory: Optional[StrictInt] = Field(default=None, alias="maxMemory")
    max_storage: Optional[StrictInt] = Field(default=None, alias="maxStorage")
    max_cpu: Optional[StrictInt] = Field(default=None, alias="maxCpu")
    max_gpus: Optional[StrictInt] = Field(default=None, alias="maxGpus")
    manage_internal_firewall: Optional[StrictBool] = Field(default=None, alias="manageInternalFirewall")
    enable_logs: Optional[StrictBool] = Field(default=None, alias="enableLogs")
    hourly_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="hourlyCost")
    hourly_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="hourlyPrice")
    source_image: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = Field(default=None, alias="sourceImage")
    server_os: Optional[ListHosts200ResponseAllOfServersInnerServerOs] = Field(default=None, alias="serverOs")
    volumes: Optional[List[ListClusterVolumes200ResponseAllOfVolumesInner]] = None
    controllers: Optional[List[ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResourceControllersInner]] = None
    interfaces: Optional[List[ListHosts200ResponseAllOfServersInnerInterfacesInner]] = None
    labels: Optional[List[Dict[str, Any]]] = None
    tags: Optional[List[Dict[str, Any]]] = None
    enabled: Optional[StrictBool] = None
    tag_compliant: Optional[StrictStr] = Field(default=None, alias="tagCompliant")
    containers: Optional[List[StrictInt]] = None
    config: Optional[ListHosts200ResponseAllOfServersInnerConfig] = None
    instance: Optional[ListHosts200ResponseAllOfServersInnerInstance] = None
    guest_console_preferred: Optional[StrictBool] = Field(default=None, alias="guestConsolePreferred")
    guest_console_type: Optional[StrictStr] = Field(default=None, alias="guestConsoleType")
    guest_console_username: Optional[StrictStr] = Field(default=None, alias="guestConsoleUsername")
    guest_console_password: Optional[StrictStr] = Field(default=None, alias="guestConsolePassword")
    guest_console_password_hash: Optional[StrictStr] = Field(default=None, alias="guestConsolePasswordHash")
    guest_console_port: Optional[StrictStr] = Field(default=None, alias="guestConsolePort")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "uuid", "externalId", "internalId", "externalUniqueId", "name", "externalName", "hostname", "parentServer", "accountId", "account", "owner", "zone", "plan", "computeServerType", "visibility", "description", "zoneId", "siteId", "resourcePoolId", "folderId", "sshHost", "sshPort", "externalIp", "internalIp", "volumeId", "platform", "platformVersion", "sshUsername", "sshPassword", "sshPasswordHash", "sshKeyPair", "osDevice", "osType", "dataDevice", "lvmEnabled", "apiKey", "softwareRaid", "dateCreated", "lastUpdated", "stats", "status", "statusMessage", "errorMessage", "statusDate", "statusPercent", "statusEta", "powerState", "agentInstalled", "lastAgentUpdate", "agentVersion", "maxCores", "coresPerSocket", "maxMemory", "maxStorage", "maxCpu", "maxGpus", "manageInternalFirewall", "enableLogs", "hourlyCost", "hourlyPrice", "sourceImage", "serverOs", "volumes", "controllers", "interfaces", "labels", "tags", "enabled", "tagCompliant", "containers", "config", "instance", "guestConsolePreferred", "guestConsoleType", "guestConsoleUsername", "guestConsolePassword", "guestConsolePasswordHash", "guestConsolePort"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListHosts200ResponseAllOfServersInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of parent_server
        if self.parent_server:
            _dict['parentServer'] = self.parent_server.to_dict()
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of zone
        if self.zone:
            _dict['zone'] = self.zone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of plan
        if self.plan:
            _dict['plan'] = self.plan.to_dict()
        # override the default output from pydantic by calling `to_dict()` of compute_server_type
        if self.compute_server_type:
            _dict['computeServerType'] = self.compute_server_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ssh_key_pair
        if self.ssh_key_pair:
            _dict['sshKeyPair'] = self.ssh_key_pair.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stats
        if self.stats:
            _dict['stats'] = self.stats.to_dict()
        # override the default output from pydantic by calling `to_dict()` of source_image
        if self.source_image:
            _dict['sourceImage'] = self.source_image.to_dict()
        # override the default output from pydantic by calling `to_dict()` of server_os
        if self.server_os:
            _dict['serverOs'] = self.server_os.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in volumes (list)
        _items = []
        if self.volumes:
            for _item_volumes in self.volumes:
                if _item_volumes:
                    _items.append(_item_volumes.to_dict())
            _dict['volumes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in controllers (list)
        _items = []
        if self.controllers:
            for _item_controllers in self.controllers:
                if _item_controllers:
                    _items.append(_item_controllers.to_dict())
            _dict['controllers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in interfaces (list)
        _items = []
        if self.interfaces:
            for _item_interfaces in self.interfaces:
                if _item_interfaces:
                    _items.append(_item_interfaces.to_dict())
            _dict['interfaces'] = _items
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of instance
        if self.instance:
            _dict['instance'] = self.instance.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_id is None and "internal_id" in self.model_fields_set:
            _dict['internalId'] = None

        # set to None if external_unique_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_unique_id is None and "external_unique_id" in self.model_fields_set:
            _dict['externalUniqueId'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if resource_pool_id (nullable) is None
        # and model_fields_set contains the field
        if self.resource_pool_id is None and "resource_pool_id" in self.model_fields_set:
            _dict['resourcePoolId'] = None

        # set to None if folder_id (nullable) is None
        # and model_fields_set contains the field
        if self.folder_id is None and "folder_id" in self.model_fields_set:
            _dict['folderId'] = None

        # set to None if ssh_host (nullable) is None
        # and model_fields_set contains the field
        if self.ssh_host is None and "ssh_host" in self.model_fields_set:
            _dict['sshHost'] = None

        # set to None if external_ip (nullable) is None
        # and model_fields_set contains the field
        if self.external_ip is None and "external_ip" in self.model_fields_set:
            _dict['externalIp'] = None

        # set to None if internal_ip (nullable) is None
        # and model_fields_set contains the field
        if self.internal_ip is None and "internal_ip" in self.model_fields_set:
            _dict['internalIp'] = None

        # set to None if volume_id (nullable) is None
        # and model_fields_set contains the field
        if self.volume_id is None and "volume_id" in self.model_fields_set:
            _dict['volumeId'] = None

        # set to None if platform (nullable) is None
        # and model_fields_set contains the field
        if self.platform is None and "platform" in self.model_fields_set:
            _dict['platform'] = None

        # set to None if platform_version (nullable) is None
        # and model_fields_set contains the field
        if self.platform_version is None and "platform_version" in self.model_fields_set:
            _dict['platformVersion'] = None

        # set to None if ssh_username (nullable) is None
        # and model_fields_set contains the field
        if self.ssh_username is None and "ssh_username" in self.model_fields_set:
            _dict['sshUsername'] = None

        # set to None if ssh_password (nullable) is None
        # and model_fields_set contains the field
        if self.ssh_password is None and "ssh_password" in self.model_fields_set:
            _dict['sshPassword'] = None

        # set to None if ssh_password_hash (nullable) is None
        # and model_fields_set contains the field
        if self.ssh_password_hash is None and "ssh_password_hash" in self.model_fields_set:
            _dict['sshPasswordHash'] = None

        # set to None if status_message (nullable) is None
        # and model_fields_set contains the field
        if self.status_message is None and "status_message" in self.model_fields_set:
            _dict['statusMessage'] = None

        # set to None if error_message (nullable) is None
        # and model_fields_set contains the field
        if self.error_message is None and "error_message" in self.model_fields_set:
            _dict['errorMessage'] = None

        # set to None if status_date (nullable) is None
        # and model_fields_set contains the field
        if self.status_date is None and "status_date" in self.model_fields_set:
            _dict['statusDate'] = None

        # set to None if status_percent (nullable) is None
        # and model_fields_set contains the field
        if self.status_percent is None and "status_percent" in self.model_fields_set:
            _dict['statusPercent'] = None

        # set to None if status_eta (nullable) is None
        # and model_fields_set contains the field
        if self.status_eta is None and "status_eta" in self.model_fields_set:
            _dict['statusEta'] = None

        # set to None if last_agent_update (nullable) is None
        # and model_fields_set contains the field
        if self.last_agent_update is None and "last_agent_update" in self.model_fields_set:
            _dict['lastAgentUpdate'] = None

        # set to None if agent_version (nullable) is None
        # and model_fields_set contains the field
        if self.agent_version is None and "agent_version" in self.model_fields_set:
            _dict['agentVersion'] = None

        # set to None if cores_per_socket (nullable) is None
        # and model_fields_set contains the field
        if self.cores_per_socket is None and "cores_per_socket" in self.model_fields_set:
            _dict['coresPerSocket'] = None

        # set to None if max_cpu (nullable) is None
        # and model_fields_set contains the field
        if self.max_cpu is None and "max_cpu" in self.model_fields_set:
            _dict['maxCpu'] = None

        # set to None if max_gpus (nullable) is None
        # and model_fields_set contains the field
        if self.max_gpus is None and "max_gpus" in self.model_fields_set:
            _dict['maxGpus'] = None

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['tags'] = None

        # set to None if tag_compliant (nullable) is None
        # and model_fields_set contains the field
        if self.tag_compliant is None and "tag_compliant" in self.model_fields_set:
            _dict['tagCompliant'] = None

        # set to None if guest_console_type (nullable) is None
        # and model_fields_set contains the field
        if self.guest_console_type is None and "guest_console_type" in self.model_fields_set:
            _dict['guestConsoleType'] = None

        # set to None if guest_console_username (nullable) is None
        # and model_fields_set contains the field
        if self.guest_console_username is None and "guest_console_username" in self.model_fields_set:
            _dict['guestConsoleUsername'] = None

        # set to None if guest_console_password (nullable) is None
        # and model_fields_set contains the field
        if self.guest_console_password is None and "guest_console_password" in self.model_fields_set:
            _dict['guestConsolePassword'] = None

        # set to None if guest_console_password_hash (nullable) is None
        # and model_fields_set contains the field
        if self.guest_console_password_hash is None and "guest_console_password_hash" in self.model_fields_set:
            _dict['guestConsolePasswordHash'] = None

        # set to None if guest_console_port (nullable) is None
        # and model_fields_set contains the field
        if self.guest_console_port is None and "guest_console_port" in self.model_fields_set:
            _dict['guestConsolePort'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListHosts200ResponseAllOfServersInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "uuid": obj.get("uuid"),
            "externalId": obj.get("externalId"),
            "internalId": obj.get("internalId"),
            "externalUniqueId": obj.get("externalUniqueId"),
            "name": obj.get("name"),
            "externalName": obj.get("externalName"),
            "hostname": obj.get("hostname"),
            "parentServer": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["parentServer"]) if obj.get("parentServer") is not None else None,
            "accountId": obj.get("accountId"),
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "owner": ListActivity200ResponseAllOfActivityInnerActivityInnerUser.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "zone": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["zone"]) if obj.get("zone") is not None else None,
            "plan": ListHosts200ResponseAllOfServersInnerPlan.from_dict(obj["plan"]) if obj.get("plan") is not None else None,
            "computeServerType": ListClusterLayouts200ResponseAllOfLayoutsInnerComputeServersInnerComputeServerType.from_dict(obj["computeServerType"]) if obj.get("computeServerType") is not None else None,
            "visibility": obj.get("visibility"),
            "description": obj.get("description"),
            "zoneId": obj.get("zoneId"),
            "siteId": obj.get("siteId"),
            "resourcePoolId": obj.get("resourcePoolId"),
            "folderId": obj.get("folderId"),
            "sshHost": obj.get("sshHost"),
            "sshPort": obj.get("sshPort"),
            "externalIp": obj.get("externalIp"),
            "internalIp": obj.get("internalIp"),
            "volumeId": obj.get("volumeId"),
            "platform": obj.get("platform"),
            "platformVersion": obj.get("platformVersion"),
            "sshUsername": obj.get("sshUsername"),
            "sshPassword": obj.get("sshPassword"),
            "sshPasswordHash": obj.get("sshPasswordHash"),
            "sshKeyPair": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["sshKeyPair"]) if obj.get("sshKeyPair") is not None else None,
            "osDevice": obj.get("osDevice"),
            "osType": obj.get("osType"),
            "dataDevice": obj.get("dataDevice"),
            "lvmEnabled": obj.get("lvmEnabled"),
            "apiKey": obj.get("apiKey"),
            "softwareRaid": obj.get("softwareRaid"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "stats": ListHosts200ResponseAllOfServersInnerStats.from_dict(obj["stats"]) if obj.get("stats") is not None else None,
            "status": obj.get("status"),
            "statusMessage": obj.get("statusMessage"),
            "errorMessage": obj.get("errorMessage"),
            "statusDate": obj.get("statusDate"),
            "statusPercent": obj.get("statusPercent"),
            "statusEta": obj.get("statusEta"),
            "powerState": obj.get("powerState"),
            "agentInstalled": obj.get("agentInstalled"),
            "lastAgentUpdate": obj.get("lastAgentUpdate"),
            "agentVersion": obj.get("agentVersion"),
            "maxCores": obj.get("maxCores"),
            "coresPerSocket": obj.get("coresPerSocket"),
            "maxMemory": obj.get("maxMemory"),
            "maxStorage": obj.get("maxStorage"),
            "maxCpu": obj.get("maxCpu"),
            "maxGpus": obj.get("maxGpus"),
            "manageInternalFirewall": obj.get("manageInternalFirewall"),
            "enableLogs": obj.get("enableLogs"),
            "hourlyCost": obj.get("hourlyCost"),
            "hourlyPrice": obj.get("hourlyPrice"),
            "sourceImage": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["sourceImage"]) if obj.get("sourceImage") is not None else None,
            "serverOs": ListHosts200ResponseAllOfServersInnerServerOs.from_dict(obj["serverOs"]) if obj.get("serverOs") is not None else None,
            "volumes": [ListClusterVolumes200ResponseAllOfVolumesInner.from_dict(_item) for _item in obj["volumes"]] if obj.get("volumes") is not None else None,
            "controllers": [ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResourceControllersInner.from_dict(_item) for _item in obj["controllers"]] if obj.get("controllers") is not None else None,
            "interfaces": [ListHosts200ResponseAllOfServersInnerInterfacesInner.from_dict(_item) for _item in obj["interfaces"]] if obj.get("interfaces") is not None else None,
            "labels": obj.get("labels"),
            "tags": obj.get("tags"),
            "enabled": obj.get("enabled"),
            "tagCompliant": obj.get("tagCompliant"),
            "containers": obj.get("containers"),
            "config": ListHosts200ResponseAllOfServersInnerConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "instance": ListHosts200ResponseAllOfServersInnerInstance.from_dict(obj["instance"]) if obj.get("instance") is not None else None,
            "guestConsolePreferred": obj.get("guestConsolePreferred"),
            "guestConsoleType": obj.get("guestConsoleType"),
            "guestConsoleUsername": obj.get("guestConsoleUsername"),
            "guestConsolePassword": obj.get("guestConsolePassword"),
            "guestConsolePasswordHash": obj.get("guestConsolePasswordHash"),
            "guestConsolePort": obj.get("guestConsolePort")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


