# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_instance_service_plans200_response_plans_inner_auto_options_inner import ListInstanceServicePlans200ResponsePlansInnerAutoOptionsInner
from morpheus.models.list_instance_service_plans200_response_plans_inner_datastores import ListInstanceServicePlans200ResponsePlansInnerDatastores
from morpheus.models.list_instance_service_plans200_response_plans_inner_storage_types_inner import ListInstanceServicePlans200ResponsePlansInnerStorageTypesInner
from typing import Optional, Set
from typing_extensions import Self

class ListInstanceServicePlans200ResponsePlansInner(BaseModel):
    """
    ListInstanceServicePlans200ResponsePlansInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    value: Optional[StrictInt] = None
    code: Optional[StrictStr] = None
    max_storage: Optional[StrictInt] = Field(default=None, alias="maxStorage")
    max_memory: Optional[StrictInt] = Field(default=None, alias="maxMemory")
    max_cpu: Optional[StrictInt] = Field(default=None, alias="maxCpu")
    max_cores: Optional[StrictInt] = Field(default=None, alias="maxCores")
    custom_cpu: Optional[StrictBool] = Field(default=None, alias="customCpu")
    custom_max_memory: Optional[StrictBool] = Field(default=None, alias="customMaxMemory")
    custom_max_storage: Optional[StrictBool] = Field(default=None, alias="customMaxStorage")
    custom_max_data_storage: Optional[StrictBool] = Field(default=None, alias="customMaxDataStorage")
    custom_cores_per_socket: Optional[StrictBool] = Field(default=None, alias="customCoresPerSocket")
    cores_per_socket: Optional[StrictInt] = Field(default=None, alias="coresPerSocket")
    storage_types: Optional[List[ListInstanceServicePlans200ResponsePlansInnerStorageTypesInner]] = Field(default=None, alias="storageTypes")
    root_storage_types: Optional[List[ListInstanceServicePlans200ResponsePlansInnerStorageTypesInner]] = Field(default=None, alias="rootStorageTypes")
    add_volumes: Optional[StrictBool] = Field(default=None, alias="addVolumes")
    customize_volume: Optional[StrictBool] = Field(default=None, alias="customizeVolume")
    root_disk_customizable: Optional[StrictBool] = Field(default=None, alias="rootDiskCustomizable")
    no_disks: Optional[StrictBool] = Field(default=None, alias="noDisks")
    has_datastore: Optional[StrictBool] = Field(default=None, alias="hasDatastore")
    min_disk: Optional[StrictInt] = Field(default=None, alias="minDisk")
    max_disk: Optional[StrictStr] = Field(default=None, alias="maxDisk")
    lvm_supported: Optional[StrictBool] = Field(default=None, alias="lvmSupported")
    datastores: Optional[ListInstanceServicePlans200ResponsePlansInnerDatastores] = None
    supports_auto_datastore: Optional[StrictBool] = Field(default=None, alias="supportsAutoDatastore")
    auto_options: Optional[List[ListInstanceServicePlans200ResponsePlansInnerAutoOptionsInner]] = Field(default=None, alias="autoOptions")
    cpu_options: Optional[List[Dict[str, Any]]] = Field(default=None, alias="cpuOptions")
    core_options: Optional[List[Dict[str, Any]]] = Field(default=None, alias="coreOptions")
    memory_options: Optional[List[Dict[str, Any]]] = Field(default=None, alias="memoryOptions")
    root_custom_size_options: Optional[Dict[str, Any]] = Field(default=None, alias="rootCustomSizeOptions")
    custom_size_options: Optional[Dict[str, Any]] = Field(default=None, alias="customSizeOptions")
    custom_cores: Optional[StrictBool] = Field(default=None, alias="customCores")
    max_disks: Optional[StrictStr] = Field(default=None, alias="maxDisks")
    memory_size_type: Optional[StrictStr] = Field(default=None, alias="memorySizeType")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "value", "code", "maxStorage", "maxMemory", "maxCpu", "maxCores", "customCpu", "customMaxMemory", "customMaxStorage", "customMaxDataStorage", "customCoresPerSocket", "coresPerSocket", "storageTypes", "rootStorageTypes", "addVolumes", "customizeVolume", "rootDiskCustomizable", "noDisks", "hasDatastore", "minDisk", "maxDisk", "lvmSupported", "datastores", "supportsAutoDatastore", "autoOptions", "cpuOptions", "coreOptions", "memoryOptions", "rootCustomSizeOptions", "customSizeOptions", "customCores", "maxDisks", "memorySizeType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListInstanceServicePlans200ResponsePlansInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in storage_types (list)
        _items = []
        if self.storage_types:
            for _item_storage_types in self.storage_types:
                if _item_storage_types:
                    _items.append(_item_storage_types.to_dict())
            _dict['storageTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in root_storage_types (list)
        _items = []
        if self.root_storage_types:
            for _item_root_storage_types in self.root_storage_types:
                if _item_root_storage_types:
                    _items.append(_item_root_storage_types.to_dict())
            _dict['rootStorageTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of datastores
        if self.datastores:
            _dict['datastores'] = self.datastores.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in auto_options (list)
        _items = []
        if self.auto_options:
            for _item_auto_options in self.auto_options:
                if _item_auto_options:
                    _items.append(_item_auto_options.to_dict())
            _dict['autoOptions'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if max_disk (nullable) is None
        # and model_fields_set contains the field
        if self.max_disk is None and "max_disk" in self.model_fields_set:
            _dict['maxDisk'] = None

        # set to None if cpu_options (nullable) is None
        # and model_fields_set contains the field
        if self.cpu_options is None and "cpu_options" in self.model_fields_set:
            _dict['cpuOptions'] = None

        # set to None if core_options (nullable) is None
        # and model_fields_set contains the field
        if self.core_options is None and "core_options" in self.model_fields_set:
            _dict['coreOptions'] = None

        # set to None if memory_options (nullable) is None
        # and model_fields_set contains the field
        if self.memory_options is None and "memory_options" in self.model_fields_set:
            _dict['memoryOptions'] = None

        # set to None if root_custom_size_options (nullable) is None
        # and model_fields_set contains the field
        if self.root_custom_size_options is None and "root_custom_size_options" in self.model_fields_set:
            _dict['rootCustomSizeOptions'] = None

        # set to None if custom_size_options (nullable) is None
        # and model_fields_set contains the field
        if self.custom_size_options is None and "custom_size_options" in self.model_fields_set:
            _dict['customSizeOptions'] = None

        # set to None if max_disks (nullable) is None
        # and model_fields_set contains the field
        if self.max_disks is None and "max_disks" in self.model_fields_set:
            _dict['maxDisks'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListInstanceServicePlans200ResponsePlansInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "value": obj.get("value"),
            "code": obj.get("code"),
            "maxStorage": obj.get("maxStorage"),
            "maxMemory": obj.get("maxMemory"),
            "maxCpu": obj.get("maxCpu"),
            "maxCores": obj.get("maxCores"),
            "customCpu": obj.get("customCpu"),
            "customMaxMemory": obj.get("customMaxMemory"),
            "customMaxStorage": obj.get("customMaxStorage"),
            "customMaxDataStorage": obj.get("customMaxDataStorage"),
            "customCoresPerSocket": obj.get("customCoresPerSocket"),
            "coresPerSocket": obj.get("coresPerSocket"),
            "storageTypes": [ListInstanceServicePlans200ResponsePlansInnerStorageTypesInner.from_dict(_item) for _item in obj["storageTypes"]] if obj.get("storageTypes") is not None else None,
            "rootStorageTypes": [ListInstanceServicePlans200ResponsePlansInnerStorageTypesInner.from_dict(_item) for _item in obj["rootStorageTypes"]] if obj.get("rootStorageTypes") is not None else None,
            "addVolumes": obj.get("addVolumes"),
            "customizeVolume": obj.get("customizeVolume"),
            "rootDiskCustomizable": obj.get("rootDiskCustomizable"),
            "noDisks": obj.get("noDisks"),
            "hasDatastore": obj.get("hasDatastore"),
            "minDisk": obj.get("minDisk"),
            "maxDisk": obj.get("maxDisk"),
            "lvmSupported": obj.get("lvmSupported"),
            "datastores": ListInstanceServicePlans200ResponsePlansInnerDatastores.from_dict(obj["datastores"]) if obj.get("datastores") is not None else None,
            "supportsAutoDatastore": obj.get("supportsAutoDatastore"),
            "autoOptions": [ListInstanceServicePlans200ResponsePlansInnerAutoOptionsInner.from_dict(_item) for _item in obj["autoOptions"]] if obj.get("autoOptions") is not None else None,
            "cpuOptions": obj.get("cpuOptions"),
            "coreOptions": obj.get("coreOptions"),
            "memoryOptions": obj.get("memoryOptions"),
            "rootCustomSizeOptions": obj.get("rootCustomSizeOptions"),
            "customSizeOptions": obj.get("customSizeOptions"),
            "customCores": obj.get("customCores"),
            "maxDisks": obj.get("maxDisks"),
            "memorySizeType": obj.get("memorySizeType")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


