# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ListInstanceServicePlans200ResponsePlansInnerStorageTypesInner(BaseModel):
    """
    ListInstanceServicePlans200ResponsePlansInnerStorageTypesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    editable: Optional[StrictBool] = None
    option_types: Optional[List[Dict[str, Any]]] = Field(default=None, alias="optionTypes")
    display_order: Optional[StrictInt] = Field(default=None, alias="displayOrder")
    code: Optional[StrictStr] = None
    volume_type: Optional[StrictStr] = Field(default=None, alias="volumeType")
    min_storage: Optional[StrictStr] = Field(default=None, alias="minStorage")
    deletable: Optional[StrictBool] = None
    default_type: Optional[StrictBool] = Field(default=None, alias="defaultType")
    create_datastore: Optional[StrictStr] = Field(default=None, alias="createDatastore")
    resizable: Optional[StrictBool] = None
    storage_type: Optional[StrictStr] = Field(default=None, alias="storageType")
    allow_search: Optional[StrictBool] = Field(default=None, alias="allowSearch")
    volume_option_source: Optional[StrictStr] = Field(default=None, alias="volumeOptionSource")
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    min_iops: Optional[StrictStr] = Field(default=None, alias="minIOPS")
    max_iops: Optional[StrictStr] = Field(default=None, alias="maxIOPS")
    has_datastore: Optional[StrictBool] = Field(default=None, alias="hasDatastore")
    custom_size: Optional[StrictBool] = Field(default=None, alias="customSize")
    auto_delete: Optional[StrictBool] = Field(default=None, alias="autoDelete")
    name: Optional[StrictStr] = None
    configurable_iops: Optional[StrictBool] = Field(default=None, alias="configurableIOPS")
    custom_label: Optional[StrictBool] = Field(default=None, alias="customLabel")
    enabled: Optional[StrictBool] = None
    description: Optional[StrictStr] = None
    volume_category: Optional[StrictStr] = Field(default=None, alias="volumeCategory")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    max_storage: Optional[StrictStr] = Field(default=None, alias="maxStorage")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "editable", "optionTypes", "displayOrder", "code", "volumeType", "minStorage", "deletable", "defaultType", "createDatastore", "resizable", "storageType", "allowSearch", "volumeOptionSource", "displayName", "minIOPS", "maxIOPS", "hasDatastore", "customSize", "autoDelete", "name", "configurableIOPS", "customLabel", "enabled", "description", "volumeCategory", "externalId", "maxStorage"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListInstanceServicePlans200ResponsePlansInnerStorageTypesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if option_types (nullable) is None
        # and model_fields_set contains the field
        if self.option_types is None and "option_types" in self.model_fields_set:
            _dict['optionTypes'] = None

        # set to None if min_storage (nullable) is None
        # and model_fields_set contains the field
        if self.min_storage is None and "min_storage" in self.model_fields_set:
            _dict['minStorage'] = None

        # set to None if create_datastore (nullable) is None
        # and model_fields_set contains the field
        if self.create_datastore is None and "create_datastore" in self.model_fields_set:
            _dict['createDatastore'] = None

        # set to None if storage_type (nullable) is None
        # and model_fields_set contains the field
        if self.storage_type is None and "storage_type" in self.model_fields_set:
            _dict['storageType'] = None

        # set to None if volume_option_source (nullable) is None
        # and model_fields_set contains the field
        if self.volume_option_source is None and "volume_option_source" in self.model_fields_set:
            _dict['volumeOptionSource'] = None

        # set to None if min_iops (nullable) is None
        # and model_fields_set contains the field
        if self.min_iops is None and "min_iops" in self.model_fields_set:
            _dict['minIOPS'] = None

        # set to None if max_iops (nullable) is None
        # and model_fields_set contains the field
        if self.max_iops is None and "max_iops" in self.model_fields_set:
            _dict['maxIOPS'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if max_storage (nullable) is None
        # and model_fields_set contains the field
        if self.max_storage is None and "max_storage" in self.model_fields_set:
            _dict['maxStorage'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListInstanceServicePlans200ResponsePlansInnerStorageTypesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "editable": obj.get("editable"),
            "optionTypes": obj.get("optionTypes"),
            "displayOrder": obj.get("displayOrder"),
            "code": obj.get("code"),
            "volumeType": obj.get("volumeType"),
            "minStorage": obj.get("minStorage"),
            "deletable": obj.get("deletable"),
            "defaultType": obj.get("defaultType"),
            "createDatastore": obj.get("createDatastore"),
            "resizable": obj.get("resizable"),
            "storageType": obj.get("storageType"),
            "allowSearch": obj.get("allowSearch"),
            "volumeOptionSource": obj.get("volumeOptionSource"),
            "displayName": obj.get("displayName"),
            "minIOPS": obj.get("minIOPS"),
            "maxIOPS": obj.get("maxIOPS"),
            "hasDatastore": obj.get("hasDatastore"),
            "customSize": obj.get("customSize"),
            "autoDelete": obj.get("autoDelete"),
            "name": obj.get("name"),
            "configurableIOPS": obj.get("configurableIOPS"),
            "customLabel": obj.get("customLabel"),
            "enabled": obj.get("enabled"),
            "description": obj.get("description"),
            "volumeCategory": obj.get("volumeCategory"),
            "externalId": obj.get("externalId"),
            "maxStorage": obj.get("maxStorage")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


