# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_load_balancer_monitors200_response_all_of_load_balancer_monitors_inner_load_balancer import ListLoadBalancerMonitors200ResponseAllOfLoadBalancerMonitorsInnerLoadBalancer
from typing import Optional, Set
from typing_extensions import Self

class ListLoadBalancerProfiles200ResponseAllOfLoadBalancerProfilesInner(BaseModel):
    """
    ListLoadBalancerProfiles200ResponseAllOfLoadBalancerProfilesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    load_balancer: Optional[ListLoadBalancerMonitors200ResponseAllOfLoadBalancerMonitorsInnerLoadBalancer] = Field(default=None, alias="loadBalancer")
    name: Optional[StrictStr] = None
    category: Optional[StrictStr] = None
    service_type: Optional[StrictStr] = Field(default=None, alias="serviceType")
    service_type_display: Optional[StrictStr] = Field(default=None, alias="serviceTypeDisplay")
    visibility: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    proxy_type: Optional[StrictStr] = Field(default=None, alias="proxyType")
    redirect_rewrite: Optional[StrictStr] = Field(default=None, alias="redirectRewrite")
    persistence_type: Optional[StrictStr] = Field(default=None, alias="persistenceType")
    ssl_enabled: Optional[StrictStr] = Field(default=None, alias="sslEnabled")
    ssl_cert: Optional[StrictStr] = Field(default=None, alias="sslCert")
    account_certificate: Optional[StrictStr] = Field(default=None, alias="accountCertificate")
    enabled: Optional[StrictBool] = None
    redirect_url: Optional[StrictStr] = Field(default=None, alias="redirectUrl")
    insert_xforwarded_for: Optional[StrictBool] = Field(default=None, alias="insertXforwardedFor")
    persistence_cookie_name: Optional[StrictStr] = Field(default=None, alias="persistenceCookieName")
    persistence_expires_in: Optional[StrictStr] = Field(default=None, alias="persistenceExpiresIn")
    editable: Optional[StrictBool] = None
    config: Optional[Dict[str, Any]] = None
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "loadBalancer", "name", "category", "serviceType", "serviceTypeDisplay", "visibility", "description", "internalId", "externalId", "proxyType", "redirectRewrite", "persistenceType", "sslEnabled", "sslCert", "accountCertificate", "enabled", "redirectUrl", "insertXforwardedFor", "persistenceCookieName", "persistenceExpiresIn", "editable", "config", "createdBy", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListLoadBalancerProfiles200ResponseAllOfLoadBalancerProfilesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of load_balancer
        if self.load_balancer:
            _dict['loadBalancer'] = self.load_balancer.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if proxy_type (nullable) is None
        # and model_fields_set contains the field
        if self.proxy_type is None and "proxy_type" in self.model_fields_set:
            _dict['proxyType'] = None

        # set to None if redirect_rewrite (nullable) is None
        # and model_fields_set contains the field
        if self.redirect_rewrite is None and "redirect_rewrite" in self.model_fields_set:
            _dict['redirectRewrite'] = None

        # set to None if persistence_type (nullable) is None
        # and model_fields_set contains the field
        if self.persistence_type is None and "persistence_type" in self.model_fields_set:
            _dict['persistenceType'] = None

        # set to None if ssl_enabled (nullable) is None
        # and model_fields_set contains the field
        if self.ssl_enabled is None and "ssl_enabled" in self.model_fields_set:
            _dict['sslEnabled'] = None

        # set to None if ssl_cert (nullable) is None
        # and model_fields_set contains the field
        if self.ssl_cert is None and "ssl_cert" in self.model_fields_set:
            _dict['sslCert'] = None

        # set to None if account_certificate (nullable) is None
        # and model_fields_set contains the field
        if self.account_certificate is None and "account_certificate" in self.model_fields_set:
            _dict['accountCertificate'] = None

        # set to None if redirect_url (nullable) is None
        # and model_fields_set contains the field
        if self.redirect_url is None and "redirect_url" in self.model_fields_set:
            _dict['redirectUrl'] = None

        # set to None if persistence_cookie_name (nullable) is None
        # and model_fields_set contains the field
        if self.persistence_cookie_name is None and "persistence_cookie_name" in self.model_fields_set:
            _dict['persistenceCookieName'] = None

        # set to None if persistence_expires_in (nullable) is None
        # and model_fields_set contains the field
        if self.persistence_expires_in is None and "persistence_expires_in" in self.model_fields_set:
            _dict['persistenceExpiresIn'] = None

        # set to None if created_by (nullable) is None
        # and model_fields_set contains the field
        if self.created_by is None and "created_by" in self.model_fields_set:
            _dict['createdBy'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListLoadBalancerProfiles200ResponseAllOfLoadBalancerProfilesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "loadBalancer": ListLoadBalancerMonitors200ResponseAllOfLoadBalancerMonitorsInnerLoadBalancer.from_dict(obj["loadBalancer"]) if obj.get("loadBalancer") is not None else None,
            "name": obj.get("name"),
            "category": obj.get("category"),
            "serviceType": obj.get("serviceType"),
            "serviceTypeDisplay": obj.get("serviceTypeDisplay"),
            "visibility": obj.get("visibility"),
            "description": obj.get("description"),
            "internalId": obj.get("internalId"),
            "externalId": obj.get("externalId"),
            "proxyType": obj.get("proxyType"),
            "redirectRewrite": obj.get("redirectRewrite"),
            "persistenceType": obj.get("persistenceType"),
            "sslEnabled": obj.get("sslEnabled"),
            "sslCert": obj.get("sslCert"),
            "accountCertificate": obj.get("accountCertificate"),
            "enabled": obj.get("enabled"),
            "redirectUrl": obj.get("redirectUrl"),
            "insertXforwardedFor": obj.get("insertXforwardedFor"),
            "persistenceCookieName": obj.get("persistenceCookieName"),
            "persistenceExpiresIn": obj.get("persistenceExpiresIn"),
            "editable": obj.get("editable"),
            "config": obj.get("config"),
            "createdBy": obj.get("createdBy"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


