# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from morpheus.models.list_cloud_datastores200_response_all_of_datastores_inner_resource_permission import ListCloudDatastores200ResponseAllOfDatastoresInnerResourcePermission
from morpheus.models.list_integrations200_response_any_of_integrations_inner_any_of_credential import ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOfCredential
from typing import Optional, Set
from typing_extensions import Self

class ListLoadBalancers200ResponseAllOfLoadBalancersInner(BaseModel):
    """
    ListLoadBalancers200ResponseAllOfLoadBalancersInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    uuid: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    account_id: Optional[StrictInt] = Field(default=None, alias="accountId")
    cloud: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = None
    owner: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    visibility: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    host: Optional[StrictStr] = None
    port: Optional[StrictInt] = None
    username: Optional[StrictStr] = None
    ip: Optional[StrictStr] = None
    internal_ip: Optional[StrictStr] = Field(default=None, alias="internalIp")
    external_ip: Optional[StrictStr] = Field(default=None, alias="externalIp")
    api_port: Optional[StrictStr] = Field(default=None, alias="apiPort")
    admin_port: Optional[StrictStr] = Field(default=None, alias="adminPort")
    ssl_enabled: Optional[StrictBool] = Field(default=None, alias="sslEnabled")
    ssl_cert: Optional[StrictStr] = Field(default=None, alias="sslCert")
    config: Optional[Dict[str, Any]] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    credential: Optional[ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOfCredential] = None
    tenants: Optional[List[GetAlerts200ResponseAllOfCheckGroupsInnerInstance]] = None
    resource_permission: Optional[ListCloudDatastores200ResponseAllOfDatastoresInnerResourcePermission] = Field(default=None, alias="resourcePermission")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "uuid", "name", "accountId", "cloud", "type", "owner", "visibility", "description", "host", "port", "username", "ip", "internalIp", "externalIp", "apiPort", "adminPort", "sslEnabled", "sslCert", "config", "dateCreated", "lastUpdated", "credential", "tenants", "resourcePermission"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListLoadBalancers200ResponseAllOfLoadBalancersInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cloud
        if self.cloud:
            _dict['cloud'] = self.cloud.to_dict()
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of credential
        if self.credential:
            _dict['credential'] = self.credential.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tenants (list)
        _items = []
        if self.tenants:
            for _item_tenants in self.tenants:
                if _item_tenants:
                    _items.append(_item_tenants.to_dict())
            _dict['tenants'] = _items
        # override the default output from pydantic by calling `to_dict()` of resource_permission
        if self.resource_permission:
            _dict['resourcePermission'] = self.resource_permission.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if username (nullable) is None
        # and model_fields_set contains the field
        if self.username is None and "username" in self.model_fields_set:
            _dict['username'] = None

        # set to None if internal_ip (nullable) is None
        # and model_fields_set contains the field
        if self.internal_ip is None and "internal_ip" in self.model_fields_set:
            _dict['internalIp'] = None

        # set to None if external_ip (nullable) is None
        # and model_fields_set contains the field
        if self.external_ip is None and "external_ip" in self.model_fields_set:
            _dict['externalIp'] = None

        # set to None if api_port (nullable) is None
        # and model_fields_set contains the field
        if self.api_port is None and "api_port" in self.model_fields_set:
            _dict['apiPort'] = None

        # set to None if admin_port (nullable) is None
        # and model_fields_set contains the field
        if self.admin_port is None and "admin_port" in self.model_fields_set:
            _dict['adminPort'] = None

        # set to None if ssl_enabled (nullable) is None
        # and model_fields_set contains the field
        if self.ssl_enabled is None and "ssl_enabled" in self.model_fields_set:
            _dict['sslEnabled'] = None

        # set to None if ssl_cert (nullable) is None
        # and model_fields_set contains the field
        if self.ssl_cert is None and "ssl_cert" in self.model_fields_set:
            _dict['sslCert'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListLoadBalancers200ResponseAllOfLoadBalancersInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "uuid": obj.get("uuid"),
            "name": obj.get("name"),
            "accountId": obj.get("accountId"),
            "cloud": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["cloud"]) if obj.get("cloud") is not None else None,
            "type": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "owner": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "visibility": obj.get("visibility"),
            "description": obj.get("description"),
            "host": obj.get("host"),
            "port": obj.get("port"),
            "username": obj.get("username"),
            "ip": obj.get("ip"),
            "internalIp": obj.get("internalIp"),
            "externalIp": obj.get("externalIp"),
            "apiPort": obj.get("apiPort"),
            "adminPort": obj.get("adminPort"),
            "sslEnabled": obj.get("sslEnabled"),
            "sslCert": obj.get("sslCert"),
            "config": obj.get("config"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "credential": ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOfCredential.from_dict(obj["credential"]) if obj.get("credential") is not None else None,
            "tenants": [GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(_item) for _item in obj["tenants"]] if obj.get("tenants") is not None else None,
            "resourcePermission": ListCloudDatastores200ResponseAllOfDatastoresInnerResourcePermission.from_dict(obj["resourcePermission"]) if obj.get("resourcePermission") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


