# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_network_pool_servers200_response_all_of_network_pool_servers_inner_credential import ListNetworkPoolServers200ResponseAllOfNetworkPoolServersInnerCredential
from morpheus.models.list_network_pool_servers200_response_all_of_network_pool_servers_inner_integration import ListNetworkPoolServers200ResponseAllOfNetworkPoolServersInnerIntegration
from morpheus.models.list_network_pool_servers200_response_all_of_network_pool_servers_inner_type import ListNetworkPoolServers200ResponseAllOfNetworkPoolServersInnerType
from morpheus.models.list_network_servers200_response_all_of_network_servers_inner_account import ListNetworkServers200ResponseAllOfNetworkServersInnerAccount
from typing import Optional, Set
from typing_extensions import Self

class ListNetworkPoolServers200ResponseAllOfNetworkPoolServersInner(BaseModel):
    """
    ListNetworkPoolServers200ResponseAllOfNetworkPoolServersInner
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="Network Pool Server ID")
    type: Optional[ListNetworkPoolServers200ResponseAllOfNetworkPoolServersInnerType] = None
    name: Optional[StrictStr] = Field(default=None, description="Name")
    enabled: Optional[StrictBool] = None
    service_url: Optional[StrictStr] = Field(default=None, description="Service URL", alias="serviceUrl")
    service_host: Optional[StrictStr] = Field(default=None, description="Service Host", alias="serviceHost")
    service_port: Optional[StrictInt] = Field(default=None, description="Service Port", alias="servicePort")
    service_mode: Optional[StrictStr] = Field(default=None, description="Service Mode", alias="serviceMode")
    service_username: Optional[StrictStr] = Field(default=None, description="Service Username", alias="serviceUsername")
    service_password: Optional[StrictStr] = Field(default=None, description="Service Password", alias="servicePassword")
    service_password_hash: Optional[StrictStr] = Field(default=None, alias="servicePasswordHash")
    service_throttle_rate: Optional[StrictInt] = Field(default=0, description="Throttle Rate", alias="serviceThrottleRate")
    ignore_ssl: Optional[StrictBool] = Field(default=True, description="Disable SSL SNI Verification", alias="ignoreSsl")
    status: Optional[StrictStr] = Field(default=None, description="Status")
    status_message: Optional[StrictStr] = Field(default=None, description="Status Message", alias="statusMessage")
    status_date: Optional[datetime] = Field(default=None, alias="statusDate")
    config: Optional[Dict[str, Any]] = Field(default=None, description="Config object varies with pool server type.")
    network_filter: Optional[StrictStr] = Field(default=None, description="Network Filter", alias="networkFilter")
    zone_filter: Optional[StrictStr] = Field(default=None, description="Zone Filter", alias="zoneFilter")
    tenant_match: Optional[StrictStr] = Field(default=None, description="Tenant Match", alias="tenantMatch")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    account: Optional[ListNetworkServers200ResponseAllOfNetworkServersInnerAccount] = None
    integration: Optional[ListNetworkPoolServers200ResponseAllOfNetworkPoolServersInnerIntegration] = None
    pools: Optional[List[GetAlerts200ResponseAllOfCheckGroupsInnerInstance]] = None
    credential: Optional[ListNetworkPoolServers200ResponseAllOfNetworkPoolServersInnerCredential] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "type", "name", "enabled", "serviceUrl", "serviceHost", "servicePort", "serviceMode", "serviceUsername", "servicePassword", "servicePasswordHash", "serviceThrottleRate", "ignoreSsl", "status", "statusMessage", "statusDate", "config", "networkFilter", "zoneFilter", "tenantMatch", "dateCreated", "lastUpdated", "account", "integration", "pools", "credential"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListNetworkPoolServers200ResponseAllOfNetworkPoolServersInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of integration
        if self.integration:
            _dict['integration'] = self.integration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in pools (list)
        _items = []
        if self.pools:
            for _item_pools in self.pools:
                if _item_pools:
                    _items.append(_item_pools.to_dict())
            _dict['pools'] = _items
        # override the default output from pydantic by calling `to_dict()` of credential
        if self.credential:
            _dict['credential'] = self.credential.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if service_url (nullable) is None
        # and model_fields_set contains the field
        if self.service_url is None and "service_url" in self.model_fields_set:
            _dict['serviceUrl'] = None

        # set to None if service_host (nullable) is None
        # and model_fields_set contains the field
        if self.service_host is None and "service_host" in self.model_fields_set:
            _dict['serviceHost'] = None

        # set to None if service_port (nullable) is None
        # and model_fields_set contains the field
        if self.service_port is None and "service_port" in self.model_fields_set:
            _dict['servicePort'] = None

        # set to None if service_mode (nullable) is None
        # and model_fields_set contains the field
        if self.service_mode is None and "service_mode" in self.model_fields_set:
            _dict['serviceMode'] = None

        # set to None if service_username (nullable) is None
        # and model_fields_set contains the field
        if self.service_username is None and "service_username" in self.model_fields_set:
            _dict['serviceUsername'] = None

        # set to None if service_password (nullable) is None
        # and model_fields_set contains the field
        if self.service_password is None and "service_password" in self.model_fields_set:
            _dict['servicePassword'] = None

        # set to None if service_throttle_rate (nullable) is None
        # and model_fields_set contains the field
        if self.service_throttle_rate is None and "service_throttle_rate" in self.model_fields_set:
            _dict['serviceThrottleRate'] = None

        # set to None if ignore_ssl (nullable) is None
        # and model_fields_set contains the field
        if self.ignore_ssl is None and "ignore_ssl" in self.model_fields_set:
            _dict['ignoreSsl'] = None

        # set to None if status_message (nullable) is None
        # and model_fields_set contains the field
        if self.status_message is None and "status_message" in self.model_fields_set:
            _dict['statusMessage'] = None

        # set to None if status_date (nullable) is None
        # and model_fields_set contains the field
        if self.status_date is None and "status_date" in self.model_fields_set:
            _dict['statusDate'] = None

        # set to None if network_filter (nullable) is None
        # and model_fields_set contains the field
        if self.network_filter is None and "network_filter" in self.model_fields_set:
            _dict['networkFilter'] = None

        # set to None if zone_filter (nullable) is None
        # and model_fields_set contains the field
        if self.zone_filter is None and "zone_filter" in self.model_fields_set:
            _dict['zoneFilter'] = None

        # set to None if tenant_match (nullable) is None
        # and model_fields_set contains the field
        if self.tenant_match is None and "tenant_match" in self.model_fields_set:
            _dict['tenantMatch'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListNetworkPoolServers200ResponseAllOfNetworkPoolServersInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": ListNetworkPoolServers200ResponseAllOfNetworkPoolServersInnerType.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "name": obj.get("name"),
            "enabled": obj.get("enabled"),
            "serviceUrl": obj.get("serviceUrl"),
            "serviceHost": obj.get("serviceHost"),
            "servicePort": obj.get("servicePort"),
            "serviceMode": obj.get("serviceMode"),
            "serviceUsername": obj.get("serviceUsername"),
            "servicePassword": obj.get("servicePassword"),
            "servicePasswordHash": obj.get("servicePasswordHash"),
            "serviceThrottleRate": obj.get("serviceThrottleRate") if obj.get("serviceThrottleRate") is not None else 0,
            "ignoreSsl": obj.get("ignoreSsl") if obj.get("ignoreSsl") is not None else True,
            "status": obj.get("status"),
            "statusMessage": obj.get("statusMessage"),
            "statusDate": obj.get("statusDate"),
            "config": obj.get("config"),
            "networkFilter": obj.get("networkFilter"),
            "zoneFilter": obj.get("zoneFilter"),
            "tenantMatch": obj.get("tenantMatch"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "account": ListNetworkServers200ResponseAllOfNetworkServersInnerAccount.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "integration": ListNetworkPoolServers200ResponseAllOfNetworkPoolServersInnerIntegration.from_dict(obj["integration"]) if obj.get("integration") is not None else None,
            "pools": [GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(_item) for _item in obj["pools"]] if obj.get("pools") is not None else None,
            "credential": ListNetworkPoolServers200ResponseAllOfNetworkPoolServersInnerCredential.from_dict(obj["credential"]) if obj.get("credential") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


