# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_price_sets200_response_all_of_price_sets_inner_prices_inner import ListPriceSets200ResponseAllOfPriceSetsInnerPricesInner
from typing import Optional, Set
from typing_extensions import Self

class ListPriceSets200ResponseAllOfPriceSetsInner(BaseModel):
    """
    ListPriceSets200ResponseAllOfPriceSetsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    active: Optional[StrictBool] = None
    price_unit: Optional[StrictStr] = Field(default=None, alias="priceUnit")
    type: Optional[StrictStr] = None
    region_code: Optional[StrictStr] = Field(default=None, alias="regionCode")
    system_created: Optional[StrictBool] = Field(default=None, alias="systemCreated")
    zone: Optional[StrictStr] = None
    zone_pool: Optional[StrictStr] = Field(default=None, alias="zonePool")
    account: Optional[StrictStr] = None
    prices: Optional[List[ListPriceSets200ResponseAllOfPriceSetsInnerPricesInner]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "code", "active", "priceUnit", "type", "regionCode", "systemCreated", "zone", "zonePool", "account", "prices"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListPriceSets200ResponseAllOfPriceSetsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in prices (list)
        _items = []
        if self.prices:
            for _item_prices in self.prices:
                if _item_prices:
                    _items.append(_item_prices.to_dict())
            _dict['prices'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if zone (nullable) is None
        # and model_fields_set contains the field
        if self.zone is None and "zone" in self.model_fields_set:
            _dict['zone'] = None

        # set to None if zone_pool (nullable) is None
        # and model_fields_set contains the field
        if self.zone_pool is None and "zone_pool" in self.model_fields_set:
            _dict['zonePool'] = None

        # set to None if account (nullable) is None
        # and model_fields_set contains the field
        if self.account is None and "account" in self.model_fields_set:
            _dict['account'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListPriceSets200ResponseAllOfPriceSetsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "code": obj.get("code"),
            "active": obj.get("active"),
            "priceUnit": obj.get("priceUnit"),
            "type": obj.get("type"),
            "regionCode": obj.get("regionCode"),
            "systemCreated": obj.get("systemCreated"),
            "zone": obj.get("zone"),
            "zonePool": obj.get("zonePool"),
            "account": obj.get("account"),
            "prices": [ListPriceSets200ResponseAllOfPriceSetsInnerPricesInner.from_dict(_item) for _item in obj["prices"]] if obj.get("prices") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


