# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from typing import Optional, Set
from typing_extensions import Self

class ListProvisioningLicenses200ResponseAllOfLicensesInner(BaseModel):
    """
    ListProvisioningLicenses200ResponseAllOfLicensesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    license_type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = Field(default=None, alias="licenseType")
    license_key: Optional[StrictStr] = Field(default=None, alias="licenseKey")
    org_name: Optional[StrictStr] = Field(default=None, alias="orgName")
    full_name: Optional[StrictStr] = Field(default=None, alias="fullName")
    license_version: Optional[StrictStr] = Field(default=None, alias="licenseVersion")
    copies: Optional[StrictInt] = None
    reservation_count: Optional[StrictInt] = Field(default=None, alias="reservationCount")
    tenants: Optional[List[Dict[str, Any]]] = None
    virtual_images: Optional[List[GetAlerts200ResponseAllOfCheckGroupsInnerInstance]] = Field(default=None, alias="virtualImages")
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "description", "licenseType", "licenseKey", "orgName", "fullName", "licenseVersion", "copies", "reservationCount", "tenants", "virtualImages", "account"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListProvisioningLicenses200ResponseAllOfLicensesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of license_type
        if self.license_type:
            _dict['licenseType'] = self.license_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in virtual_images (list)
        _items = []
        if self.virtual_images:
            for _item_virtual_images in self.virtual_images:
                if _item_virtual_images:
                    _items.append(_item_virtual_images.to_dict())
            _dict['virtualImages'] = _items
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListProvisioningLicenses200ResponseAllOfLicensesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "licenseType": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["licenseType"]) if obj.get("licenseType") is not None else None,
            "licenseKey": obj.get("licenseKey"),
            "orgName": obj.get("orgName"),
            "fullName": obj.get("fullName"),
            "licenseVersion": obj.get("licenseVersion"),
            "copies": obj.get("copies"),
            "reservationCount": obj.get("reservationCount"),
            "tenants": obj.get("tenants"),
            "virtualImages": [GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(_item) for _item in obj["virtualImages"]] if obj.get("virtualImages") is not None else None,
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


