# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_activity200_response_all_of_activity_inner_activity_inner_user import ListActivity200ResponseAllOfActivityInnerActivityInnerUser
from morpheus.models.list_cluster_network_endpoints200_response_all_of_endpoints_inner import ListClusterNetworkEndpoints200ResponseAllOfEndpointsInner
from morpheus.models.list_reports200_response_all_of_report_results_inner_config import ListReports200ResponseAllOfReportResultsInnerConfig
from morpheus.models.list_reports200_response_all_of_report_results_inner_rows_inner import ListReports200ResponseAllOfReportResultsInnerRowsInner
from typing import Optional, Set
from typing_extensions import Self

class ListReports200ResponseAllOfReportResultsInner(BaseModel):
    """
    ListReports200ResponseAllOfReportResultsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    type: Optional[ListClusterNetworkEndpoints200ResponseAllOfEndpointsInner] = None
    report_title: Optional[StrictStr] = Field(default=None, alias="reportTitle")
    filter_title: Optional[StrictStr] = Field(default=None, alias="filterTitle")
    status: Optional[StrictStr] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    start_date: Optional[datetime] = Field(default=None, alias="startDate")
    end_date: Optional[datetime] = Field(default=None, alias="endDate")
    config: Optional[ListReports200ResponseAllOfReportResultsInnerConfig] = None
    created_by: Optional[ListActivity200ResponseAllOfActivityInnerActivityInnerUser] = Field(default=None, alias="createdBy")
    rows: Optional[List[ListReports200ResponseAllOfReportResultsInnerRowsInner]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "type", "reportTitle", "filterTitle", "status", "dateCreated", "lastUpdated", "startDate", "endDate", "config", "createdBy", "rows"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListReports200ResponseAllOfReportResultsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in rows (list)
        _items = []
        if self.rows:
            for _item_rows in self.rows:
                if _item_rows:
                    _items.append(_item_rows.to_dict())
            _dict['rows'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if report_title (nullable) is None
        # and model_fields_set contains the field
        if self.report_title is None and "report_title" in self.model_fields_set:
            _dict['reportTitle'] = None

        # set to None if filter_title (nullable) is None
        # and model_fields_set contains the field
        if self.filter_title is None and "filter_title" in self.model_fields_set:
            _dict['filterTitle'] = None

        # set to None if start_date (nullable) is None
        # and model_fields_set contains the field
        if self.start_date is None and "start_date" in self.model_fields_set:
            _dict['startDate'] = None

        # set to None if end_date (nullable) is None
        # and model_fields_set contains the field
        if self.end_date is None and "end_date" in self.model_fields_set:
            _dict['endDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListReports200ResponseAllOfReportResultsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": ListClusterNetworkEndpoints200ResponseAllOfEndpointsInner.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "reportTitle": obj.get("reportTitle"),
            "filterTitle": obj.get("filterTitle"),
            "status": obj.get("status"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "config": ListReports200ResponseAllOfReportResultsInnerConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "createdBy": ListActivity200ResponseAllOfActivityInnerActivityInnerUser.from_dict(obj["createdBy"]) if obj.get("createdBy") is not None else None,
            "rows": [ListReports200ResponseAllOfReportResultsInnerRowsInner.from_dict(_item) for _item in obj["rows"]] if obj.get("rows") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


