# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_storage_buckets200_response_all_of_storage_buckets_inner_config import ListStorageBuckets200ResponseAllOfStorageBucketsInnerConfig
from typing import Optional, Set
from typing_extensions import Self

class ListStorageBuckets200ResponseAllOfStorageBucketsInner(BaseModel):
    """
    ListStorageBuckets200ResponseAllOfStorageBucketsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    active: Optional[StrictBool] = None
    account_id: Optional[StrictInt] = Field(default=None, alias="accountId")
    provider_type: Optional[StrictStr] = Field(default=None, alias="providerType")
    config: Optional[ListStorageBuckets200ResponseAllOfStorageBucketsInnerConfig] = None
    bucket_name: Optional[StrictStr] = Field(default=None, alias="bucketName")
    read_only: Optional[StrictBool] = Field(default=None, alias="readOnly")
    default_backup_target: Optional[StrictBool] = Field(default=None, alias="defaultBackupTarget")
    default_deployment_target: Optional[StrictBool] = Field(default=None, alias="defaultDeploymentTarget")
    default_virtual_image_target: Optional[StrictBool] = Field(default=None, alias="defaultVirtualImageTarget")
    copy_to_store: Optional[StrictBool] = Field(default=None, alias="copyToStore")
    retention_policy_type: Optional[StrictStr] = Field(default=None, alias="retentionPolicyType")
    retention_policy_days: Optional[StrictStr] = Field(default=None, alias="retentionPolicyDays")
    retention_provider: Optional[StrictStr] = Field(default=None, alias="retentionProvider")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "active", "accountId", "providerType", "config", "bucketName", "readOnly", "defaultBackupTarget", "defaultDeploymentTarget", "defaultVirtualImageTarget", "copyToStore", "retentionPolicyType", "retentionPolicyDays", "retentionProvider"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListStorageBuckets200ResponseAllOfStorageBucketsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if retention_policy_type (nullable) is None
        # and model_fields_set contains the field
        if self.retention_policy_type is None and "retention_policy_type" in self.model_fields_set:
            _dict['retentionPolicyType'] = None

        # set to None if retention_policy_days (nullable) is None
        # and model_fields_set contains the field
        if self.retention_policy_days is None and "retention_policy_days" in self.model_fields_set:
            _dict['retentionPolicyDays'] = None

        # set to None if retention_provider (nullable) is None
        # and model_fields_set contains the field
        if self.retention_provider is None and "retention_provider" in self.model_fields_set:
            _dict['retentionProvider'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListStorageBuckets200ResponseAllOfStorageBucketsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "active": obj.get("active"),
            "accountId": obj.get("accountId"),
            "providerType": obj.get("providerType"),
            "config": ListStorageBuckets200ResponseAllOfStorageBucketsInnerConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "bucketName": obj.get("bucketName"),
            "readOnly": obj.get("readOnly"),
            "defaultBackupTarget": obj.get("defaultBackupTarget"),
            "defaultDeploymentTarget": obj.get("defaultDeploymentTarget"),
            "defaultVirtualImageTarget": obj.get("defaultVirtualImageTarget"),
            "copyToStore": obj.get("copyToStore"),
            "retentionPolicyType": obj.get("retentionPolicyType"),
            "retentionPolicyDays": obj.get("retentionPolicyDays"),
            "retentionProvider": obj.get("retentionProvider")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


