# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_image_builds200_response_all_of_image_builds_inner_config_plan import ListImageBuilds200ResponseAllOfImageBuildsInnerConfigPlan
from morpheus.models.list_image_builds200_response_all_of_image_builds_inner_config_volumes_inner import ListImageBuilds200ResponseAllOfImageBuildsInnerConfigVolumesInner
from morpheus.models.list_instance_service_plans200_response_plans_inner_auto_options_inner import ListInstanceServicePlans200ResponsePlansInnerAutoOptionsInner
from morpheus.models.list_instances200_response_all_of_instances_inner_config_backup import ListInstances200ResponseAllOfInstancesInnerConfigBackup
from morpheus.models.list_vdi_pools200_response_all_of_vdi_pools_inner_config_config import ListVDIPools200ResponseAllOfVdiPoolsInnerConfigConfig
from morpheus.models.list_vdi_pools200_response_all_of_vdi_pools_inner_config_display_networks_inner import ListVDIPools200ResponseAllOfVdiPoolsInnerConfigDisplayNetworksInner
from morpheus.models.list_vdi_pools200_response_all_of_vdi_pools_inner_config_instance import ListVDIPools200ResponseAllOfVdiPoolsInnerConfigInstance
from morpheus.models.list_vdi_pools200_response_all_of_vdi_pools_inner_config_network_interfaces_inner import ListVDIPools200ResponseAllOfVdiPoolsInnerConfigNetworkInterfacesInner
from morpheus.models.list_vdi_pools200_response_all_of_vdi_pools_inner_config_storage_controllers_inner import ListVDIPools200ResponseAllOfVdiPoolsInnerConfigStorageControllersInner
from morpheus.models.list_vdi_pools200_response_all_of_vdi_pools_inner_config_volumes_display_inner import ListVDIPools200ResponseAllOfVdiPoolsInnerConfigVolumesDisplayInner
from typing import Optional, Set
from typing_extensions import Self

class ListVDIPools200ResponseAllOfVdiPoolsInnerConfig(BaseModel):
    """
    ListVDIPools200ResponseAllOfVdiPoolsInnerConfig
    """ # noqa: E501
    group: Optional[ListInstanceServicePlans200ResponsePlansInnerAutoOptionsInner] = None
    cloud: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    type: Optional[StrictStr] = None
    instance: Optional[ListVDIPools200ResponseAllOfVdiPoolsInnerConfigInstance] = None
    name: Optional[StrictStr] = None
    environment: Optional[StrictStr] = None
    config: Optional[ListVDIPools200ResponseAllOfVdiPoolsInnerConfigConfig] = None
    volumes: Optional[List[ListImageBuilds200ResponseAllOfImageBuildsInnerConfigVolumesInner]] = None
    host_name: Optional[StrictStr] = Field(default=None, alias="hostName")
    layout: Optional[ListImageBuilds200ResponseAllOfImageBuildsInnerConfigPlan] = None
    storage_controllers: Optional[List[ListVDIPools200ResponseAllOfVdiPoolsInnerConfigStorageControllersInner]] = Field(default=None, alias="storageControllers")
    plan: Optional[ListImageBuilds200ResponseAllOfImageBuildsInnerConfigPlan] = None
    version: Optional[StrictStr] = None
    network_interfaces: Optional[List[ListVDIPools200ResponseAllOfVdiPoolsInnerConfigNetworkInterfacesInner]] = Field(default=None, alias="networkInterfaces")
    execution_id: Optional[StrictStr] = Field(default=None, alias="executionId")
    backup: Optional[ListInstances200ResponseAllOfInstancesInnerConfigBackup] = None
    load_balancer: Optional[List[Dict[str, Any]]] = Field(default=None, alias="loadBalancer")
    hide_lock: Optional[StrictBool] = Field(default=None, alias="hideLock")
    has_networks: Optional[StrictBool] = Field(default=None, alias="hasNetworks")
    display_networks: Optional[List[ListVDIPools200ResponseAllOfVdiPoolsInnerConfigDisplayNetworksInner]] = Field(default=None, alias="displayNetworks")
    copies: Optional[StrictInt] = None
    show_scale: Optional[StrictBool] = Field(default=None, alias="showScale")
    has_preview: Optional[StrictBool] = Field(default=None, alias="hasPreview")
    volumes_display: Optional[List[ListVDIPools200ResponseAllOfVdiPoolsInnerConfigVolumesDisplayInner]] = Field(default=None, alias="volumesDisplay")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["group", "cloud", "type", "instance", "name", "environment", "config", "volumes", "hostName", "layout", "storageControllers", "plan", "version", "networkInterfaces", "executionId", "backup", "loadBalancer", "hideLock", "hasNetworks", "displayNetworks", "copies", "showScale", "hasPreview", "volumesDisplay"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListVDIPools200ResponseAllOfVdiPoolsInnerConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of group
        if self.group:
            _dict['group'] = self.group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cloud
        if self.cloud:
            _dict['cloud'] = self.cloud.to_dict()
        # override the default output from pydantic by calling `to_dict()` of instance
        if self.instance:
            _dict['instance'] = self.instance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in volumes (list)
        _items = []
        if self.volumes:
            for _item_volumes in self.volumes:
                if _item_volumes:
                    _items.append(_item_volumes.to_dict())
            _dict['volumes'] = _items
        # override the default output from pydantic by calling `to_dict()` of layout
        if self.layout:
            _dict['layout'] = self.layout.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in storage_controllers (list)
        _items = []
        if self.storage_controllers:
            for _item_storage_controllers in self.storage_controllers:
                if _item_storage_controllers:
                    _items.append(_item_storage_controllers.to_dict())
            _dict['storageControllers'] = _items
        # override the default output from pydantic by calling `to_dict()` of plan
        if self.plan:
            _dict['plan'] = self.plan.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in network_interfaces (list)
        _items = []
        if self.network_interfaces:
            for _item_network_interfaces in self.network_interfaces:
                if _item_network_interfaces:
                    _items.append(_item_network_interfaces.to_dict())
            _dict['networkInterfaces'] = _items
        # override the default output from pydantic by calling `to_dict()` of backup
        if self.backup:
            _dict['backup'] = self.backup.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in display_networks (list)
        _items = []
        if self.display_networks:
            for _item_display_networks in self.display_networks:
                if _item_display_networks:
                    _items.append(_item_display_networks.to_dict())
            _dict['displayNetworks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in volumes_display (list)
        _items = []
        if self.volumes_display:
            for _item_volumes_display in self.volumes_display:
                if _item_volumes_display:
                    _items.append(_item_volumes_display.to_dict())
            _dict['volumesDisplay'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if storage_controllers (nullable) is None
        # and model_fields_set contains the field
        if self.storage_controllers is None and "storage_controllers" in self.model_fields_set:
            _dict['storageControllers'] = None

        # set to None if load_balancer (nullable) is None
        # and model_fields_set contains the field
        if self.load_balancer is None and "load_balancer" in self.model_fields_set:
            _dict['loadBalancer'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListVDIPools200ResponseAllOfVdiPoolsInnerConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "group": ListInstanceServicePlans200ResponsePlansInnerAutoOptionsInner.from_dict(obj["group"]) if obj.get("group") is not None else None,
            "cloud": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["cloud"]) if obj.get("cloud") is not None else None,
            "type": obj.get("type"),
            "instance": ListVDIPools200ResponseAllOfVdiPoolsInnerConfigInstance.from_dict(obj["instance"]) if obj.get("instance") is not None else None,
            "name": obj.get("name"),
            "environment": obj.get("environment"),
            "config": ListVDIPools200ResponseAllOfVdiPoolsInnerConfigConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "volumes": [ListImageBuilds200ResponseAllOfImageBuildsInnerConfigVolumesInner.from_dict(_item) for _item in obj["volumes"]] if obj.get("volumes") is not None else None,
            "hostName": obj.get("hostName"),
            "layout": ListImageBuilds200ResponseAllOfImageBuildsInnerConfigPlan.from_dict(obj["layout"]) if obj.get("layout") is not None else None,
            "storageControllers": [ListVDIPools200ResponseAllOfVdiPoolsInnerConfigStorageControllersInner.from_dict(_item) for _item in obj["storageControllers"]] if obj.get("storageControllers") is not None else None,
            "plan": ListImageBuilds200ResponseAllOfImageBuildsInnerConfigPlan.from_dict(obj["plan"]) if obj.get("plan") is not None else None,
            "version": obj.get("version"),
            "networkInterfaces": [ListVDIPools200ResponseAllOfVdiPoolsInnerConfigNetworkInterfacesInner.from_dict(_item) for _item in obj["networkInterfaces"]] if obj.get("networkInterfaces") is not None else None,
            "executionId": obj.get("executionId"),
            "backup": ListInstances200ResponseAllOfInstancesInnerConfigBackup.from_dict(obj["backup"]) if obj.get("backup") is not None else None,
            "loadBalancer": obj.get("loadBalancer"),
            "hideLock": obj.get("hideLock"),
            "hasNetworks": obj.get("hasNetworks"),
            "displayNetworks": [ListVDIPools200ResponseAllOfVdiPoolsInnerConfigDisplayNetworksInner.from_dict(_item) for _item in obj["displayNetworks"]] if obj.get("displayNetworks") is not None else None,
            "copies": obj.get("copies"),
            "showScale": obj.get("showScale"),
            "hasPreview": obj.get("hasPreview"),
            "volumesDisplay": [ListVDIPools200ResponseAllOfVdiPoolsInnerConfigVolumesDisplayInner.from_dict(_item) for _item in obj["volumesDisplay"]] if obj.get("volumesDisplay") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


