# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_logs200_response_all_of_data_inner import ListLogs200ResponseAllOfDataInner
from morpheus.models.list_logs200_response_all_of_sort import ListLogs200ResponseAllOfSort
from typing import Optional, Set
from typing_extensions import Self

class Log(BaseModel):
    """
    Log
    """ # noqa: E501
    sort: Optional[ListLogs200ResponseAllOfSort] = None
    offset: Optional[StrictInt] = None
    start: Optional[datetime] = None
    end: Optional[datetime] = None
    data: Optional[List[ListLogs200ResponseAllOfDataInner]] = None
    max: Optional[StrictInt] = None
    grand_total: Optional[StrictInt] = Field(default=None, alias="grandTotal")
    total: Optional[StrictInt] = None
    success: Optional[StrictBool] = None
    count: Optional[StrictInt] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["sort", "offset", "start", "end", "data", "max", "grandTotal", "total", "success", "count"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Log from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of sort
        if self.sort:
            _dict['sort'] = self.sort.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in data (list)
        _items = []
        if self.data:
            for _item_data in self.data:
                if _item_data:
                    _items.append(_item_data.to_dict())
            _dict['data'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Log from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sort": ListLogs200ResponseAllOfSort.from_dict(obj["sort"]) if obj.get("sort") is not None else None,
            "offset": obj.get("offset"),
            "start": obj.get("start"),
            "end": obj.get("end"),
            "data": [ListLogs200ResponseAllOfDataInner.from_dict(_item) for _item in obj["data"]] if obj.get("data") is not None else None,
            "max": obj.get("max"),
            "grandTotal": obj.get("grandTotal"),
            "total": obj.get("total"),
            "success": obj.get("success"),
            "count": obj.get("count")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


