# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class NetworkDomainCreate(BaseModel):
    """
    NetworkDomainCreate
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Name")
    description: Optional[StrictStr] = Field(default=None, description="Description")
    display_name: Optional[StrictStr] = Field(default=None, description="Overrides displayed name in domain selection components. Useful if using many OU Paths.", alias="displayName")
    public_zone: Optional[StrictBool] = Field(default=False, description="Public Zone", alias="publicZone")
    task_set_id: Optional[StrictInt] = Field(default=None, description="Workflow ID. Workflows can be applied to an instance when associated with a domain. Useful for custom domain related scripting. (Important if wanting to ensure the computer is removed from the domain using teardown phased workflows.) ", alias="taskSetId")
    active: Optional[StrictBool] = Field(default=None, description="Active")
    domain_controller: Optional[StrictBool] = Field(default=True, description="Join Domain Controller", alias="domainController")
    domain_username: Optional[StrictStr] = Field(default=None, description="Domain Username", alias="domainUsername")
    domain_password: Optional[StrictStr] = Field(default=None, description="Domain Password", alias="domainPassword")
    dc_server: Optional[StrictStr] = Field(default=None, description="DC Server. If specified, must be the server name and not an IP Address", alias="dcServer")
    ou_path: Optional[StrictStr] = Field(default=None, description="OU Path. (i.e. 'OU=staging,DC=ad,DC=yourdomain,DC=com')", alias="ouPath")
    guest_username: Optional[StrictStr] = Field(default=None, description="Guest Username. If set, will change the instances RPC Service User after joining a Domain.", alias="guestUsername")
    guest_password: Optional[StrictStr] = Field(default=None, description="Guest Password", alias="guestPassword")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "description", "displayName", "publicZone", "taskSetId", "active", "domainController", "domainUsername", "domainPassword", "dcServer", "ouPath", "guestUsername", "guestPassword"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NetworkDomainCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NetworkDomainCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "displayName": obj.get("displayName"),
            "publicZone": obj.get("publicZone") if obj.get("publicZone") is not None else False,
            "taskSetId": obj.get("taskSetId"),
            "active": obj.get("active"),
            "domainController": obj.get("domainController") if obj.get("domainController") is not None else True,
            "domainUsername": obj.get("domainUsername"),
            "domainPassword": obj.get("domainPassword"),
            "dcServer": obj.get("dcServer"),
            "ouPath": obj.get("ouPath"),
            "guestUsername": obj.get("guestUsername"),
            "guestPassword": obj.get("guestPassword")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


