# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.bluecat_network_pool_server_config import BluecatNetworkPoolServerConfig
from morpheus.models.nsx_network_server_credential import NSXNetworkServerCredential
from typing import Optional, Set
from typing_extensions import Self

class NetworkPoolServerUpdateSolarWinds(BaseModel):
    """
    NetworkPoolServerUpdateSolarWinds
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Name")
    enabled: Optional[StrictBool] = Field(default=True, description="Can be used to enable / disable the network pool server.")
    service_url: Optional[StrictStr] = Field(default=None, description="URL", alias="serviceUrl")
    service_username: Optional[StrictStr] = Field(default=None, description="Username", alias="serviceUsername")
    service_password: Optional[StrictStr] = Field(default=None, description="Password", alias="servicePassword")
    service_throttle_rate: Optional[StrictInt] = Field(default=0, description="Throttle Rate", alias="serviceThrottleRate")
    ignore_ssl: Optional[StrictBool] = Field(default=None, description="Disable SSL SNI Verification", alias="ignoreSsl")
    config: Optional[BluecatNetworkPoolServerConfig] = None
    credential: Optional[NSXNetworkServerCredential] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "enabled", "serviceUrl", "serviceUsername", "servicePassword", "serviceThrottleRate", "ignoreSsl", "config", "credential"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NetworkPoolServerUpdateSolarWinds from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of credential
        if self.credential:
            _dict['credential'] = self.credential.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if service_url (nullable) is None
        # and model_fields_set contains the field
        if self.service_url is None and "service_url" in self.model_fields_set:
            _dict['serviceUrl'] = None

        # set to None if service_username (nullable) is None
        # and model_fields_set contains the field
        if self.service_username is None and "service_username" in self.model_fields_set:
            _dict['serviceUsername'] = None

        # set to None if service_password (nullable) is None
        # and model_fields_set contains the field
        if self.service_password is None and "service_password" in self.model_fields_set:
            _dict['servicePassword'] = None

        # set to None if service_throttle_rate (nullable) is None
        # and model_fields_set contains the field
        if self.service_throttle_rate is None and "service_throttle_rate" in self.model_fields_set:
            _dict['serviceThrottleRate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NetworkPoolServerUpdateSolarWinds from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "serviceUrl": obj.get("serviceUrl"),
            "serviceUsername": obj.get("serviceUsername"),
            "servicePassword": obj.get("servicePassword"),
            "serviceThrottleRate": obj.get("serviceThrottleRate") if obj.get("serviceThrottleRate") is not None else 0,
            "ignoreSsl": obj.get("ignoreSsl"),
            "config": BluecatNetworkPoolServerConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "credential": NSXNetworkServerCredential.from_dict(obj["credential"]) if obj.get("credential") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


