# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class OsTypeCreate(BaseModel):
    """
    OsTypeCreate
    """ # noqa: E501
    name: StrictStr = Field(description="The name of the osType. ")
    description: Optional[StrictStr] = Field(default=None, description="The description of the osType.  ")
    platform: StrictStr = Field(description="The platform of the osType.  ")
    code: StrictStr = Field(description="The code morph uses as an identifier ")
    category: Optional[StrictStr] = Field(default=None, description="The category of the osType. ")
    vendor: Optional[StrictStr] = Field(default=None, description="The vendor of the osType. ")
    os_name: Optional[StrictStr] = Field(default=None, description="The osName of the osType. ", alias="osName")
    os_version: Optional[StrictStr] = Field(default=None, description="The osVersion of the osType. ", alias="osVersion")
    os_codename: Optional[StrictStr] = Field(default=None, description="The osCodename of the osType. ", alias="osCodename")
    os_family: Optional[StrictStr] = Field(default=None, description="The family of the osType. ", alias="osFamily")
    bit_count: StrictInt = Field(description="The bitCount/architecture of the osType. ", alias="bitCount")
    cloud_init_version: Optional[StrictStr] = Field(default=None, description="The version of CloudInit being used. ", alias="cloudInitVersion")
    install_agent: Optional[StrictBool] = Field(default=None, description="Whether the morpheus agent is installed. ", alias="installAgent")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "description", "platform", "code", "category", "vendor", "osName", "osVersion", "osCodename", "osFamily", "bitCount", "cloudInitVersion", "installAgent"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OsTypeCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if vendor (nullable) is None
        # and model_fields_set contains the field
        if self.vendor is None and "vendor" in self.model_fields_set:
            _dict['vendor'] = None

        # set to None if os_name (nullable) is None
        # and model_fields_set contains the field
        if self.os_name is None and "os_name" in self.model_fields_set:
            _dict['osName'] = None

        # set to None if os_version (nullable) is None
        # and model_fields_set contains the field
        if self.os_version is None and "os_version" in self.model_fields_set:
            _dict['osVersion'] = None

        # set to None if os_codename (nullable) is None
        # and model_fields_set contains the field
        if self.os_codename is None and "os_codename" in self.model_fields_set:
            _dict['osCodename'] = None

        # set to None if os_family (nullable) is None
        # and model_fields_set contains the field
        if self.os_family is None and "os_family" in self.model_fields_set:
            _dict['osFamily'] = None

        # set to None if install_agent (nullable) is None
        # and model_fields_set contains the field
        if self.install_agent is None and "install_agent" in self.model_fields_set:
            _dict['installAgent'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OsTypeCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "platform": obj.get("platform"),
            "code": obj.get("code"),
            "category": obj.get("category"),
            "vendor": obj.get("vendor"),
            "osName": obj.get("osName"),
            "osVersion": obj.get("osVersion"),
            "osCodename": obj.get("osCodename"),
            "osFamily": obj.get("osFamily"),
            "bitCount": obj.get("bitCount"),
            "cloudInitVersion": obj.get("cloudInitVersion"),
            "installAgent": obj.get("installAgent")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


