# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from typing import Optional, Set
from typing_extensions import Self

class Roles(BaseModel):
    """
    Roles
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = Field(default=None, description="a unique name of the role")
    authority: Optional[StrictStr] = Field(default=None, description="Alias for name")
    description: Optional[StrictStr] = None
    landing_url: Optional[StrictStr] = Field(default=None, description="An optional override for the default landing page after login for a user.", alias="landingUrl")
    scope: Optional[StrictStr] = None
    role_type: Optional[StrictStr] = Field(default=None, alias="roleType")
    multitenant: Optional[StrictBool] = None
    multitenant_locked: Optional[StrictBool] = Field(default=None, alias="multitenantLocked")
    parent_role_id: Optional[StrictStr] = Field(default=None, alias="parentRoleId")
    diverged: Optional[StrictBool] = None
    owner_id: Optional[StrictInt] = Field(default=None, alias="ownerId")
    owner: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    default_persona: Optional[StrictStr] = Field(default=None, alias="defaultPersona")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "authority", "description", "landingUrl", "scope", "roleType", "multitenant", "multitenantLocked", "parentRoleId", "diverged", "ownerId", "owner", "defaultPersona", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Roles from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if landing_url (nullable) is None
        # and model_fields_set contains the field
        if self.landing_url is None and "landing_url" in self.model_fields_set:
            _dict['landingUrl'] = None

        # set to None if parent_role_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_role_id is None and "parent_role_id" in self.model_fields_set:
            _dict['parentRoleId'] = None

        # set to None if default_persona (nullable) is None
        # and model_fields_set contains the field
        if self.default_persona is None and "default_persona" in self.model_fields_set:
            _dict['defaultPersona'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Roles from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "authority": obj.get("authority"),
            "description": obj.get("description"),
            "landingUrl": obj.get("landingUrl"),
            "scope": obj.get("scope"),
            "roleType": obj.get("roleType"),
            "multitenant": obj.get("multitenant"),
            "multitenantLocked": obj.get("multitenantLocked"),
            "parentRoleId": obj.get("parentRoleId"),
            "diverged": obj.get("diverged"),
            "ownerId": obj.get("ownerId"),
            "owner": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "defaultPersona": obj.get("defaultPersona"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


