# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from morpheus.models.add_service_plans200_response_all_of_service_plan_permissions import AddServicePlans200ResponseAllOfServicePlanPermissions
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from morpheus.models.list_guidances200_response_all_of_discoveries_inner_any_of_plan_before_action_price_sets_inner import ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfPlanBeforeActionPriceSetsInner
from morpheus.models.list_guidances200_response_all_of_discoveries_inner_any_of_plan_before_action_provision_type import ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfPlanBeforeActionProvisionType
from morpheus.models.list_service_plans200_response_all_of_service_plans_inner_config import ListServicePlans200ResponseAllOfServicePlansInnerConfig
from typing import Optional, Set
from typing_extensions import Self

class ServicePlan(BaseModel):
    """
    ServicePlan
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    active: Optional[StrictBool] = None
    sort_order: Optional[StrictInt] = Field(default=None, alias="sortOrder")
    description: Optional[StrictStr] = None
    max_storage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="maxStorage")
    max_memory: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="maxMemory")
    max_cpu: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="maxCpu")
    max_cores: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="maxCores")
    max_disks: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="maxDisks")
    cores_per_socket: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="coresPerSocket")
    custom_cpu: Optional[StrictBool] = Field(default=None, alias="customCpu")
    custom_cores: Optional[StrictBool] = Field(default=None, alias="customCores")
    custom_max_storage: Optional[StrictBool] = Field(default=None, alias="customMaxStorage")
    custom_max_data_storage: Optional[StrictBool] = Field(default=None, alias="customMaxDataStorage")
    custom_max_memory: Optional[StrictBool] = Field(default=None, alias="customMaxMemory")
    add_volumes: Optional[StrictBool] = Field(default=None, alias="addVolumes")
    memory_option_source: Optional[StrictStr] = Field(default=None, alias="memoryOptionSource")
    cpu_option_source: Optional[StrictStr] = Field(default=None, alias="cpuOptionSource")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    region_code: Optional[StrictStr] = Field(default=None, alias="regionCode")
    visibility: Optional[StrictStr] = None
    editable: Optional[StrictBool] = None
    provision_type: Optional[ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfPlanBeforeActionProvisionType] = Field(default=None, alias="provisionType")
    tenants: Optional[StrictStr] = None
    price_sets: Optional[List[ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfPlanBeforeActionPriceSetsInner]] = Field(default=None, alias="priceSets")
    config: Optional[ListServicePlans200ResponseAllOfServicePlansInnerConfig] = None
    zones: Optional[List[ListBackupSettings200ResponseBackupSettingsDefaultSchedule]] = None
    permissions: Optional[AddServicePlans200ResponseAllOfServicePlanPermissions] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "code", "active", "sortOrder", "description", "maxStorage", "maxMemory", "maxCpu", "maxCores", "maxDisks", "coresPerSocket", "customCpu", "customCores", "customMaxStorage", "customMaxDataStorage", "customMaxMemory", "addVolumes", "memoryOptionSource", "cpuOptionSource", "dateCreated", "lastUpdated", "regionCode", "visibility", "editable", "provisionType", "tenants", "priceSets", "config", "zones", "permissions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ServicePlan from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of provision_type
        if self.provision_type:
            _dict['provisionType'] = self.provision_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in price_sets (list)
        _items = []
        if self.price_sets:
            for _item_price_sets in self.price_sets:
                if _item_price_sets:
                    _items.append(_item_price_sets.to_dict())
            _dict['priceSets'] = _items
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in zones (list)
        _items = []
        if self.zones:
            for _item_zones in self.zones:
                if _item_zones:
                    _items.append(_item_zones.to_dict())
            _dict['zones'] = _items
        # override the default output from pydantic by calling `to_dict()` of permissions
        if self.permissions:
            _dict['permissions'] = self.permissions.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if max_cpu (nullable) is None
        # and model_fields_set contains the field
        if self.max_cpu is None and "max_cpu" in self.model_fields_set:
            _dict['maxCpu'] = None

        # set to None if max_cores (nullable) is None
        # and model_fields_set contains the field
        if self.max_cores is None and "max_cores" in self.model_fields_set:
            _dict['maxCores'] = None

        # set to None if max_disks (nullable) is None
        # and model_fields_set contains the field
        if self.max_disks is None and "max_disks" in self.model_fields_set:
            _dict['maxDisks'] = None

        # set to None if custom_max_storage (nullable) is None
        # and model_fields_set contains the field
        if self.custom_max_storage is None and "custom_max_storage" in self.model_fields_set:
            _dict['customMaxStorage'] = None

        # set to None if custom_max_data_storage (nullable) is None
        # and model_fields_set contains the field
        if self.custom_max_data_storage is None and "custom_max_data_storage" in self.model_fields_set:
            _dict['customMaxDataStorage'] = None

        # set to None if custom_max_memory (nullable) is None
        # and model_fields_set contains the field
        if self.custom_max_memory is None and "custom_max_memory" in self.model_fields_set:
            _dict['customMaxMemory'] = None

        # set to None if add_volumes (nullable) is None
        # and model_fields_set contains the field
        if self.add_volumes is None and "add_volumes" in self.model_fields_set:
            _dict['addVolumes'] = None

        # set to None if memory_option_source (nullable) is None
        # and model_fields_set contains the field
        if self.memory_option_source is None and "memory_option_source" in self.model_fields_set:
            _dict['memoryOptionSource'] = None

        # set to None if cpu_option_source (nullable) is None
        # and model_fields_set contains the field
        if self.cpu_option_source is None and "cpu_option_source" in self.model_fields_set:
            _dict['cpuOptionSource'] = None

        # set to None if region_code (nullable) is None
        # and model_fields_set contains the field
        if self.region_code is None and "region_code" in self.model_fields_set:
            _dict['regionCode'] = None

        # set to None if price_sets (nullable) is None
        # and model_fields_set contains the field
        if self.price_sets is None and "price_sets" in self.model_fields_set:
            _dict['priceSets'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ServicePlan from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "code": obj.get("code"),
            "active": obj.get("active"),
            "sortOrder": obj.get("sortOrder"),
            "description": obj.get("description"),
            "maxStorage": obj.get("maxStorage"),
            "maxMemory": obj.get("maxMemory"),
            "maxCpu": obj.get("maxCpu"),
            "maxCores": obj.get("maxCores"),
            "maxDisks": obj.get("maxDisks"),
            "coresPerSocket": obj.get("coresPerSocket"),
            "customCpu": obj.get("customCpu"),
            "customCores": obj.get("customCores"),
            "customMaxStorage": obj.get("customMaxStorage"),
            "customMaxDataStorage": obj.get("customMaxDataStorage"),
            "customMaxMemory": obj.get("customMaxMemory"),
            "addVolumes": obj.get("addVolumes"),
            "memoryOptionSource": obj.get("memoryOptionSource"),
            "cpuOptionSource": obj.get("cpuOptionSource"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "regionCode": obj.get("regionCode"),
            "visibility": obj.get("visibility"),
            "editable": obj.get("editable"),
            "provisionType": ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfPlanBeforeActionProvisionType.from_dict(obj["provisionType"]) if obj.get("provisionType") is not None else None,
            "tenants": obj.get("tenants"),
            "priceSets": [ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfPlanBeforeActionPriceSetsInner.from_dict(_item) for _item in obj["priceSets"]] if obj.get("priceSets") is not None else None,
            "config": ListServicePlans200ResponseAllOfServicePlansInnerConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "zones": [ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(_item) for _item in obj["zones"]] if obj.get("zones") is not None else None,
            "permissions": AddServicePlans200ResponseAllOfServicePlanPermissions.from_dict(obj["permissions"]) if obj.get("permissions") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


