# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.update_instance_network_interface200_response_all_of_one_of_server_zone_network_server import UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerZoneNetworkServer
from typing import Optional, Set
from typing_extensions import Self

class UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerZone(BaseModel):
    """
    UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerZone
    """ # noqa: E501
    id: Optional[StrictInt] = None
    account_id: Optional[StrictInt] = Field(default=None, alias="accountId")
    groups: Optional[List[StrictInt]] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    location: Optional[StrictStr] = None
    visibility: Optional[StrictStr] = None
    zone_type_id: Optional[StrictInt] = Field(default=None, alias="zoneTypeId")
    network_server: Optional[UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerZoneNetworkServer] = Field(default=None, alias="networkServer")
    security_server: Optional[StrictStr] = Field(default=None, alias="securityServer")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "accountId", "groups", "name", "description", "location", "visibility", "zoneTypeId", "networkServer", "securityServer"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerZone from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of network_server
        if self.network_server:
            _dict['networkServer'] = self.network_server.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if security_server (nullable) is None
        # and model_fields_set contains the field
        if self.security_server is None and "security_server" in self.model_fields_set:
            _dict['securityServer'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerZone from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "accountId": obj.get("accountId"),
            "groups": obj.get("groups"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "location": obj.get("location"),
            "visibility": obj.get("visibility"),
            "zoneTypeId": obj.get("zoneTypeId"),
            "networkServer": UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerZoneNetworkServer.from_dict(obj["networkServer"]) if obj.get("networkServer") is not None else None,
            "securityServer": obj.get("securityServer")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


