# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_option_list_request_option_type_list_config import AddOptionListRequestOptionTypeListConfig
from morpheus.models.add_option_list_request_option_type_list_credential import AddOptionListRequestOptionTypeListCredential
from typing import Optional, Set
from typing_extensions import Self

class UpdateOptionListRequestOptionTypeList(BaseModel):
    """
    UpdateOptionListRequestOptionTypeList
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Name")
    description: Optional[StrictStr] = Field(default=None, description="Description")
    labels: Optional[List[StrictStr]] = Field(default=None, description="Array of label strings, can be used for filtering.")
    type: Optional[StrictStr] = Field(default='rest', description="Option List Type eg. `rest`, `api`, `ldap` or `manual`.")
    source_url: Optional[StrictStr] = Field(default=None, description="Source URL, the http(s) URL to request data from. Required when type is rest.", alias="sourceUrl")
    visibility: Optional[StrictStr] = Field(default='private', description="Visibility")
    source_method: Optional[StrictStr] = Field(default='GET', description="Source Method, the HTTP method.", alias="sourceMethod")
    api_type: Optional[StrictStr] = Field(default=None, description="Api Type, The code of the api option list to use, eg. clouds, environments, groups, instances, instance-wiki, networks, servicePlans, resourcePools, securityGroups, servers, server-wiki. Required when type is api.", alias="apiType")
    ignore_ssl_errors: Optional[StrictBool] = Field(default=False, description="Ignore SSL Errors.", alias="ignoreSSLErrors")
    real_time: Optional[StrictBool] = Field(default=False, description="Real Time.", alias="realTime")
    credential: Optional[AddOptionListRequestOptionTypeListCredential] = None
    service_username: Optional[StrictStr] = Field(default=None, description="Username for authenticating with Basic Auth when type is rest or ldap username.", alias="serviceUsername")
    service_password: Optional[StrictStr] = Field(default=None, description="Password for authenticating with Basic Auth when type is rest or ldap password.", alias="servicePassword")
    initial_dataset: Optional[StrictStr] = Field(default=None, description="Initial Dataset. Create an initial JSON or CSV dataset to be used as the collection for this option list. It should be a list containing objects with properties 'name', and 'value'. Required when type is manual.", alias="initialDataset")
    translation_script: Optional[StrictStr] = Field(default=None, description="Translation Script. Create a js script to translate the result data object into an Array containing objects with properties 'name' and 'value'. The input data is provided as data and the result should be put on the global variable results.", alias="translationScript")
    request_script: Optional[StrictStr] = Field(default=None, description="Request Script. Create a js script to prepare the request. Return a data object as the body for a post, and return an array containing properties 'name' and 'value' for a get. The input data is provided as data and the result should be put on the global variable results.", alias="requestScript")
    config: Optional[AddOptionListRequestOptionTypeListConfig] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "description", "labels", "type", "sourceUrl", "visibility", "sourceMethod", "apiType", "ignoreSSLErrors", "realTime", "credential", "serviceUsername", "servicePassword", "initialDataset", "translationScript", "requestScript", "config"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['rest', 'api', 'ldap', 'manual']):
            raise ValueError("must be one of enum values ('rest', 'api', 'ldap', 'manual')")
        return value

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['private', 'public']):
            raise ValueError("must be one of enum values ('private', 'public')")
        return value

    @field_validator('source_method')
    def source_method_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['GET', 'POST']):
            raise ValueError("must be one of enum values ('GET', 'POST')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateOptionListRequestOptionTypeList from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of credential
        if self.credential:
            _dict['credential'] = self.credential.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        # set to None if api_type (nullable) is None
        # and model_fields_set contains the field
        if self.api_type is None and "api_type" in self.model_fields_set:
            _dict['apiType'] = None

        # set to None if service_username (nullable) is None
        # and model_fields_set contains the field
        if self.service_username is None and "service_username" in self.model_fields_set:
            _dict['serviceUsername'] = None

        # set to None if service_password (nullable) is None
        # and model_fields_set contains the field
        if self.service_password is None and "service_password" in self.model_fields_set:
            _dict['servicePassword'] = None

        # set to None if initial_dataset (nullable) is None
        # and model_fields_set contains the field
        if self.initial_dataset is None and "initial_dataset" in self.model_fields_set:
            _dict['initialDataset'] = None

        # set to None if translation_script (nullable) is None
        # and model_fields_set contains the field
        if self.translation_script is None and "translation_script" in self.model_fields_set:
            _dict['translationScript'] = None

        # set to None if request_script (nullable) is None
        # and model_fields_set contains the field
        if self.request_script is None and "request_script" in self.model_fields_set:
            _dict['requestScript'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateOptionListRequestOptionTypeList from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "labels": obj.get("labels"),
            "type": obj.get("type") if obj.get("type") is not None else 'rest',
            "sourceUrl": obj.get("sourceUrl"),
            "visibility": obj.get("visibility") if obj.get("visibility") is not None else 'private',
            "sourceMethod": obj.get("sourceMethod") if obj.get("sourceMethod") is not None else 'GET',
            "apiType": obj.get("apiType"),
            "ignoreSSLErrors": obj.get("ignoreSSLErrors") if obj.get("ignoreSSLErrors") is not None else False,
            "realTime": obj.get("realTime") if obj.get("realTime") is not None else False,
            "credential": AddOptionListRequestOptionTypeListCredential.from_dict(obj["credential"]) if obj.get("credential") is not None else None,
            "serviceUsername": obj.get("serviceUsername"),
            "servicePassword": obj.get("servicePassword"),
            "initialDataset": obj.get("initialDataset"),
            "translationScript": obj.get("translationScript"),
            "requestScript": obj.get("requestScript"),
            "config": AddOptionListRequestOptionTypeListConfig.from_dict(obj["config"]) if obj.get("config") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


