# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from morpheus.models.update_role_cloud_access_request_one_of import UpdateRoleCloudAccessRequestOneOf
from morpheus.models.update_role_cloud_access_request_one_of1 import UpdateRoleCloudAccessRequestOneOf1
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

UPDATEROLECLOUDACCESSREQUEST_ONE_OF_SCHEMAS = ["UpdateRoleCloudAccessRequestOneOf", "UpdateRoleCloudAccessRequestOneOf1"]

class UpdateRoleCloudAccessRequest(BaseModel):
    """
    UpdateRoleCloudAccessRequest
    """
    # data type: UpdateRoleCloudAccessRequestOneOf
    oneof_schema_1_validator: Optional[UpdateRoleCloudAccessRequestOneOf] = None
    # data type: UpdateRoleCloudAccessRequestOneOf1
    oneof_schema_2_validator: Optional[UpdateRoleCloudAccessRequestOneOf1] = None
    actual_instance: Optional[Union[UpdateRoleCloudAccessRequestOneOf, UpdateRoleCloudAccessRequestOneOf1]] = None
    one_of_schemas: Set[str] = { "UpdateRoleCloudAccessRequestOneOf", "UpdateRoleCloudAccessRequestOneOf1" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = UpdateRoleCloudAccessRequest.model_construct()
        error_messages = []
        match = 0
        # validate data type: UpdateRoleCloudAccessRequestOneOf
        if not isinstance(v, UpdateRoleCloudAccessRequestOneOf):
            error_messages.append(f"Error! Input type `{type(v)}` is not `UpdateRoleCloudAccessRequestOneOf`")
        else:
            match += 1
        # validate data type: UpdateRoleCloudAccessRequestOneOf1
        if not isinstance(v, UpdateRoleCloudAccessRequestOneOf1):
            error_messages.append(f"Error! Input type `{type(v)}` is not `UpdateRoleCloudAccessRequestOneOf1`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in UpdateRoleCloudAccessRequest with oneOf schemas: UpdateRoleCloudAccessRequestOneOf, UpdateRoleCloudAccessRequestOneOf1. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in UpdateRoleCloudAccessRequest with oneOf schemas: UpdateRoleCloudAccessRequestOneOf, UpdateRoleCloudAccessRequestOneOf1. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into UpdateRoleCloudAccessRequestOneOf
        try:
            instance.actual_instance = UpdateRoleCloudAccessRequestOneOf.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into UpdateRoleCloudAccessRequestOneOf1
        try:
            instance.actual_instance = UpdateRoleCloudAccessRequestOneOf1.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into UpdateRoleCloudAccessRequest with oneOf schemas: UpdateRoleCloudAccessRequestOneOf, UpdateRoleCloudAccessRequestOneOf1. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into UpdateRoleCloudAccessRequest with oneOf schemas: UpdateRoleCloudAccessRequestOneOf, UpdateRoleCloudAccessRequestOneOf1. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], UpdateRoleCloudAccessRequestOneOf, UpdateRoleCloudAccessRequestOneOf1]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


