# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class UpdateScaleThresholdsRequestScaleThreshold(BaseModel):
    """
    UpdateScaleThresholdsRequestScaleThreshold
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="A name for the scale threshold")
    auto_up: Optional[StrictBool] = Field(default=False, description="Auto Upscale", alias="autoUp")
    auto_down: Optional[StrictBool] = Field(default=False, description="Auto Downscale", alias="autoDown")
    min_count: Optional[StrictInt] = Field(default=None, description="The minimum number of nodes to scale down to", alias="minCount")
    max_count: Optional[StrictInt] = Field(default=None, description="The maximum number of nodes to scale up to", alias="maxCount")
    cpu_enabled: Optional[StrictBool] = Field(default=False, description="Enable CPU Threshold", alias="cpuEnabled")
    min_cpu: Optional[Union[StrictFloat, StrictInt]] = Field(default=0, description="Min CPU (%)", alias="minCpu")
    max_cpu: Optional[Union[StrictFloat, StrictInt]] = Field(default=0, description="Max CPU (%)", alias="maxCpu")
    memory_enabled: Optional[StrictBool] = Field(default=False, description="Enable Memory Threshold", alias="memoryEnabled")
    min_memory: Optional[Union[StrictFloat, StrictInt]] = Field(default=0, description="Min Memory (%)", alias="minMemory")
    max_memory: Optional[Union[StrictFloat, StrictInt]] = Field(default=0, description="Max Memory (%)", alias="maxMemory")
    disk_enabled: Optional[StrictBool] = Field(default=False, description="Enable Disk Threshold", alias="diskEnabled")
    min_disk: Optional[Union[StrictFloat, StrictInt]] = Field(default=0, description="Min Disk (%)", alias="minDisk")
    max_disk: Optional[Union[StrictFloat, StrictInt]] = Field(default=0, description="Max Disk (%)", alias="maxDisk")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "autoUp", "autoDown", "minCount", "maxCount", "cpuEnabled", "minCpu", "maxCpu", "memoryEnabled", "minMemory", "maxMemory", "diskEnabled", "minDisk", "maxDisk"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateScaleThresholdsRequestScaleThreshold from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateScaleThresholdsRequestScaleThreshold from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "autoUp": obj.get("autoUp") if obj.get("autoUp") is not None else False,
            "autoDown": obj.get("autoDown") if obj.get("autoDown") is not None else False,
            "minCount": obj.get("minCount"),
            "maxCount": obj.get("maxCount"),
            "cpuEnabled": obj.get("cpuEnabled") if obj.get("cpuEnabled") is not None else False,
            "minCpu": obj.get("minCpu") if obj.get("minCpu") is not None else 0,
            "maxCpu": obj.get("maxCpu") if obj.get("maxCpu") is not None else 0,
            "memoryEnabled": obj.get("memoryEnabled") if obj.get("memoryEnabled") is not None else False,
            "minMemory": obj.get("minMemory") if obj.get("minMemory") is not None else 0,
            "maxMemory": obj.get("maxMemory") if obj.get("maxMemory") is not None else 0,
            "diskEnabled": obj.get("diskEnabled") if obj.get("diskEnabled") is not None else False,
            "minDisk": obj.get("minDisk") if obj.get("minDisk") is not None else 0,
            "maxDisk": obj.get("maxDisk") if obj.get("maxDisk") is not None else 0
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


