# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_security_group_rules_request_rule_destination_group import AddSecurityGroupRulesRequestRuleDestinationGroup
from morpheus.models.add_security_group_rules_request_rule_destination_tier import AddSecurityGroupRulesRequestRuleDestinationTier
from morpheus.models.add_security_group_rules_request_rule_source_group import AddSecurityGroupRulesRequestRuleSourceGroup
from morpheus.models.add_security_group_rules_request_rule_source_tier import AddSecurityGroupRulesRequestRuleSourceTier
from typing import Optional, Set
from typing_extensions import Self

class UpdateSecurityGroupRulesRequestRule(BaseModel):
    """
    UpdateSecurityGroupRulesRequestRule
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="A name for the rule")
    direction: Optional[StrictStr] = Field(default='ingress', description="Either `ingress` or `egress`")
    source_type: Optional[StrictStr] = Field(default='cidr', description="Either `cidr`, `group`, `tier`, `all`.", alias="sourceType")
    source: Optional[StrictStr] = Field(default=None, description="CIDR representing the source IP(s) which should receive access. Required for `sourceType`=cidr")
    source_group: Optional[AddSecurityGroupRulesRequestRuleSourceGroup] = Field(default=None, alias="sourceGroup")
    source_tier: Optional[AddSecurityGroupRulesRequestRuleSourceTier] = Field(default=None, alias="sourceTier")
    port_range: Optional[StrictStr] = Field(default=None, description="Either a single value (i.e. 55) or a port range (i.e. 1-65535) for which to open access to the source. Required if customRule is true, otherwise, ignored. ", alias="portRange")
    destination_port_range: Optional[StrictStr] = Field(default=None, description="Either a single value (i.e. 55) or a port range (i.e. 1-65535) for which to open access to the destination. ", alias="destinationPortRange")
    protocol: StrictStr = Field(description="Either tcp, udp, icmp. Required if customRule is true, otherwise, ignored.")
    destination_type: Optional[StrictStr] = Field(default='cidr', description="Either cidr, group, tier, instance.", alias="destinationType")
    destination: Optional[StrictStr] = Field(default=None, description="CIDR representing the destination IP(s) which should receive access. Required for `destinationType`=cidr.")
    destination_group: Optional[AddSecurityGroupRulesRequestRuleDestinationGroup] = Field(default=None, alias="destinationGroup")
    destination_tier: Optional[AddSecurityGroupRulesRequestRuleDestinationTier] = Field(default=None, alias="destinationTier")
    rule_type: StrictStr = Field(description="Either `customRule` or an `instance type` code.", alias="ruleType")
    policy: Optional[StrictStr] = Field(default=None, description="Either `accept` or `deny`.")
    instance_type_id: Optional[StrictInt] = Field(default=None, description="The id of an Instance Type. If specified, the source CIDR will have access to all ports exposed by the particular instance in the cloud, app, or instance. Required if customRule is false, otherwise ignored. ", alias="instanceTypeId")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "direction", "sourceType", "source", "sourceGroup", "sourceTier", "portRange", "destinationPortRange", "protocol", "destinationType", "destination", "destinationGroup", "destinationTier", "ruleType", "policy", "instanceTypeId"]

    @field_validator('direction')
    def direction_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ingress', 'egress']):
            raise ValueError("must be one of enum values ('ingress', 'egress')")
        return value

    @field_validator('source_type')
    def source_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['cidr', 'group', 'tier', 'all']):
            raise ValueError("must be one of enum values ('cidr', 'group', 'tier', 'all')")
        return value

    @field_validator('protocol')
    def protocol_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['tcp', 'udp', 'icmp']):
            raise ValueError("must be one of enum values ('tcp', 'udp', 'icmp')")
        return value

    @field_validator('destination_type')
    def destination_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['cidr', 'group', 'tier', 'instance']):
            raise ValueError("must be one of enum values ('cidr', 'group', 'tier', 'instance')")
        return value

    @field_validator('policy')
    def policy_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['accept', 'deny']):
            raise ValueError("must be one of enum values ('accept', 'deny')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateSecurityGroupRulesRequestRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of source_group
        if self.source_group:
            _dict['sourceGroup'] = self.source_group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of source_tier
        if self.source_tier:
            _dict['sourceTier'] = self.source_tier.to_dict()
        # override the default output from pydantic by calling `to_dict()` of destination_group
        if self.destination_group:
            _dict['destinationGroup'] = self.destination_group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of destination_tier
        if self.destination_tier:
            _dict['destinationTier'] = self.destination_tier.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateSecurityGroupRulesRequestRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "direction": obj.get("direction") if obj.get("direction") is not None else 'ingress',
            "sourceType": obj.get("sourceType") if obj.get("sourceType") is not None else 'cidr',
            "source": obj.get("source"),
            "sourceGroup": AddSecurityGroupRulesRequestRuleSourceGroup.from_dict(obj["sourceGroup"]) if obj.get("sourceGroup") is not None else None,
            "sourceTier": AddSecurityGroupRulesRequestRuleSourceTier.from_dict(obj["sourceTier"]) if obj.get("sourceTier") is not None else None,
            "portRange": obj.get("portRange"),
            "destinationPortRange": obj.get("destinationPortRange"),
            "protocol": obj.get("protocol"),
            "destinationType": obj.get("destinationType") if obj.get("destinationType") is not None else 'cidr',
            "destination": obj.get("destination"),
            "destinationGroup": AddSecurityGroupRulesRequestRuleDestinationGroup.from_dict(obj["destinationGroup"]) if obj.get("destinationGroup") is not None else None,
            "destinationTier": AddSecurityGroupRulesRequestRuleDestinationTier.from_dict(obj["destinationTier"]) if obj.get("destinationTier") is not None else None,
            "ruleType": obj.get("ruleType") if obj.get("ruleType") is not None else 'customRule',
            "policy": obj.get("policy"),
            "instanceTypeId": obj.get("instanceTypeId")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


