# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_vdi_pools200_response_all_of_vdi_pools_inner_config import ListVDIPools200ResponseAllOfVdiPoolsInnerConfig
from morpheus.models.list_vdi_pools200_response_all_of_vdi_pools_inner_owner import ListVDIPools200ResponseAllOfVdiPoolsInnerOwner
from typing import Optional, Set
from typing_extensions import Self

class VdiPool(BaseModel):
    """
    VdiPool
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    min_idle: Optional[StrictInt] = Field(default=None, alias="minIdle")
    max_idle: Optional[StrictInt] = Field(default=None, alias="maxIdle")
    initial_pool_size: Optional[StrictInt] = Field(default=None, alias="initialPoolSize")
    max_pool_size: Optional[StrictInt] = Field(default=None, alias="maxPoolSize")
    allocation_timeout_minutes: Optional[StrictInt] = Field(default=None, alias="allocationTimeoutMinutes")
    persistent_user: Optional[StrictBool] = Field(default=None, alias="persistentUser")
    recyclable: Optional[StrictBool] = None
    enabled: Optional[StrictBool] = None
    auto_create_local_user_on_reservation: Optional[StrictBool] = Field(default=None, alias="autoCreateLocalUserOnReservation")
    allow_hypervisor_console: Optional[StrictBool] = Field(default=None, alias="allowHypervisorConsole")
    allow_copy: Optional[StrictBool] = Field(default=None, alias="allowCopy")
    allow_printer: Optional[StrictBool] = Field(default=None, alias="allowPrinter")
    allow_fileshare: Optional[StrictBool] = Field(default=None, alias="allowFileshare")
    guest_console_jump_host: Optional[StrictStr] = Field(default=None, alias="guestConsoleJumpHost")
    guest_console_jump_port: Optional[StrictStr] = Field(default=None, alias="guestConsoleJumpPort")
    guest_console_jump_username: Optional[StrictStr] = Field(default=None, alias="guestConsoleJumpUsername")
    guest_console_jump_password: Optional[StrictStr] = Field(default=None, alias="guestConsoleJumpPassword")
    guest_console_jump_keypair: Optional[StrictStr] = Field(default=None, alias="guestConsoleJumpKeypair")
    gateway: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    icon_path: Optional[StrictStr] = Field(default=None, alias="iconPath")
    logo: Optional[StrictStr] = None
    apps: Optional[List[GetAlerts200ResponseAllOfCheckGroupsInnerInstance]] = None
    owner: Optional[ListVDIPools200ResponseAllOfVdiPoolsInnerOwner] = None
    config: Optional[ListVDIPools200ResponseAllOfVdiPoolsInnerConfig] = None
    group: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    cloud: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    used_count: Optional[StrictInt] = Field(default=None, alias="usedCount")
    reserved_count: Optional[StrictInt] = Field(default=None, alias="reservedCount")
    preparing_count: Optional[StrictInt] = Field(default=None, alias="preparingCount")
    idle_count: Optional[StrictInt] = Field(default=None, alias="idleCount")
    status: Optional[StrictStr] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "description", "minIdle", "maxIdle", "initialPoolSize", "maxPoolSize", "allocationTimeoutMinutes", "persistentUser", "recyclable", "enabled", "autoCreateLocalUserOnReservation", "allowHypervisorConsole", "allowCopy", "allowPrinter", "allowFileshare", "guestConsoleJumpHost", "guestConsoleJumpPort", "guestConsoleJumpUsername", "guestConsoleJumpPassword", "guestConsoleJumpKeypair", "gateway", "iconPath", "logo", "apps", "owner", "config", "group", "cloud", "usedCount", "reservedCount", "preparingCount", "idleCount", "status", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VdiPool from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of gateway
        if self.gateway:
            _dict['gateway'] = self.gateway.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in apps (list)
        _items = []
        if self.apps:
            for _item_apps in self.apps:
                if _item_apps:
                    _items.append(_item_apps.to_dict())
            _dict['apps'] = _items
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of group
        if self.group:
            _dict['group'] = self.group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cloud
        if self.cloud:
            _dict['cloud'] = self.cloud.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if persistent_user (nullable) is None
        # and model_fields_set contains the field
        if self.persistent_user is None and "persistent_user" in self.model_fields_set:
            _dict['persistentUser'] = None

        # set to None if recyclable (nullable) is None
        # and model_fields_set contains the field
        if self.recyclable is None and "recyclable" in self.model_fields_set:
            _dict['recyclable'] = None

        # set to None if allow_hypervisor_console (nullable) is None
        # and model_fields_set contains the field
        if self.allow_hypervisor_console is None and "allow_hypervisor_console" in self.model_fields_set:
            _dict['allowHypervisorConsole'] = None

        # set to None if allow_copy (nullable) is None
        # and model_fields_set contains the field
        if self.allow_copy is None and "allow_copy" in self.model_fields_set:
            _dict['allowCopy'] = None

        # set to None if allow_printer (nullable) is None
        # and model_fields_set contains the field
        if self.allow_printer is None and "allow_printer" in self.model_fields_set:
            _dict['allowPrinter'] = None

        # set to None if allow_fileshare (nullable) is None
        # and model_fields_set contains the field
        if self.allow_fileshare is None and "allow_fileshare" in self.model_fields_set:
            _dict['allowFileshare'] = None

        # set to None if guest_console_jump_host (nullable) is None
        # and model_fields_set contains the field
        if self.guest_console_jump_host is None and "guest_console_jump_host" in self.model_fields_set:
            _dict['guestConsoleJumpHost'] = None

        # set to None if guest_console_jump_port (nullable) is None
        # and model_fields_set contains the field
        if self.guest_console_jump_port is None and "guest_console_jump_port" in self.model_fields_set:
            _dict['guestConsoleJumpPort'] = None

        # set to None if guest_console_jump_username (nullable) is None
        # and model_fields_set contains the field
        if self.guest_console_jump_username is None and "guest_console_jump_username" in self.model_fields_set:
            _dict['guestConsoleJumpUsername'] = None

        # set to None if guest_console_jump_password (nullable) is None
        # and model_fields_set contains the field
        if self.guest_console_jump_password is None and "guest_console_jump_password" in self.model_fields_set:
            _dict['guestConsoleJumpPassword'] = None

        # set to None if guest_console_jump_keypair (nullable) is None
        # and model_fields_set contains the field
        if self.guest_console_jump_keypair is None and "guest_console_jump_keypair" in self.model_fields_set:
            _dict['guestConsoleJumpKeypair'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VdiPool from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "minIdle": obj.get("minIdle"),
            "maxIdle": obj.get("maxIdle"),
            "initialPoolSize": obj.get("initialPoolSize"),
            "maxPoolSize": obj.get("maxPoolSize"),
            "allocationTimeoutMinutes": obj.get("allocationTimeoutMinutes"),
            "persistentUser": obj.get("persistentUser"),
            "recyclable": obj.get("recyclable"),
            "enabled": obj.get("enabled"),
            "autoCreateLocalUserOnReservation": obj.get("autoCreateLocalUserOnReservation"),
            "allowHypervisorConsole": obj.get("allowHypervisorConsole"),
            "allowCopy": obj.get("allowCopy"),
            "allowPrinter": obj.get("allowPrinter"),
            "allowFileshare": obj.get("allowFileshare"),
            "guestConsoleJumpHost": obj.get("guestConsoleJumpHost"),
            "guestConsoleJumpPort": obj.get("guestConsoleJumpPort"),
            "guestConsoleJumpUsername": obj.get("guestConsoleJumpUsername"),
            "guestConsoleJumpPassword": obj.get("guestConsoleJumpPassword"),
            "guestConsoleJumpKeypair": obj.get("guestConsoleJumpKeypair"),
            "gateway": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["gateway"]) if obj.get("gateway") is not None else None,
            "iconPath": obj.get("iconPath"),
            "logo": obj.get("logo"),
            "apps": [GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(_item) for _item in obj["apps"]] if obj.get("apps") is not None else None,
            "owner": ListVDIPools200ResponseAllOfVdiPoolsInnerOwner.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "config": ListVDIPools200ResponseAllOfVdiPoolsInnerConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "group": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["group"]) if obj.get("group") is not None else None,
            "cloud": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["cloud"]) if obj.get("cloud") is not None else None,
            "usedCount": obj.get("usedCount"),
            "reservedCount": obj.get("reservedCount"),
            "preparingCount": obj.get("preparingCount"),
            "idleCount": obj.get("idleCount"),
            "status": obj.get("status"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


