# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from morpheus.models.list_virtual_image_locations200_response_all_of_locations_inner_virtual_image import ListVirtualImageLocations200ResponseAllOfLocationsInnerVirtualImage
from typing import Optional, Set
from typing_extensions import Self

class VirtualImageLocation(BaseModel):
    """
    VirtualImageLocation
    """ # noqa: E501
    id: Optional[StrictInt] = None
    cloud: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = None
    code: Optional[StrictStr] = None
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    external_disk_id: Optional[StrictStr] = Field(default=None, alias="externalDiskId")
    remote_path: Optional[StrictStr] = Field(default=None, alias="remotePath")
    image_path: Optional[StrictStr] = Field(default=None, alias="imagePath")
    image_name: Optional[StrictStr] = Field(default=None, alias="imageName")
    image_region: Optional[StrictStr] = Field(default=None, alias="imageRegion")
    image_folder: Optional[StrictStr] = Field(default=None, alias="imageFolder")
    ref_type: Optional[StrictStr] = Field(default=None, alias="refType")
    ref_id: Optional[StrictInt] = Field(default=None, alias="refId")
    node_ref_type: Optional[StrictStr] = Field(default=None, alias="nodeRefType")
    node_ref_id: Optional[StrictStr] = Field(default=None, alias="nodeRefId")
    sub_ref_type: Optional[StrictStr] = Field(default=None, alias="subRefType")
    sub_ref_id: Optional[StrictStr] = Field(default=None, alias="subRefId")
    is_public: Optional[StrictBool] = Field(default=None, alias="isPublic")
    system_image: Optional[StrictBool] = Field(default=None, alias="systemImage")
    disk_index: Optional[StrictInt] = Field(default=None, alias="diskIndex")
    price_plan: Optional[StrictStr] = Field(default=None, alias="pricePlan")
    volumes: Optional[List[Dict[str, Any]]] = None
    storage_controllers: Optional[List[Dict[str, Any]]] = Field(default=None, alias="storageControllers")
    network_interfaces: Optional[List[Dict[str, Any]]] = Field(default=None, alias="networkInterfaces")
    virtual_image: Optional[ListVirtualImageLocations200ResponseAllOfLocationsInnerVirtualImage] = Field(default=None, alias="virtualImage")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "cloud", "code", "internalId", "externalId", "externalDiskId", "remotePath", "imagePath", "imageName", "imageRegion", "imageFolder", "refType", "refId", "nodeRefType", "nodeRefId", "subRefType", "subRefId", "isPublic", "systemImage", "diskIndex", "pricePlan", "volumes", "storageControllers", "networkInterfaces", "virtualImage"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VirtualImageLocation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cloud
        if self.cloud:
            _dict['cloud'] = self.cloud.to_dict()
        # override the default output from pydantic by calling `to_dict()` of virtual_image
        if self.virtual_image:
            _dict['virtualImage'] = self.virtual_image.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_id is None and "internal_id" in self.model_fields_set:
            _dict['internalId'] = None

        # set to None if remote_path (nullable) is None
        # and model_fields_set contains the field
        if self.remote_path is None and "remote_path" in self.model_fields_set:
            _dict['remotePath'] = None

        # set to None if image_path (nullable) is None
        # and model_fields_set contains the field
        if self.image_path is None and "image_path" in self.model_fields_set:
            _dict['imagePath'] = None

        # set to None if image_folder (nullable) is None
        # and model_fields_set contains the field
        if self.image_folder is None and "image_folder" in self.model_fields_set:
            _dict['imageFolder'] = None

        # set to None if node_ref_type (nullable) is None
        # and model_fields_set contains the field
        if self.node_ref_type is None and "node_ref_type" in self.model_fields_set:
            _dict['nodeRefType'] = None

        # set to None if node_ref_id (nullable) is None
        # and model_fields_set contains the field
        if self.node_ref_id is None and "node_ref_id" in self.model_fields_set:
            _dict['nodeRefId'] = None

        # set to None if sub_ref_type (nullable) is None
        # and model_fields_set contains the field
        if self.sub_ref_type is None and "sub_ref_type" in self.model_fields_set:
            _dict['subRefType'] = None

        # set to None if sub_ref_id (nullable) is None
        # and model_fields_set contains the field
        if self.sub_ref_id is None and "sub_ref_id" in self.model_fields_set:
            _dict['subRefId'] = None

        # set to None if price_plan (nullable) is None
        # and model_fields_set contains the field
        if self.price_plan is None and "price_plan" in self.model_fields_set:
            _dict['pricePlan'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VirtualImageLocation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "cloud": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["cloud"]) if obj.get("cloud") is not None else None,
            "code": obj.get("code"),
            "internalId": obj.get("internalId"),
            "externalId": obj.get("externalId"),
            "externalDiskId": obj.get("externalDiskId"),
            "remotePath": obj.get("remotePath"),
            "imagePath": obj.get("imagePath"),
            "imageName": obj.get("imageName"),
            "imageRegion": obj.get("imageRegion"),
            "imageFolder": obj.get("imageFolder"),
            "refType": obj.get("refType"),
            "refId": obj.get("refId"),
            "nodeRefType": obj.get("nodeRefType"),
            "nodeRefId": obj.get("nodeRefId"),
            "subRefType": obj.get("subRefType"),
            "subRefId": obj.get("subRefId"),
            "isPublic": obj.get("isPublic"),
            "systemImage": obj.get("systemImage"),
            "diskIndex": obj.get("diskIndex"),
            "pricePlan": obj.get("pricePlan"),
            "volumes": obj.get("volumes"),
            "storageControllers": obj.get("storageControllers"),
            "networkInterfaces": obj.get("networkInterfaces"),
            "virtualImage": ListVirtualImageLocations200ResponseAllOfLocationsInnerVirtualImage.from_dict(obj["virtualImage"]) if obj.get("virtualImage") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


