# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_clouds200_response_all_of_zones_inner_config_any_of_network_server import ListClouds200ResponseAllOfZonesInnerConfigAnyOfNetworkServer
from typing import Optional, Set
from typing_extensions import Self

class ZoneAwsConfig(BaseModel):
    """
    ZoneAwsConfig
    """ # noqa: E501
    endpoint: Optional[StrictStr] = None
    access_key: Optional[StrictStr] = Field(default=None, alias="accessKey")
    secret_key: Optional[StrictStr] = Field(default=None, alias="secretKey")
    use_host_credentials: Optional[StrictStr] = Field(default=None, alias="useHostCredentials")
    sts_assume_role: Optional[StrictStr] = Field(default=None, alias="stsAssumeRole")
    is_vpc: Optional[StrictStr] = Field(default=None, alias="isVpc")
    vpc: Optional[StrictStr] = None
    image_store_id: Optional[StrictStr] = Field(default=None, alias="imageStoreId")
    ebs_encryption: Optional[StrictStr] = Field(default=None, alias="ebsEncryption")
    costing_report: Optional[StrictStr] = Field(default=None, alias="costingReport")
    costing_folder: Optional[StrictStr] = Field(default=None, alias="costingFolder")
    costing_bucket: Optional[StrictStr] = Field(default=None, alias="costingBucket")
    costing_bucket_name: Optional[StrictStr] = Field(default=None, alias="costingBucketName")
    costing_region: Optional[StrictStr] = Field(default=None, alias="costingRegion")
    costing_access_key: Optional[StrictStr] = Field(default=None, alias="costingAccessKey")
    costing_secret_key: Optional[StrictStr] = Field(default=None, alias="costingSecretKey")
    costing_report_name: Optional[StrictStr] = Field(default=None, alias="costingReportName")
    appliance_url: Optional[StrictStr] = Field(default=None, alias="applianceUrl")
    datacenter_name: Optional[StrictStr] = Field(default=None, alias="datacenterName")
    network_server_id: Optional[StrictStr] = Field(default=None, alias="networkServer.id")
    network_server: Optional[ListClouds200ResponseAllOfZonesInnerConfigAnyOfNetworkServer] = Field(default=None, alias="networkServer")
    security_server: Optional[StrictStr] = Field(default=None, alias="securityServer")
    certificate_provider: Optional[StrictStr] = Field(default=None, alias="certificateProvider")
    backup_mode: Optional[StrictStr] = Field(default=None, alias="backupMode")
    replication_mode: Optional[StrictStr] = Field(default=None, alias="replicationMode")
    dns_integration_id: Optional[StrictStr] = Field(default=None, alias="dnsIntegrationId")
    service_registry_id: Optional[StrictStr] = Field(default=None, alias="serviceRegistryId")
    config_management_id: Optional[StrictStr] = Field(default=None, alias="configManagementId")
    config_cmdb_discovery: Optional[StrictBool] = Field(default=None, alias="configCmdbDiscovery")
    secret_key_hash: Optional[StrictStr] = Field(default=None, alias="secretKeyHash")
    costing_secret_key_hash: Optional[StrictStr] = Field(default=None, alias="costingSecretKeyHash")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["endpoint", "accessKey", "secretKey", "useHostCredentials", "stsAssumeRole", "isVpc", "vpc", "imageStoreId", "ebsEncryption", "costingReport", "costingFolder", "costingBucket", "costingBucketName", "costingRegion", "costingAccessKey", "costingSecretKey", "costingReportName", "applianceUrl", "datacenterName", "networkServer.id", "networkServer", "securityServer", "certificateProvider", "backupMode", "replicationMode", "dnsIntegrationId", "serviceRegistryId", "configManagementId", "configCmdbDiscovery", "secretKeyHash", "costingSecretKeyHash"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ZoneAwsConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of network_server
        if self.network_server:
            _dict['networkServer'] = self.network_server.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if costing_secret_key (nullable) is None
        # and model_fields_set contains the field
        if self.costing_secret_key is None and "costing_secret_key" in self.model_fields_set:
            _dict['costingSecretKey'] = None

        # set to None if security_server (nullable) is None
        # and model_fields_set contains the field
        if self.security_server is None and "security_server" in self.model_fields_set:
            _dict['securityServer'] = None

        # set to None if costing_secret_key_hash (nullable) is None
        # and model_fields_set contains the field
        if self.costing_secret_key_hash is None and "costing_secret_key_hash" in self.model_fields_set:
            _dict['costingSecretKeyHash'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ZoneAwsConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "endpoint": obj.get("endpoint"),
            "accessKey": obj.get("accessKey"),
            "secretKey": obj.get("secretKey"),
            "useHostCredentials": obj.get("useHostCredentials"),
            "stsAssumeRole": obj.get("stsAssumeRole"),
            "isVpc": obj.get("isVpc"),
            "vpc": obj.get("vpc"),
            "imageStoreId": obj.get("imageStoreId"),
            "ebsEncryption": obj.get("ebsEncryption"),
            "costingReport": obj.get("costingReport"),
            "costingFolder": obj.get("costingFolder"),
            "costingBucket": obj.get("costingBucket"),
            "costingBucketName": obj.get("costingBucketName"),
            "costingRegion": obj.get("costingRegion"),
            "costingAccessKey": obj.get("costingAccessKey"),
            "costingSecretKey": obj.get("costingSecretKey"),
            "costingReportName": obj.get("costingReportName"),
            "applianceUrl": obj.get("applianceUrl"),
            "datacenterName": obj.get("datacenterName"),
            "networkServer.id": obj.get("networkServer.id"),
            "networkServer": ListClouds200ResponseAllOfZonesInnerConfigAnyOfNetworkServer.from_dict(obj["networkServer"]) if obj.get("networkServer") is not None else None,
            "securityServer": obj.get("securityServer"),
            "certificateProvider": obj.get("certificateProvider"),
            "backupMode": obj.get("backupMode"),
            "replicationMode": obj.get("replicationMode"),
            "dnsIntegrationId": obj.get("dnsIntegrationId"),
            "serviceRegistryId": obj.get("serviceRegistryId"),
            "configManagementId": obj.get("configManagementId"),
            "configCmdbDiscovery": obj.get("configCmdbDiscovery"),
            "secretKeyHash": obj.get("secretKeyHash"),
            "costingSecretKeyHash": obj.get("costingSecretKeyHash")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


