# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_instance_service_plans200_response_plans_inner_auto_options_inner import ListInstanceServicePlans200ResponsePlansInnerAutoOptionsInner
from morpheus.models.zone_network_options_network_subnets_inner import ZoneNetworkOptionsNetworkSubnetsInner
from morpheus.models.zone_network_options_network_types_inner import ZoneNetworkOptionsNetworkTypesInner
from morpheus.models.zone_network_options_networks_inner import ZoneNetworkOptionsNetworksInner
from typing import Optional, Set
from typing_extensions import Self

class ZoneNetworkOptions(BaseModel):
    """
    ZoneNetworkOptions
    """ # noqa: E501
    networks: Optional[List[ZoneNetworkOptionsNetworksInner]] = None
    network_groups: Optional[List[ListInstanceServicePlans200ResponsePlansInnerAutoOptionsInner]] = Field(default=None, alias="networkGroups")
    network_types: Optional[List[ZoneNetworkOptionsNetworkTypesInner]] = Field(default=None, alias="networkTypes")
    network_subnets: Optional[List[ZoneNetworkOptionsNetworkSubnetsInner]] = Field(default=None, alias="networkSubnets")
    has_networks: Optional[StrictBool] = Field(default=None, alias="hasNetworks")
    max_networks: Optional[StrictInt] = Field(default=None, alias="maxNetworks")
    enable_network_type_selection: Optional[StrictStr] = Field(default=None, alias="enableNetworkTypeSelection")
    supports_network_selection: Optional[StrictBool] = Field(default=None, alias="supportsNetworkSelection")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["networks", "networkGroups", "networkTypes", "networkSubnets", "hasNetworks", "maxNetworks", "enableNetworkTypeSelection", "supportsNetworkSelection"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ZoneNetworkOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in networks (list)
        _items = []
        if self.networks:
            for _item_networks in self.networks:
                if _item_networks:
                    _items.append(_item_networks.to_dict())
            _dict['networks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in network_groups (list)
        _items = []
        if self.network_groups:
            for _item_network_groups in self.network_groups:
                if _item_network_groups:
                    _items.append(_item_network_groups.to_dict())
            _dict['networkGroups'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in network_types (list)
        _items = []
        if self.network_types:
            for _item_network_types in self.network_types:
                if _item_network_types:
                    _items.append(_item_network_types.to_dict())
            _dict['networkTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in network_subnets (list)
        _items = []
        if self.network_subnets:
            for _item_network_subnets in self.network_subnets:
                if _item_network_subnets:
                    _items.append(_item_network_subnets.to_dict())
            _dict['networkSubnets'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if has_networks (nullable) is None
        # and model_fields_set contains the field
        if self.has_networks is None and "has_networks" in self.model_fields_set:
            _dict['hasNetworks'] = None

        # set to None if max_networks (nullable) is None
        # and model_fields_set contains the field
        if self.max_networks is None and "max_networks" in self.model_fields_set:
            _dict['maxNetworks'] = None

        # set to None if enable_network_type_selection (nullable) is None
        # and model_fields_set contains the field
        if self.enable_network_type_selection is None and "enable_network_type_selection" in self.model_fields_set:
            _dict['enableNetworkTypeSelection'] = None

        # set to None if supports_network_selection (nullable) is None
        # and model_fields_set contains the field
        if self.supports_network_selection is None and "supports_network_selection" in self.model_fields_set:
            _dict['supportsNetworkSelection'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ZoneNetworkOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "networks": [ZoneNetworkOptionsNetworksInner.from_dict(_item) for _item in obj["networks"]] if obj.get("networks") is not None else None,
            "networkGroups": [ListInstanceServicePlans200ResponsePlansInnerAutoOptionsInner.from_dict(_item) for _item in obj["networkGroups"]] if obj.get("networkGroups") is not None else None,
            "networkTypes": [ZoneNetworkOptionsNetworkTypesInner.from_dict(_item) for _item in obj["networkTypes"]] if obj.get("networkTypes") is not None else None,
            "networkSubnets": [ZoneNetworkOptionsNetworkSubnetsInner.from_dict(_item) for _item in obj["networkSubnets"]] if obj.get("networkSubnets") is not None else None,
            "hasNetworks": obj.get("hasNetworks"),
            "maxNetworks": obj.get("maxNetworks"),
            "enableNetworkTypeSelection": obj.get("enableNetworkTypeSelection"),
            "supportsNetworkSelection": obj.get("supportsNetworkSelection")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


