# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Optional
from typing_extensions import Annotated
from morpheus.models.get_invoice_line_items200_response import GetInvoiceLineItems200Response
from morpheus.models.get_invoices200_response import GetInvoices200Response
from morpheus.models.list_invoice_line_items200_response import ListInvoiceLineItems200Response
from morpheus.models.list_invoices200_response import ListInvoices200Response
from morpheus.models.update_invoices200_response import UpdateInvoices200Response
from morpheus.models.update_invoices_request import UpdateInvoicesRequest

from morpheus.api_client import ApiClient, RequestSerialized
from morpheus.api_response import ApiResponse
from morpheus.rest import RESTResponseType


class InvoicesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_invoice_line_items(
        self,
        id: Annotated[StrictInt, Field(description="Morpheus ID of the Object being referenced")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetInvoiceLineItems200Response:
        """Get a Specific Invoice Line Item

        Get details about a specific invoice line item.

        :param id: Morpheus ID of the Object being referenced (required)
        :type id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_invoice_line_items_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetInvoiceLineItems200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_invoice_line_items_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="Morpheus ID of the Object being referenced")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetInvoiceLineItems200Response]:
        """Get a Specific Invoice Line Item

        Get details about a specific invoice line item.

        :param id: Morpheus ID of the Object being referenced (required)
        :type id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_invoice_line_items_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetInvoiceLineItems200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_invoice_line_items_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="Morpheus ID of the Object being referenced")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a Specific Invoice Line Item

        Get details about a specific invoice line item.

        :param id: Morpheus ID of the Object being referenced (required)
        :type id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_invoice_line_items_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetInvoiceLineItems200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_invoice_line_items_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/invoice-line-items/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_invoices(
        self,
        id: Annotated[StrictInt, Field(description="Morpheus ID of the Object being referenced")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetInvoices200Response:
        """Get a Specific Invoice

        Get details about a specific invoice.

        :param id: Morpheus ID of the Object being referenced (required)
        :type id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_invoices_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetInvoices200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_invoices_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="Morpheus ID of the Object being referenced")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetInvoices200Response]:
        """Get a Specific Invoice

        Get details about a specific invoice.

        :param id: Morpheus ID of the Object being referenced (required)
        :type id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_invoices_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetInvoices200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_invoices_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="Morpheus ID of the Object being referenced")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a Specific Invoice

        Get details about a specific invoice.

        :param id: Morpheus ID of the Object being referenced (required)
        :type id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_invoices_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetInvoices200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_invoices_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/invoices/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_invoice_line_items(
        self,
        max: Annotated[Optional[StrictInt], Field(description="Maximum number of records to return")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Offset records, the number of records to skip, for paginating requests")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order, the name of the property to sort by")] = None,
        direction: Annotated[Optional[StrictStr], Field(description="Sort direction, use 'desc' to reverse sort")] = None,
        phrase: Annotated[Optional[StrictStr], Field(description="Search phrase for partial matches on name or description")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Filter by name")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        period: Annotated[Optional[StrictStr], Field(description="Only return records for period that matches with the specified value. This is an alternative to using startDate/endDate. Format is YYYY or YYYYMM. ")] = None,
        ref_type: Annotated[Optional[StrictStr], Field(description="If specified will return an exact match on refType. ")] = None,
        ref_id: Annotated[Optional[StrictInt], Field(description="If specified will return an exact match on refId")] = None,
        zone_id: Annotated[Optional[StrictInt], Field(description="The Zone ID for Filtering")] = None,
        site_id: Annotated[Optional[StrictInt], Field(description="The Site ID for Filtering")] = None,
        instance_id: Annotated[Optional[StrictInt], Field(description="The Instance ID for Filtering")] = None,
        container_id: Annotated[Optional[StrictInt], Field(description="The Container ID for Filtering")] = None,
        server_id: Annotated[Optional[StrictInt], Field(description="The Server ID for Filtering")] = None,
        user_id: Annotated[Optional[StrictInt], Field(description="Filter by User ID")] = None,
        project_id: Annotated[Optional[StrictInt], Field(description="The Project ID for Filtering")] = None,
        active: Annotated[Optional[StrictBool], Field(description="True or False flag for Active")] = None,
        account_id: Annotated[Optional[StrictInt], Field(description="Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.")] = None,
        include_totals: Annotated[Optional[StrictBool], Field(description="Pass true to include the summed totals (cost/price values) for all the invoices found in the query. The returned property is called `invoiceTotals`. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListInvoiceLineItems200Response:
        """List All Invoice Line Items

        This endpoint retrieves a list of all invoice line items for the specified parameters.

        :param max: Maximum number of records to return
        :type max: int
        :param offset: Offset records, the number of records to skip, for paginating requests
        :type offset: int
        :param sort: Sort order, the name of the property to sort by
        :type sort: str
        :param direction: Sort direction, use 'desc' to reverse sort
        :type direction: str
        :param phrase: Search phrase for partial matches on name or description
        :type phrase: str
        :param name: Filter by name
        :type name: str
        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param period: Only return records for period that matches with the specified value. This is an alternative to using startDate/endDate. Format is YYYY or YYYYMM. 
        :type period: str
        :param ref_type: If specified will return an exact match on refType. 
        :type ref_type: str
        :param ref_id: If specified will return an exact match on refId
        :type ref_id: int
        :param zone_id: The Zone ID for Filtering
        :type zone_id: int
        :param site_id: The Site ID for Filtering
        :type site_id: int
        :param instance_id: The Instance ID for Filtering
        :type instance_id: int
        :param container_id: The Container ID for Filtering
        :type container_id: int
        :param server_id: The Server ID for Filtering
        :type server_id: int
        :param user_id: Filter by User ID
        :type user_id: int
        :param project_id: The Project ID for Filtering
        :type project_id: int
        :param active: True or False flag for Active
        :type active: bool
        :param account_id: Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.
        :type account_id: int
        :param include_totals: Pass true to include the summed totals (cost/price values) for all the invoices found in the query. The returned property is called `invoiceTotals`. 
        :type include_totals: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_invoice_line_items_serialize(
            max=max,
            offset=offset,
            sort=sort,
            direction=direction,
            phrase=phrase,
            name=name,
            start_date=start_date,
            end_date=end_date,
            period=period,
            ref_type=ref_type,
            ref_id=ref_id,
            zone_id=zone_id,
            site_id=site_id,
            instance_id=instance_id,
            container_id=container_id,
            server_id=server_id,
            user_id=user_id,
            project_id=project_id,
            active=active,
            account_id=account_id,
            include_totals=include_totals,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListInvoiceLineItems200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_invoice_line_items_with_http_info(
        self,
        max: Annotated[Optional[StrictInt], Field(description="Maximum number of records to return")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Offset records, the number of records to skip, for paginating requests")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order, the name of the property to sort by")] = None,
        direction: Annotated[Optional[StrictStr], Field(description="Sort direction, use 'desc' to reverse sort")] = None,
        phrase: Annotated[Optional[StrictStr], Field(description="Search phrase for partial matches on name or description")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Filter by name")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        period: Annotated[Optional[StrictStr], Field(description="Only return records for period that matches with the specified value. This is an alternative to using startDate/endDate. Format is YYYY or YYYYMM. ")] = None,
        ref_type: Annotated[Optional[StrictStr], Field(description="If specified will return an exact match on refType. ")] = None,
        ref_id: Annotated[Optional[StrictInt], Field(description="If specified will return an exact match on refId")] = None,
        zone_id: Annotated[Optional[StrictInt], Field(description="The Zone ID for Filtering")] = None,
        site_id: Annotated[Optional[StrictInt], Field(description="The Site ID for Filtering")] = None,
        instance_id: Annotated[Optional[StrictInt], Field(description="The Instance ID for Filtering")] = None,
        container_id: Annotated[Optional[StrictInt], Field(description="The Container ID for Filtering")] = None,
        server_id: Annotated[Optional[StrictInt], Field(description="The Server ID for Filtering")] = None,
        user_id: Annotated[Optional[StrictInt], Field(description="Filter by User ID")] = None,
        project_id: Annotated[Optional[StrictInt], Field(description="The Project ID for Filtering")] = None,
        active: Annotated[Optional[StrictBool], Field(description="True or False flag for Active")] = None,
        account_id: Annotated[Optional[StrictInt], Field(description="Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.")] = None,
        include_totals: Annotated[Optional[StrictBool], Field(description="Pass true to include the summed totals (cost/price values) for all the invoices found in the query. The returned property is called `invoiceTotals`. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListInvoiceLineItems200Response]:
        """List All Invoice Line Items

        This endpoint retrieves a list of all invoice line items for the specified parameters.

        :param max: Maximum number of records to return
        :type max: int
        :param offset: Offset records, the number of records to skip, for paginating requests
        :type offset: int
        :param sort: Sort order, the name of the property to sort by
        :type sort: str
        :param direction: Sort direction, use 'desc' to reverse sort
        :type direction: str
        :param phrase: Search phrase for partial matches on name or description
        :type phrase: str
        :param name: Filter by name
        :type name: str
        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param period: Only return records for period that matches with the specified value. This is an alternative to using startDate/endDate. Format is YYYY or YYYYMM. 
        :type period: str
        :param ref_type: If specified will return an exact match on refType. 
        :type ref_type: str
        :param ref_id: If specified will return an exact match on refId
        :type ref_id: int
        :param zone_id: The Zone ID for Filtering
        :type zone_id: int
        :param site_id: The Site ID for Filtering
        :type site_id: int
        :param instance_id: The Instance ID for Filtering
        :type instance_id: int
        :param container_id: The Container ID for Filtering
        :type container_id: int
        :param server_id: The Server ID for Filtering
        :type server_id: int
        :param user_id: Filter by User ID
        :type user_id: int
        :param project_id: The Project ID for Filtering
        :type project_id: int
        :param active: True or False flag for Active
        :type active: bool
        :param account_id: Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.
        :type account_id: int
        :param include_totals: Pass true to include the summed totals (cost/price values) for all the invoices found in the query. The returned property is called `invoiceTotals`. 
        :type include_totals: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_invoice_line_items_serialize(
            max=max,
            offset=offset,
            sort=sort,
            direction=direction,
            phrase=phrase,
            name=name,
            start_date=start_date,
            end_date=end_date,
            period=period,
            ref_type=ref_type,
            ref_id=ref_id,
            zone_id=zone_id,
            site_id=site_id,
            instance_id=instance_id,
            container_id=container_id,
            server_id=server_id,
            user_id=user_id,
            project_id=project_id,
            active=active,
            account_id=account_id,
            include_totals=include_totals,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListInvoiceLineItems200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_invoice_line_items_without_preload_content(
        self,
        max: Annotated[Optional[StrictInt], Field(description="Maximum number of records to return")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Offset records, the number of records to skip, for paginating requests")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order, the name of the property to sort by")] = None,
        direction: Annotated[Optional[StrictStr], Field(description="Sort direction, use 'desc' to reverse sort")] = None,
        phrase: Annotated[Optional[StrictStr], Field(description="Search phrase for partial matches on name or description")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Filter by name")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        period: Annotated[Optional[StrictStr], Field(description="Only return records for period that matches with the specified value. This is an alternative to using startDate/endDate. Format is YYYY or YYYYMM. ")] = None,
        ref_type: Annotated[Optional[StrictStr], Field(description="If specified will return an exact match on refType. ")] = None,
        ref_id: Annotated[Optional[StrictInt], Field(description="If specified will return an exact match on refId")] = None,
        zone_id: Annotated[Optional[StrictInt], Field(description="The Zone ID for Filtering")] = None,
        site_id: Annotated[Optional[StrictInt], Field(description="The Site ID for Filtering")] = None,
        instance_id: Annotated[Optional[StrictInt], Field(description="The Instance ID for Filtering")] = None,
        container_id: Annotated[Optional[StrictInt], Field(description="The Container ID for Filtering")] = None,
        server_id: Annotated[Optional[StrictInt], Field(description="The Server ID for Filtering")] = None,
        user_id: Annotated[Optional[StrictInt], Field(description="Filter by User ID")] = None,
        project_id: Annotated[Optional[StrictInt], Field(description="The Project ID for Filtering")] = None,
        active: Annotated[Optional[StrictBool], Field(description="True or False flag for Active")] = None,
        account_id: Annotated[Optional[StrictInt], Field(description="Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.")] = None,
        include_totals: Annotated[Optional[StrictBool], Field(description="Pass true to include the summed totals (cost/price values) for all the invoices found in the query. The returned property is called `invoiceTotals`. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List All Invoice Line Items

        This endpoint retrieves a list of all invoice line items for the specified parameters.

        :param max: Maximum number of records to return
        :type max: int
        :param offset: Offset records, the number of records to skip, for paginating requests
        :type offset: int
        :param sort: Sort order, the name of the property to sort by
        :type sort: str
        :param direction: Sort direction, use 'desc' to reverse sort
        :type direction: str
        :param phrase: Search phrase for partial matches on name or description
        :type phrase: str
        :param name: Filter by name
        :type name: str
        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param period: Only return records for period that matches with the specified value. This is an alternative to using startDate/endDate. Format is YYYY or YYYYMM. 
        :type period: str
        :param ref_type: If specified will return an exact match on refType. 
        :type ref_type: str
        :param ref_id: If specified will return an exact match on refId
        :type ref_id: int
        :param zone_id: The Zone ID for Filtering
        :type zone_id: int
        :param site_id: The Site ID for Filtering
        :type site_id: int
        :param instance_id: The Instance ID for Filtering
        :type instance_id: int
        :param container_id: The Container ID for Filtering
        :type container_id: int
        :param server_id: The Server ID for Filtering
        :type server_id: int
        :param user_id: Filter by User ID
        :type user_id: int
        :param project_id: The Project ID for Filtering
        :type project_id: int
        :param active: True or False flag for Active
        :type active: bool
        :param account_id: Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.
        :type account_id: int
        :param include_totals: Pass true to include the summed totals (cost/price values) for all the invoices found in the query. The returned property is called `invoiceTotals`. 
        :type include_totals: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_invoice_line_items_serialize(
            max=max,
            offset=offset,
            sort=sort,
            direction=direction,
            phrase=phrase,
            name=name,
            start_date=start_date,
            end_date=end_date,
            period=period,
            ref_type=ref_type,
            ref_id=ref_id,
            zone_id=zone_id,
            site_id=site_id,
            instance_id=instance_id,
            container_id=container_id,
            server_id=server_id,
            user_id=user_id,
            project_id=project_id,
            active=active,
            account_id=account_id,
            include_totals=include_totals,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListInvoiceLineItems200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_invoice_line_items_serialize(
        self,
        max,
        offset,
        sort,
        direction,
        phrase,
        name,
        start_date,
        end_date,
        period,
        ref_type,
        ref_id,
        zone_id,
        site_id,
        instance_id,
        container_id,
        server_id,
        user_id,
        project_id,
        active,
        account_id,
        include_totals,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if max is not None:
            
            _query_params.append(('max', max))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if direction is not None:
            
            _query_params.append(('direction', direction))
            
        if phrase is not None:
            
            _query_params.append(('phrase', phrase))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if start_date is not None:
            
            _query_params.append(('startDate', start_date))
            
        if end_date is not None:
            
            _query_params.append(('endDate', end_date))
            
        if period is not None:
            
            _query_params.append(('period', period))
            
        if ref_type is not None:
            
            _query_params.append(('refType', ref_type))
            
        if ref_id is not None:
            
            _query_params.append(('refId', ref_id))
            
        if zone_id is not None:
            
            _query_params.append(('zoneId', zone_id))
            
        if site_id is not None:
            
            _query_params.append(('siteId', site_id))
            
        if instance_id is not None:
            
            _query_params.append(('instanceId', instance_id))
            
        if container_id is not None:
            
            _query_params.append(('containerId', container_id))
            
        if server_id is not None:
            
            _query_params.append(('serverId', server_id))
            
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if project_id is not None:
            
            _query_params.append(('projectId', project_id))
            
        if active is not None:
            
            _query_params.append(('active', active))
            
        if account_id is not None:
            
            _query_params.append(('accountId', account_id))
            
        if include_totals is not None:
            
            _query_params.append(('includeTotals', include_totals))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/invoice-line-items',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_invoices(
        self,
        max: Annotated[Optional[StrictInt], Field(description="Maximum number of records to return")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Offset records, the number of records to skip, for paginating requests")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order, the name of the property to sort by")] = None,
        direction: Annotated[Optional[StrictStr], Field(description="Sort direction, use 'desc' to reverse sort")] = None,
        phrase: Annotated[Optional[StrictStr], Field(description="Search phrase for partial matches on name or description")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Filter by name")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        period: Annotated[Optional[StrictStr], Field(description="Only return records for period that matches with the specified value. This is an alternative to using startDate/endDate. Format is YYYY or YYYYMM. ")] = None,
        ref_type: Annotated[Optional[StrictStr], Field(description="If specified will return an exact match on refType. ")] = None,
        ref_id: Annotated[Optional[StrictInt], Field(description="If specified will return an exact match on refId")] = None,
        ref_status: Annotated[Optional[StrictStr], Field(description="If specified, will filter on the associated StorageVolume status. This is only applicable whn `refType=StorageVolume`. ")] = None,
        zone_id: Annotated[Optional[StrictInt], Field(description="The Zone ID for Filtering")] = None,
        site_id: Annotated[Optional[StrictInt], Field(description="The Site ID for Filtering")] = None,
        instance_id: Annotated[Optional[StrictInt], Field(description="The Instance ID for Filtering")] = None,
        container_id: Annotated[Optional[StrictInt], Field(description="The Container ID for Filtering")] = None,
        server_id: Annotated[Optional[StrictInt], Field(description="The Server ID for Filtering")] = None,
        user_id: Annotated[Optional[StrictInt], Field(description="Filter by User ID")] = None,
        project_id: Annotated[Optional[StrictInt], Field(description="The Project ID for Filtering")] = None,
        active: Annotated[Optional[StrictBool], Field(description="True or False flag for Active")] = None,
        account_id: Annotated[Optional[StrictInt], Field(description="Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.")] = None,
        include_line_items: Annotated[Optional[StrictBool], Field(description="Pass true to include the list of `lineItems` for each invoice. Only `lineItemCount` is returned by default. ")] = None,
        include_totals: Annotated[Optional[StrictBool], Field(description="Pass true to include the summed totals (cost/price values) for all the invoices found in the query. The returned property is called `invoiceTotals`. ")] = None,
        tags_name: Annotated[Optional[StrictStr], Field(description="Filter by tags (metadata). This allows filtering by a tag name and value(s) ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListInvoices200Response:
        """List All Invoices

        This endpoint retrieves a list of invoices for the specified parameters.

        :param max: Maximum number of records to return
        :type max: int
        :param offset: Offset records, the number of records to skip, for paginating requests
        :type offset: int
        :param sort: Sort order, the name of the property to sort by
        :type sort: str
        :param direction: Sort direction, use 'desc' to reverse sort
        :type direction: str
        :param phrase: Search phrase for partial matches on name or description
        :type phrase: str
        :param name: Filter by name
        :type name: str
        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param period: Only return records for period that matches with the specified value. This is an alternative to using startDate/endDate. Format is YYYY or YYYYMM. 
        :type period: str
        :param ref_type: If specified will return an exact match on refType. 
        :type ref_type: str
        :param ref_id: If specified will return an exact match on refId
        :type ref_id: int
        :param ref_status: If specified, will filter on the associated StorageVolume status. This is only applicable whn `refType=StorageVolume`. 
        :type ref_status: str
        :param zone_id: The Zone ID for Filtering
        :type zone_id: int
        :param site_id: The Site ID for Filtering
        :type site_id: int
        :param instance_id: The Instance ID for Filtering
        :type instance_id: int
        :param container_id: The Container ID for Filtering
        :type container_id: int
        :param server_id: The Server ID for Filtering
        :type server_id: int
        :param user_id: Filter by User ID
        :type user_id: int
        :param project_id: The Project ID for Filtering
        :type project_id: int
        :param active: True or False flag for Active
        :type active: bool
        :param account_id: Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.
        :type account_id: int
        :param include_line_items: Pass true to include the list of `lineItems` for each invoice. Only `lineItemCount` is returned by default. 
        :type include_line_items: bool
        :param include_totals: Pass true to include the summed totals (cost/price values) for all the invoices found in the query. The returned property is called `invoiceTotals`. 
        :type include_totals: bool
        :param tags_name: Filter by tags (metadata). This allows filtering by a tag name and value(s) 
        :type tags_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_invoices_serialize(
            max=max,
            offset=offset,
            sort=sort,
            direction=direction,
            phrase=phrase,
            name=name,
            start_date=start_date,
            end_date=end_date,
            period=period,
            ref_type=ref_type,
            ref_id=ref_id,
            ref_status=ref_status,
            zone_id=zone_id,
            site_id=site_id,
            instance_id=instance_id,
            container_id=container_id,
            server_id=server_id,
            user_id=user_id,
            project_id=project_id,
            active=active,
            account_id=account_id,
            include_line_items=include_line_items,
            include_totals=include_totals,
            tags_name=tags_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListInvoices200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_invoices_with_http_info(
        self,
        max: Annotated[Optional[StrictInt], Field(description="Maximum number of records to return")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Offset records, the number of records to skip, for paginating requests")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order, the name of the property to sort by")] = None,
        direction: Annotated[Optional[StrictStr], Field(description="Sort direction, use 'desc' to reverse sort")] = None,
        phrase: Annotated[Optional[StrictStr], Field(description="Search phrase for partial matches on name or description")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Filter by name")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        period: Annotated[Optional[StrictStr], Field(description="Only return records for period that matches with the specified value. This is an alternative to using startDate/endDate. Format is YYYY or YYYYMM. ")] = None,
        ref_type: Annotated[Optional[StrictStr], Field(description="If specified will return an exact match on refType. ")] = None,
        ref_id: Annotated[Optional[StrictInt], Field(description="If specified will return an exact match on refId")] = None,
        ref_status: Annotated[Optional[StrictStr], Field(description="If specified, will filter on the associated StorageVolume status. This is only applicable whn `refType=StorageVolume`. ")] = None,
        zone_id: Annotated[Optional[StrictInt], Field(description="The Zone ID for Filtering")] = None,
        site_id: Annotated[Optional[StrictInt], Field(description="The Site ID for Filtering")] = None,
        instance_id: Annotated[Optional[StrictInt], Field(description="The Instance ID for Filtering")] = None,
        container_id: Annotated[Optional[StrictInt], Field(description="The Container ID for Filtering")] = None,
        server_id: Annotated[Optional[StrictInt], Field(description="The Server ID for Filtering")] = None,
        user_id: Annotated[Optional[StrictInt], Field(description="Filter by User ID")] = None,
        project_id: Annotated[Optional[StrictInt], Field(description="The Project ID for Filtering")] = None,
        active: Annotated[Optional[StrictBool], Field(description="True or False flag for Active")] = None,
        account_id: Annotated[Optional[StrictInt], Field(description="Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.")] = None,
        include_line_items: Annotated[Optional[StrictBool], Field(description="Pass true to include the list of `lineItems` for each invoice. Only `lineItemCount` is returned by default. ")] = None,
        include_totals: Annotated[Optional[StrictBool], Field(description="Pass true to include the summed totals (cost/price values) for all the invoices found in the query. The returned property is called `invoiceTotals`. ")] = None,
        tags_name: Annotated[Optional[StrictStr], Field(description="Filter by tags (metadata). This allows filtering by a tag name and value(s) ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListInvoices200Response]:
        """List All Invoices

        This endpoint retrieves a list of invoices for the specified parameters.

        :param max: Maximum number of records to return
        :type max: int
        :param offset: Offset records, the number of records to skip, for paginating requests
        :type offset: int
        :param sort: Sort order, the name of the property to sort by
        :type sort: str
        :param direction: Sort direction, use 'desc' to reverse sort
        :type direction: str
        :param phrase: Search phrase for partial matches on name or description
        :type phrase: str
        :param name: Filter by name
        :type name: str
        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param period: Only return records for period that matches with the specified value. This is an alternative to using startDate/endDate. Format is YYYY or YYYYMM. 
        :type period: str
        :param ref_type: If specified will return an exact match on refType. 
        :type ref_type: str
        :param ref_id: If specified will return an exact match on refId
        :type ref_id: int
        :param ref_status: If specified, will filter on the associated StorageVolume status. This is only applicable whn `refType=StorageVolume`. 
        :type ref_status: str
        :param zone_id: The Zone ID for Filtering
        :type zone_id: int
        :param site_id: The Site ID for Filtering
        :type site_id: int
        :param instance_id: The Instance ID for Filtering
        :type instance_id: int
        :param container_id: The Container ID for Filtering
        :type container_id: int
        :param server_id: The Server ID for Filtering
        :type server_id: int
        :param user_id: Filter by User ID
        :type user_id: int
        :param project_id: The Project ID for Filtering
        :type project_id: int
        :param active: True or False flag for Active
        :type active: bool
        :param account_id: Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.
        :type account_id: int
        :param include_line_items: Pass true to include the list of `lineItems` for each invoice. Only `lineItemCount` is returned by default. 
        :type include_line_items: bool
        :param include_totals: Pass true to include the summed totals (cost/price values) for all the invoices found in the query. The returned property is called `invoiceTotals`. 
        :type include_totals: bool
        :param tags_name: Filter by tags (metadata). This allows filtering by a tag name and value(s) 
        :type tags_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_invoices_serialize(
            max=max,
            offset=offset,
            sort=sort,
            direction=direction,
            phrase=phrase,
            name=name,
            start_date=start_date,
            end_date=end_date,
            period=period,
            ref_type=ref_type,
            ref_id=ref_id,
            ref_status=ref_status,
            zone_id=zone_id,
            site_id=site_id,
            instance_id=instance_id,
            container_id=container_id,
            server_id=server_id,
            user_id=user_id,
            project_id=project_id,
            active=active,
            account_id=account_id,
            include_line_items=include_line_items,
            include_totals=include_totals,
            tags_name=tags_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListInvoices200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_invoices_without_preload_content(
        self,
        max: Annotated[Optional[StrictInt], Field(description="Maximum number of records to return")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Offset records, the number of records to skip, for paginating requests")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order, the name of the property to sort by")] = None,
        direction: Annotated[Optional[StrictStr], Field(description="Sort direction, use 'desc' to reverse sort")] = None,
        phrase: Annotated[Optional[StrictStr], Field(description="Search phrase for partial matches on name or description")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Filter by name")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        period: Annotated[Optional[StrictStr], Field(description="Only return records for period that matches with the specified value. This is an alternative to using startDate/endDate. Format is YYYY or YYYYMM. ")] = None,
        ref_type: Annotated[Optional[StrictStr], Field(description="If specified will return an exact match on refType. ")] = None,
        ref_id: Annotated[Optional[StrictInt], Field(description="If specified will return an exact match on refId")] = None,
        ref_status: Annotated[Optional[StrictStr], Field(description="If specified, will filter on the associated StorageVolume status. This is only applicable whn `refType=StorageVolume`. ")] = None,
        zone_id: Annotated[Optional[StrictInt], Field(description="The Zone ID for Filtering")] = None,
        site_id: Annotated[Optional[StrictInt], Field(description="The Site ID for Filtering")] = None,
        instance_id: Annotated[Optional[StrictInt], Field(description="The Instance ID for Filtering")] = None,
        container_id: Annotated[Optional[StrictInt], Field(description="The Container ID for Filtering")] = None,
        server_id: Annotated[Optional[StrictInt], Field(description="The Server ID for Filtering")] = None,
        user_id: Annotated[Optional[StrictInt], Field(description="Filter by User ID")] = None,
        project_id: Annotated[Optional[StrictInt], Field(description="The Project ID for Filtering")] = None,
        active: Annotated[Optional[StrictBool], Field(description="True or False flag for Active")] = None,
        account_id: Annotated[Optional[StrictInt], Field(description="Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.")] = None,
        include_line_items: Annotated[Optional[StrictBool], Field(description="Pass true to include the list of `lineItems` for each invoice. Only `lineItemCount` is returned by default. ")] = None,
        include_totals: Annotated[Optional[StrictBool], Field(description="Pass true to include the summed totals (cost/price values) for all the invoices found in the query. The returned property is called `invoiceTotals`. ")] = None,
        tags_name: Annotated[Optional[StrictStr], Field(description="Filter by tags (metadata). This allows filtering by a tag name and value(s) ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List All Invoices

        This endpoint retrieves a list of invoices for the specified parameters.

        :param max: Maximum number of records to return
        :type max: int
        :param offset: Offset records, the number of records to skip, for paginating requests
        :type offset: int
        :param sort: Sort order, the name of the property to sort by
        :type sort: str
        :param direction: Sort direction, use 'desc' to reverse sort
        :type direction: str
        :param phrase: Search phrase for partial matches on name or description
        :type phrase: str
        :param name: Filter by name
        :type name: str
        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param period: Only return records for period that matches with the specified value. This is an alternative to using startDate/endDate. Format is YYYY or YYYYMM. 
        :type period: str
        :param ref_type: If specified will return an exact match on refType. 
        :type ref_type: str
        :param ref_id: If specified will return an exact match on refId
        :type ref_id: int
        :param ref_status: If specified, will filter on the associated StorageVolume status. This is only applicable whn `refType=StorageVolume`. 
        :type ref_status: str
        :param zone_id: The Zone ID for Filtering
        :type zone_id: int
        :param site_id: The Site ID for Filtering
        :type site_id: int
        :param instance_id: The Instance ID for Filtering
        :type instance_id: int
        :param container_id: The Container ID for Filtering
        :type container_id: int
        :param server_id: The Server ID for Filtering
        :type server_id: int
        :param user_id: Filter by User ID
        :type user_id: int
        :param project_id: The Project ID for Filtering
        :type project_id: int
        :param active: True or False flag for Active
        :type active: bool
        :param account_id: Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.
        :type account_id: int
        :param include_line_items: Pass true to include the list of `lineItems` for each invoice. Only `lineItemCount` is returned by default. 
        :type include_line_items: bool
        :param include_totals: Pass true to include the summed totals (cost/price values) for all the invoices found in the query. The returned property is called `invoiceTotals`. 
        :type include_totals: bool
        :param tags_name: Filter by tags (metadata). This allows filtering by a tag name and value(s) 
        :type tags_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_invoices_serialize(
            max=max,
            offset=offset,
            sort=sort,
            direction=direction,
            phrase=phrase,
            name=name,
            start_date=start_date,
            end_date=end_date,
            period=period,
            ref_type=ref_type,
            ref_id=ref_id,
            ref_status=ref_status,
            zone_id=zone_id,
            site_id=site_id,
            instance_id=instance_id,
            container_id=container_id,
            server_id=server_id,
            user_id=user_id,
            project_id=project_id,
            active=active,
            account_id=account_id,
            include_line_items=include_line_items,
            include_totals=include_totals,
            tags_name=tags_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListInvoices200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_invoices_serialize(
        self,
        max,
        offset,
        sort,
        direction,
        phrase,
        name,
        start_date,
        end_date,
        period,
        ref_type,
        ref_id,
        ref_status,
        zone_id,
        site_id,
        instance_id,
        container_id,
        server_id,
        user_id,
        project_id,
        active,
        account_id,
        include_line_items,
        include_totals,
        tags_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if max is not None:
            
            _query_params.append(('max', max))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if direction is not None:
            
            _query_params.append(('direction', direction))
            
        if phrase is not None:
            
            _query_params.append(('phrase', phrase))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if start_date is not None:
            
            _query_params.append(('startDate', start_date))
            
        if end_date is not None:
            
            _query_params.append(('endDate', end_date))
            
        if period is not None:
            
            _query_params.append(('period', period))
            
        if ref_type is not None:
            
            _query_params.append(('refType', ref_type))
            
        if ref_id is not None:
            
            _query_params.append(('refId', ref_id))
            
        if ref_status is not None:
            
            _query_params.append(('refStatus', ref_status))
            
        if zone_id is not None:
            
            _query_params.append(('zoneId', zone_id))
            
        if site_id is not None:
            
            _query_params.append(('siteId', site_id))
            
        if instance_id is not None:
            
            _query_params.append(('instanceId', instance_id))
            
        if container_id is not None:
            
            _query_params.append(('containerId', container_id))
            
        if server_id is not None:
            
            _query_params.append(('serverId', server_id))
            
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if project_id is not None:
            
            _query_params.append(('projectId', project_id))
            
        if active is not None:
            
            _query_params.append(('active', active))
            
        if account_id is not None:
            
            _query_params.append(('accountId', account_id))
            
        if include_line_items is not None:
            
            _query_params.append(('includeLineItems', include_line_items))
            
        if include_totals is not None:
            
            _query_params.append(('includeTotals', include_totals))
            
        if tags_name is not None:
            
            _query_params.append(('tags.name', tags_name))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/invoices',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_invoices(
        self,
        id: Annotated[StrictInt, Field(description="Morpheus ID of the Object being referenced")],
        update_invoices_request: Optional[UpdateInvoicesRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UpdateInvoices200Response:
        """Update Invoice Tags

        Update, Add, or Remove invoice tag(s).

        :param id: Morpheus ID of the Object being referenced (required)
        :type id: int
        :param update_invoices_request:
        :type update_invoices_request: UpdateInvoicesRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_invoices_serialize(
            id=id,
            update_invoices_request=update_invoices_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateInvoices200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_invoices_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="Morpheus ID of the Object being referenced")],
        update_invoices_request: Optional[UpdateInvoicesRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UpdateInvoices200Response]:
        """Update Invoice Tags

        Update, Add, or Remove invoice tag(s).

        :param id: Morpheus ID of the Object being referenced (required)
        :type id: int
        :param update_invoices_request:
        :type update_invoices_request: UpdateInvoicesRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_invoices_serialize(
            id=id,
            update_invoices_request=update_invoices_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateInvoices200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_invoices_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="Morpheus ID of the Object being referenced")],
        update_invoices_request: Optional[UpdateInvoicesRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update Invoice Tags

        Update, Add, or Remove invoice tag(s).

        :param id: Morpheus ID of the Object being referenced (required)
        :type id: int
        :param update_invoices_request:
        :type update_invoices_request: UpdateInvoicesRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_invoices_serialize(
            id=id,
            update_invoices_request=update_invoices_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateInvoices200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_invoices_serialize(
        self,
        id,
        update_invoices_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_invoices_request is not None:
            _body_params = update_invoices_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/invoices/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


