# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_cloud_resource_pool_request_resource_pool_config import AddCloudResourcePoolRequestResourcePoolConfig
from morpheus.models.add_cloud_resource_pool_request_resource_pool_tenant_permissions import AddCloudResourcePoolRequestResourcePoolTenantPermissions
from morpheus.models.update_cloud_datastores_request_datastore_resource_permissions import UpdateCloudDatastoresRequestDatastoreResourcePermissions
from typing import Optional, Set
from typing_extensions import Self

class AddCloudResourcePoolRequestResourcePool(BaseModel):
    """
    AddCloudResourcePoolRequestResourcePool
    """ # noqa: E501
    name: StrictStr = Field(description="Name of Resource Pool")
    default_pool: Optional[StrictBool] = Field(default=False, description="Set as the Default Pool", alias="defaultPool")
    default_image: Optional[StrictBool] = Field(default=False, description="Set as the Default Image Target", alias="defaultImage")
    active: Optional[StrictBool] = Field(default=True, description="Activate `true` or disable `false` the datastore")
    visibility: Optional[StrictStr] = Field(default='private', description="Setting `private` or `public`")
    display_name: Optional[StrictStr] = Field(default=None, description="Optional Display Name (VMware only)", alias="displayName")
    inventory: Optional[StrictBool] = Field(default=True, description="Enable `True` or disable `False` inventory sync for resource pool during cloud refresh")
    config: AddCloudResourcePoolRequestResourcePoolConfig
    tenant_permissions: Optional[AddCloudResourcePoolRequestResourcePoolTenantPermissions] = Field(default=None, alias="tenantPermissions")
    resource_permissions: Optional[UpdateCloudDatastoresRequestDatastoreResourcePermissions] = Field(default=None, alias="resourcePermissions")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "defaultPool", "defaultImage", "active", "visibility", "displayName", "inventory", "config", "tenantPermissions", "resourcePermissions"]

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['public', 'private']):
            raise ValueError("must be one of enum values ('public', 'private')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddCloudResourcePoolRequestResourcePool from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tenant_permissions
        if self.tenant_permissions:
            _dict['tenantPermissions'] = self.tenant_permissions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of resource_permissions
        if self.resource_permissions:
            _dict['resourcePermissions'] = self.resource_permissions.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddCloudResourcePoolRequestResourcePool from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "defaultPool": obj.get("defaultPool") if obj.get("defaultPool") is not None else False,
            "defaultImage": obj.get("defaultImage") if obj.get("defaultImage") is not None else False,
            "active": obj.get("active") if obj.get("active") is not None else True,
            "visibility": obj.get("visibility") if obj.get("visibility") is not None else 'private',
            "displayName": obj.get("displayName"),
            "inventory": obj.get("inventory") if obj.get("inventory") is not None else True,
            "config": AddCloudResourcePoolRequestResourcePoolConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "tenantPermissions": AddCloudResourcePoolRequestResourcePoolTenantPermissions.from_dict(obj["tenantPermissions"]) if obj.get("tenantPermissions") is not None else None,
            "resourcePermissions": UpdateCloudDatastoresRequestDatastoreResourcePermissions.from_dict(obj["resourcePermissions"]) if obj.get("resourcePermissions") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


