# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_clouds_request_zone_credential import AddCloudsRequestZoneCredential
from morpheus.models.add_clouds_request_zone_zone_type import AddCloudsRequestZoneZoneType
from typing import Optional, Set
from typing_extensions import Self

class AddCloudsRequestZone(BaseModel):
    """
    AddCloudsRequestZone
    """ # noqa: E501
    name: StrictStr = Field(description="A unique name scoped to your account for the cloud")
    description: Optional[StrictStr] = Field(default=None, description="Optional description field if you want to put more info there")
    code: Optional[StrictStr] = Field(default=None, description="Optional code for use with policies")
    labels: Optional[List[StrictStr]] = Field(default=None, description="Array of label strings, can be used for filtering.")
    location: Optional[StrictStr] = Field(default=None, description="Optional location for your cloud")
    visibility: Optional[StrictStr] = Field(default='private', description="private or public")
    zone_type: AddCloudsRequestZoneZoneType = Field(alias="zoneType")
    group_id: StrictInt = Field(description="Specifies which Server group this cloud should be assigned to", alias="groupId")
    account_id: Optional[StrictInt] = Field(default=None, description="Specifies which Tenant this cloud should be assigned to", alias="accountId")
    enabled: Optional[StrictBool] = Field(default=True, description="Can be used to disable the cloud")
    auto_recover_power_state: Optional[StrictBool] = Field(default=False, description="Automatically Power on VMs", alias="autoRecoverPowerState")
    scale_priority: Optional[StrictInt] = Field(default=1, description="Scale Priority", alias="scalePriority")
    default_datastore_sync_active: Optional[StrictBool] = Field(default=None, description="Sets the default active state during discovery of new datastores.", alias="defaultDatastoreSyncActive")
    default_network_sync_active: Optional[StrictBool] = Field(default=None, description="Sets the default active state during discovery of new networks.", alias="defaultNetworkSyncActive")
    default_folder_sync_active: Optional[StrictBool] = Field(default=None, description="Sets the default active state during discovery of new folders.", alias="defaultFolderSyncActive")
    default_security_group_sync_active: Optional[StrictBool] = Field(default=None, description="Sets the default active state during discovery of new security groups.", alias="defaultSecurityGroupSyncActive")
    default_pool_sync_active: Optional[StrictBool] = Field(default=None, description="Sets the default active state during discovery of new resource pools.", alias="defaultPoolSyncActive")
    default_plan_sync_active: Optional[StrictBool] = Field(default=None, description="Sets the default active state during discovery of new plans.", alias="defaultPlanSyncActive")
    linked_account_id: Optional[StrictInt] = Field(default=None, description="Linked Account ID (enter commercial ID to get costing for AWS Govcloud)", alias="linkedAccountId")
    config: Optional[Dict[str, Any]] = Field(default=None, description="Map containing zone configuration settings. See the section on specific zone types for details.")
    security_mode: Optional[StrictStr] = Field(default='off', description="host firewall. `off` or `internal`. a.k.a. \"local firewall\"", alias="securityMode")
    credential: Optional[AddCloudsRequestZoneCredential] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "description", "code", "labels", "location", "visibility", "zoneType", "groupId", "accountId", "enabled", "autoRecoverPowerState", "scalePriority", "defaultDatastoreSyncActive", "defaultNetworkSyncActive", "defaultFolderSyncActive", "defaultSecurityGroupSyncActive", "defaultPoolSyncActive", "defaultPlanSyncActive", "linkedAccountId", "config", "securityMode", "credential"]

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['private', 'public']):
            raise ValueError("must be one of enum values ('private', 'public')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddCloudsRequestZone from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of zone_type
        if self.zone_type:
            _dict['zoneType'] = self.zone_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of credential
        if self.credential:
            _dict['credential'] = self.credential.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if location (nullable) is None
        # and model_fields_set contains the field
        if self.location is None and "location" in self.model_fields_set:
            _dict['location'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddCloudsRequestZone from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "code": obj.get("code"),
            "labels": obj.get("labels"),
            "location": obj.get("location"),
            "visibility": obj.get("visibility") if obj.get("visibility") is not None else 'private',
            "zoneType": AddCloudsRequestZoneZoneType.from_dict(obj["zoneType"]) if obj.get("zoneType") is not None else None,
            "groupId": obj.get("groupId"),
            "accountId": obj.get("accountId"),
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "autoRecoverPowerState": obj.get("autoRecoverPowerState") if obj.get("autoRecoverPowerState") is not None else False,
            "scalePriority": obj.get("scalePriority") if obj.get("scalePriority") is not None else 1,
            "defaultDatastoreSyncActive": obj.get("defaultDatastoreSyncActive"),
            "defaultNetworkSyncActive": obj.get("defaultNetworkSyncActive"),
            "defaultFolderSyncActive": obj.get("defaultFolderSyncActive"),
            "defaultSecurityGroupSyncActive": obj.get("defaultSecurityGroupSyncActive"),
            "defaultPoolSyncActive": obj.get("defaultPoolSyncActive"),
            "defaultPlanSyncActive": obj.get("defaultPlanSyncActive"),
            "linkedAccountId": obj.get("linkedAccountId"),
            "config": obj.get("config"),
            "securityMode": obj.get("securityMode") if obj.get("securityMode") is not None else 'off',
            "credential": AddCloudsRequestZoneCredential.from_dict(obj["credential"]) if obj.get("credential") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


