# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_identity_sources_request_user_source_account import AddIdentitySourcesRequestUserSourceAccount
from morpheus.models.add_identity_sources_request_user_source_config import AddIdentitySourcesRequestUserSourceConfig
from morpheus.models.add_identity_sources_request_user_source_default_account_role import AddIdentitySourcesRequestUserSourceDefaultAccountRole
from morpheus.models.add_identity_sources_request_user_source_role_mappings import AddIdentitySourcesRequestUserSourceRoleMappings
from typing import Optional, Set
from typing_extensions import Self

class AddIdentitySourcesRequestUserSource(BaseModel):
    """
    AddIdentitySourcesRequestUserSource
    """ # noqa: E501
    account: Optional[AddIdentitySourcesRequestUserSourceAccount] = None
    name: StrictStr = Field(description="A name for the Identity Source")
    type: StrictStr = Field(description="IDM type code")
    description: Optional[StrictStr] = Field(default=None, description="description")
    default_account_role: Optional[AddIdentitySourcesRequestUserSourceDefaultAccountRole] = Field(default=None, alias="defaultAccountRole")
    role_mappings: Optional[AddIdentitySourcesRequestUserSourceRoleMappings] = Field(default=None, alias="roleMappings")
    role_mapping_names: Optional[Dict[str, StrictStr]] = Field(default=None, description="Map of Morpheus '`Role ID`':'`Role Name`'. ", alias="roleMappingNames")
    allow_custom_mappings: Optional[StrictBool] = Field(default=None, description="Enable Role Mapping Permission", alias="allowCustomMappings")
    manual_role_assignment: Optional[StrictBool] = Field(default=None, description="Manual Role Assignment", alias="manualRoleAssignment")
    config: Optional[AddIdentitySourcesRequestUserSourceConfig] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["account", "name", "type", "description", "defaultAccountRole", "roleMappings", "roleMappingNames", "allowCustomMappings", "manualRoleAssignment", "config"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddIdentitySourcesRequestUserSource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of default_account_role
        if self.default_account_role:
            _dict['defaultAccountRole'] = self.default_account_role.to_dict()
        # override the default output from pydantic by calling `to_dict()` of role_mappings
        if self.role_mappings:
            _dict['roleMappings'] = self.role_mappings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddIdentitySourcesRequestUserSource from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "account": AddIdentitySourcesRequestUserSourceAccount.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "name": obj.get("name"),
            "type": obj.get("type"),
            "description": obj.get("description"),
            "defaultAccountRole": AddIdentitySourcesRequestUserSourceDefaultAccountRole.from_dict(obj["defaultAccountRole"]) if obj.get("defaultAccountRole") is not None else None,
            "roleMappings": AddIdentitySourcesRequestUserSourceRoleMappings.from_dict(obj["roleMappings"]) if obj.get("roleMappings") is not None else None,
            "roleMappingNames": obj.get("roleMappingNames"),
            "allowCustomMappings": obj.get("allowCustomMappings"),
            "manualRoleAssignment": obj.get("manualRoleAssignment"),
            "config": AddIdentitySourcesRequestUserSourceConfig.from_dict(obj["config"]) if obj.get("config") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


